/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JComboBox;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.format.Formatting;
import org.fest.util.Strings;

final class JComboBoxAccessibleEditorValidator {
    @RunsInCurrentThread
    static void validateEditorIsAccessible(JComboBox comboBox) {
        ComponentStateValidator.validateIsEnabledAndShowing(comboBox);
        if (!comboBox.isEditable()) {
            throw new IllegalStateException(Strings.concat((Object[])new Object[]{"Expecting component ", Formatting.format(comboBox), " to be editable"}));
        }
    }

    private JComboBoxAccessibleEditorValidator() {
    }
}

