/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.UpdateScope;
import org.codehaus.mojo.versions.utils.DependencyComparator;

public class DependencyUpdatesXmlRenderer {
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String SCOPE = "scope";
    private static final String CLASSIFIER = "classifier";
    private static final String TYPE = "type";
    private static final String CURRENT_VERSION = "currentVersion";
    private static final String NEXT_VERSION = "nextVersion";
    private static final String STATUS = "status";
    private static final String OPEN_TAG = "<";
    private static final String CLOSE_TAG = ">";
    private static final String OPEN_CLOSING_TAG = "</";
    private static final String NL = "\n";
    private static final String TAB = "\t";
    private Map<Dependency, ArtifactVersions> dependencyUpdates;
    private Map<Dependency, ArtifactVersions> dependencyManagementUpdates;
    private String outputFileName;

    public DependencyUpdatesXmlRenderer(Map<Dependency, ArtifactVersions> dependencyUpdates, Map<Dependency, ArtifactVersions> dependencyManagementUpdates, String outputFileName) {
        this.dependencyUpdates = dependencyUpdates;
        this.dependencyManagementUpdates = dependencyManagementUpdates;
        this.outputFileName = outputFileName;
    }

    public void render() throws MavenReportException {
        StringBuilder sb = new StringBuilder();
        sb.append("<DependencyUpdatesReport>").append(NL);
        TreeMap<Dependency, ArtifactVersions> allUpdates = new TreeMap<Dependency, ArtifactVersions>(new DependencyComparator());
        allUpdates.putAll(this.dependencyManagementUpdates);
        allUpdates.putAll(this.dependencyUpdates);
        sb.append(DependencyUpdatesXmlRenderer.getSummaryBlock(allUpdates.values()));
        sb.append(DependencyUpdatesXmlRenderer.getDependencyInfoBlock(this.dependencyManagementUpdates, "dependencyManagements", "dependencyManagement"));
        sb.append(DependencyUpdatesXmlRenderer.getDependencyInfoBlock(this.dependencyUpdates, "dependencies", "dependency"));
        sb.append("</DependencyUpdatesReport>").append(NL);
        try {
            PrintWriter pw = new PrintWriter(this.outputFileName, "UTF8");
            pw.print(sb.toString());
            pw.close();
        }
        catch (IOException e) {
            throw new MavenReportException("Cannot create xml report.", (Exception)e);
        }
    }

    public static String wrapElement(String value, String tag) {
        return OPEN_TAG + tag + CLOSE_TAG + value + OPEN_CLOSING_TAG + tag + CLOSE_TAG;
    }

    public static String getSummaryBlock(Collection<ArtifactVersions> allUpdates) {
        int numInc = 0;
        int numMin = 0;
        int numMaj = 0;
        int numAny = 0;
        int numCur = 0;
        for (ArtifactVersions details : allUpdates) {
            if (details.getOldestUpdate(UpdateScope.SUBINCREMENTAL) != null) {
                ++numAny;
                continue;
            }
            if (details.getOldestUpdate(UpdateScope.INCREMENTAL) != null) {
                ++numInc;
                continue;
            }
            if (details.getOldestUpdate(UpdateScope.MINOR) != null) {
                ++numMin;
                continue;
            }
            if (details.getOldestUpdate(UpdateScope.MAJOR) != null) {
                ++numMaj;
                continue;
            }
            ++numCur;
        }
        String result = "\t<summary>%n\t\t<usingLastVersion>%d</usingLastVersion>%n\t\t<nextVersionAlailable>%d</nextVersionAlailable>%n\t\t<nextIncremetalAvailable>%d</nextIncremetalAvailable>%n\t\t<nextMinorAvailable>%d</nextMinorAvailable>%n\t\t<nextMajorAvailable>%d</nextMajorAvailable>%n\t</summary>%n";
        return String.format(result, numCur, numAny, numInc, numMin, numMaj);
    }

    public static String getVersionsBlocks(ArtifactVersions versions) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(TAB).append(TAB).append(TAB).append(DependencyUpdatesXmlRenderer.wrapElement(versions.getCurrentVersion().toString(), CURRENT_VERSION)).append(NL);
        ArtifactVersion nextVersion = versions.getOldestUpdate(UpdateScope.ANY);
        if (nextVersion != null) {
            sBuilder.append(TAB).append(TAB).append(TAB).append(DependencyUpdatesXmlRenderer.wrapElement(nextVersion.toString(), NEXT_VERSION)).append(NL);
            String incrementalsBlock = DependencyUpdatesXmlRenderer.getVersionsInScopeBlock(versions, UpdateScope.INCREMENTAL);
            sBuilder.append(incrementalsBlock);
            String minorsBlock = DependencyUpdatesXmlRenderer.getVersionsInScopeBlock(versions, UpdateScope.MINOR);
            sBuilder.append(minorsBlock);
            String majorsBlock = DependencyUpdatesXmlRenderer.getVersionsInScopeBlock(versions, UpdateScope.MAJOR);
            sBuilder.append(majorsBlock);
            String status = null;
            if (incrementalsBlock.length() > 0) {
                status = "incremental available";
            } else if (minorsBlock.length() > 0) {
                status = "minor available";
            } else if (majorsBlock.length() > 0) {
                status = "major available";
            }
            sBuilder.append(TAB).append(TAB).append(TAB).append(DependencyUpdatesXmlRenderer.wrapElement(status, STATUS)).append(NL);
        } else {
            sBuilder.append(TAB).append(TAB).append(TAB).append(DependencyUpdatesXmlRenderer.wrapElement("no new available", STATUS)).append(NL);
        }
        return sBuilder.toString();
    }

    private static String getDependencyInfoBlock(Map<Dependency, ArtifactVersions> dependencyUpdates, String blockName, String subblockName) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(TAB).append(OPEN_TAG).append(blockName).append(CLOSE_TAG).append(NL);
        for (Map.Entry<Dependency, ArtifactVersions> entry : dependencyUpdates.entrySet()) {
            sBuilder.append(TAB).append(TAB).append(OPEN_TAG).append(subblockName).append(CLOSE_TAG).append(NL);
            Dependency dep = entry.getKey();
            sBuilder.append(TAB).append(TAB).append(TAB).append(DependencyUpdatesXmlRenderer.wrapElement(dep.getGroupId(), GROUP_ID)).append(NL);
            sBuilder.append(TAB).append(TAB).append(TAB).append(DependencyUpdatesXmlRenderer.wrapElement(dep.getArtifactId(), ARTIFACT_ID)).append(NL);
            sBuilder.append(TAB).append(TAB).append(TAB).append(DependencyUpdatesXmlRenderer.wrapElement(dep.getScope(), SCOPE)).append(NL);
            sBuilder.append(TAB).append(TAB).append(TAB).append(DependencyUpdatesXmlRenderer.wrapElement(dep.getClassifier(), CLASSIFIER)).append(NL);
            sBuilder.append(TAB).append(TAB).append(TAB).append(DependencyUpdatesXmlRenderer.wrapElement(dep.getType(), TYPE)).append(NL);
            sBuilder.append(DependencyUpdatesXmlRenderer.getVersionsBlocks(entry.getValue()));
            sBuilder.append(TAB).append(TAB).append(OPEN_CLOSING_TAG).append(subblockName).append(CLOSE_TAG).append(NL);
        }
        sBuilder.append(TAB).append(OPEN_CLOSING_TAG).append(blockName).append(CLOSE_TAG).append(NL);
        return sBuilder.toString();
    }

    private static String getVersionsInScopeBlock(ArtifactVersions av, UpdateScope scope) {
        String versionsTag = scope.toString().toLowerCase() + "s";
        StringBuilder sBuilder = new StringBuilder();
        ArtifactVersion nextVersion = av.getOldestUpdate(scope);
        if (nextVersion != null) {
            ArtifactVersion[] versions;
            sBuilder.append(TAB).append(TAB).append(TAB).append(OPEN_TAG).append(versionsTag).append(CLOSE_TAG).append(NL);
            for (ArtifactVersion version : versions = av.getAllUpdates(scope)) {
                sBuilder.append(TAB).append(TAB).append(TAB).append(TAB).append(DependencyUpdatesXmlRenderer.wrapElement(version.toString(), scope.toString().toLowerCase())).append(NL);
            }
            sBuilder.append(TAB).append(TAB).append(TAB).append(OPEN_CLOSING_TAG).append(versionsTag).append(CLOSE_TAG).append(NL);
        }
        return sBuilder.toString();
    }
}

