/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.api;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeMarkerHelper {
    protected final Configuration freemarkerConfiguration = new Configuration();
    protected final TemplateLoader classLoader = new ClassTemplateLoader(this.getClass(), "/");

    public FreeMarkerHelper() {
        this.freemarkerConfiguration.setTemplateLoader(this.classLoader);
        DefaultObjectWrapper objectWrapper = new DefaultObjectWrapper();
        this.freemarkerConfiguration.setObjectWrapper((ObjectWrapper)objectWrapper);
    }

    public Template getTemplate(String templateName) throws IOException {
        File file = new File(templateName);
        if (file.exists()) {
            this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)new FileTemplateLoader(file.getParentFile()));
            templateName = file.getName();
        } else {
            this.freemarkerConfiguration.setTemplateLoader(this.classLoader);
        }
        Template template = this.freemarkerConfiguration.getTemplate(templateName);
        if (template == null) {
            throw new IOException("Could not find template " + templateName);
        }
        return template;
    }

    public String renderTemplate(String templateName, Map<String, Object> parameters) throws IOException {
        Template template = this.getTemplate(templateName);
        return this.renderTemplate(template, parameters);
    }

    public String renderTemplate(Template template, Map<String, Object> parameters) throws IOException {
        StringWriter out = new StringWriter();
        try {
            template.process(parameters, (Writer)out);
        }
        catch (TemplateException e) {
            throw new IOException("Could not render template " + template.getName() + " for reason " + e.getMessage());
        }
        return out.toString();
    }
}

