/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import org.checkerframework.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;

public class FloatingDivisionNode
extends BinaryOperationNode {
    public FloatingDivisionNode(BinaryTree tree, Node left, Node right) {
        super(tree, left, right);
        assert (tree.getKind() == Tree.Kind.DIVIDE);
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitFloatingDivision(this, p);
    }

    public String toString() {
        return "(" + this.getLeftOperand() + " / " + this.getRightOperand() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FloatingDivisionNode)) {
            return false;
        }
        FloatingDivisionNode other = (FloatingDivisionNode)obj;
        return this.getLeftOperand().equals(other.getLeftOperand()) && this.getRightOperand().equals(other.getRightOperand());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getLeftOperand(), this.getRightOperand());
    }
}

