/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.LongBuffer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.LongArrayIndexer;
import org.bytedeco.javacpp.indexer.LongBufferIndexer;

public abstract class LongIndexer
extends Indexer {
    protected LongIndexer(int[] sizes, int[] strides) {
        super(sizes, strides);
    }

    public static LongIndexer create(long[] array, int[] sizes, int[] strides) {
        return new LongArrayIndexer(array, sizes, strides);
    }

    public static LongIndexer create(LongBuffer buffer, int[] sizes, int[] strides) {
        return new LongBufferIndexer(buffer, sizes, strides);
    }

    public static LongIndexer create(LongPointer pointer, int[] sizes, int[] strides) {
        return LongIndexer.create(pointer, sizes, strides, true);
    }

    public static LongIndexer create(final LongPointer pointer, int[] sizes, int[] strides, boolean direct) {
        if (direct) {
            return new LongBufferIndexer(pointer.asBuffer(), sizes, strides);
        }
        final int position = pointer.position();
        long[] array = new long[pointer.limit() - position];
        pointer.get(array);
        return new LongArrayIndexer(array, sizes, strides){

            @Override
            public void release() {
                pointer.position(position).put(this.array);
                super.release();
            }
        };
    }

    public abstract long get(int var1);

    public LongIndexer get(int i, long[] l) {
        return this.get(i, l, 0, l.length);
    }

    public abstract LongIndexer get(int var1, long[] var2, int var3, int var4);

    public abstract long get(int var1, int var2);

    public LongIndexer get(int i, int j, long[] l) {
        return this.get(i, j, l, 0, l.length);
    }

    public abstract LongIndexer get(int var1, int var2, long[] var3, int var4, int var5);

    public abstract long get(int var1, int var2, int var3);

    public abstract long get(int ... var1);

    public LongIndexer get(int[] indices, long[] l) {
        return this.get(indices, l, 0, l.length);
    }

    public abstract LongIndexer get(int[] var1, long[] var2, int var3, int var4);

    public abstract LongIndexer put(int var1, long var2);

    public LongIndexer put(int i, long ... l) {
        return this.put(i, l, 0, l.length);
    }

    public abstract LongIndexer put(int var1, long[] var2, int var3, int var4);

    public abstract LongIndexer put(int var1, int var2, long var3);

    public LongIndexer put(int i, int j, long ... l) {
        return this.put(i, j, l, 0, l.length);
    }

    public abstract LongIndexer put(int var1, int var2, long[] var3, int var4, int var5);

    public abstract LongIndexer put(int var1, int var2, int var3, long var4);

    public abstract LongIndexer put(int[] var1, long var2);

    public LongIndexer put(int[] indices, long ... l) {
        return this.put(indices, l, 0, l.length);
    }

    public abstract LongIndexer put(int[] var1, long[] var2, int var3, int var4);

    @Override
    public double getDouble(int ... indices) {
        return this.get(indices);
    }

    @Override
    public LongIndexer putDouble(int[] indices, double l) {
        return this.put(indices, (long)l);
    }
}

