/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.LongIndexer;

public class LongArrayIndexer
extends LongIndexer {
    protected long[] array;

    public LongArrayIndexer(long[] array, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public long[] array() {
        return this.array;
    }

    @Override
    public long get(int i) {
        return this.array[i];
    }

    @Override
    public LongIndexer get(int i, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            l[offset + n] = this.array[i * this.strides[0] + n];
        }
        return this;
    }

    @Override
    public long get(int i, int j) {
        return this.array[i * this.strides[0] + j];
    }

    @Override
    public LongIndexer get(int i, int j, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            l[offset + n] = this.array[i * this.strides[0] + j * this.strides[1] + n];
        }
        return this;
    }

    @Override
    public long get(int i, int j, int k) {
        return this.array[i * this.strides[0] + j * this.strides[1] + k];
    }

    @Override
    public long get(int ... indices) {
        return this.array[this.index(indices)];
    }

    @Override
    public LongIndexer get(int[] indices, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            l[offset + n] = this.array[this.index(indices) + n];
        }
        return this;
    }

    @Override
    public LongIndexer put(int i, long l) {
        this.array[i] = l;
        return this;
    }

    @Override
    public LongIndexer put(int i, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + n] = l[offset + n];
        }
        return this;
    }

    @Override
    public LongIndexer put(int i, int j, long l) {
        this.array[i * this.strides[0] + j] = l;
        return this;
    }

    @Override
    public LongIndexer put(int i, int j, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + j * this.strides[1] + n] = l[offset + n];
        }
        return this;
    }

    @Override
    public LongIndexer put(int i, int j, int k, long l) {
        this.array[i * this.strides[0] + j * this.strides[1] + k] = l;
        return this;
    }

    @Override
    public LongIndexer put(int[] indices, long l) {
        this.array[this.index((int[])indices)] = l;
        return this;
    }

    @Override
    public LongIndexer put(int[] indices, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[this.index((int[])indices) + n] = l[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

