/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.IntBuffer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntArrayIndexer;
import org.bytedeco.javacpp.indexer.IntBufferIndexer;

public abstract class IntIndexer
extends Indexer {
    protected IntIndexer(int[] sizes, int[] strides) {
        super(sizes, strides);
    }

    public static IntIndexer create(int[] array, int[] sizes, int[] strides) {
        return new IntArrayIndexer(array, sizes, strides);
    }

    public static IntIndexer create(IntBuffer buffer, int[] sizes, int[] strides) {
        return new IntBufferIndexer(buffer, sizes, strides);
    }

    public static IntIndexer create(IntPointer pointer, int[] sizes, int[] strides) {
        return IntIndexer.create(pointer, sizes, strides, true);
    }

    public static IntIndexer create(final IntPointer pointer, int[] sizes, int[] strides, boolean direct) {
        if (direct) {
            return new IntBufferIndexer(pointer.asBuffer(), sizes, strides);
        }
        final int position = pointer.position();
        int[] array = new int[pointer.limit() - position];
        pointer.get(array);
        return new IntArrayIndexer(array, sizes, strides){

            @Override
            public void release() {
                pointer.position(position).put(this.array);
                super.release();
            }
        };
    }

    public abstract int get(int var1);

    public IntIndexer get(int i, int[] n) {
        return this.get(i, n, 0, n.length);
    }

    public abstract IntIndexer get(int var1, int[] var2, int var3, int var4);

    public abstract int get(int var1, int var2);

    public IntIndexer get(int i, int j, int[] n) {
        return this.get(i, j, n, 0, n.length);
    }

    public abstract IntIndexer get(int var1, int var2, int[] var3, int var4, int var5);

    public abstract int get(int var1, int var2, int var3);

    public abstract int get(int ... var1);

    public IntIndexer get(int[] indices, int[] n) {
        return this.get(indices, n, 0, n.length);
    }

    public abstract IntIndexer get(int[] var1, int[] var2, int var3, int var4);

    public abstract IntIndexer put(int var1, int var2);

    public IntIndexer put(int i, int ... n) {
        return this.put(i, n, 0, n.length);
    }

    public abstract IntIndexer put(int var1, int[] var2, int var3, int var4);

    public abstract IntIndexer put(int var1, int var2, int var3);

    public IntIndexer put(int i, int j, int ... n) {
        return this.put(i, j, n, 0, n.length);
    }

    public abstract IntIndexer put(int var1, int var2, int[] var3, int var4, int var5);

    public abstract IntIndexer put(int var1, int var2, int var3, int var4);

    public abstract IntIndexer put(int[] var1, int var2);

    public IntIndexer put(int[] indices, int ... n) {
        return this.put(indices, n, 0, n.length);
    }

    public abstract IntIndexer put(int[] var1, int[] var2, int var3, int var4);

    @Override
    public double getDouble(int ... indices) {
        return this.get(indices);
    }

    @Override
    public IntIndexer putDouble(int[] indices, double n) {
        return this.put(indices, (int)n);
    }
}

