/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.tools.Logger;

public class Loader {
    private static final Logger logger = Logger.create(Loader.class);
    private static final String platform;
    private static java.util.Properties platformProperties;
    static final String cacheDirName;
    static File cacheDir;
    static File tempDir;
    static boolean loadLibraries;
    static Map<String, String> loadedLibraries;
    static WeakHashMap<Class<? extends Pointer>, HashMap<String, Integer>> memberOffsets;

    public static String getPlatform() {
        return System.getProperty("org.bytedeco.javacpp.platform", platform);
    }

    public static java.util.Properties loadProperties() {
        String name = Loader.getPlatform();
        if (platformProperties != null && name.equals(platformProperties.getProperty("platform"))) {
            return platformProperties;
        }
        platformProperties = Loader.loadProperties(name);
        return platformProperties;
    }

    public static java.util.Properties loadProperties(String name) {
        java.util.Properties p = new java.util.Properties();
        p.put("platform", name);
        p.put("platform.path.separator", File.pathSeparator);
        String s = System.mapLibraryName("/");
        int i = s.indexOf(47);
        p.put("platform.library.prefix", s.substring(0, i));
        p.put("platform.library.suffix", s.substring(i + 1));
        name = "properties/" + name + ".properties";
        InputStream is = Loader.class.getResourceAsStream(name);
        try {
            try {
                p.load(new InputStreamReader(is));
            }
            catch (NoSuchMethodError e) {
                p.load(is);
            }
        }
        catch (Exception e) {
            name = "properties/generic.properties";
            is = Loader.class.getResourceAsStream(name);
            try {
                try {
                    p.load(new InputStreamReader(is));
                }
                catch (NoSuchMethodError e2) {
                    p.load(is);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return p;
    }

    public static Class getEnclosingClass(Class cls) {
        Platform p;
        Class<?> c = cls;
        while (c.getDeclaringClass() != null && !c.isAnnotationPresent(Properties.class) && (!c.isAnnotationPresent(Platform.class) || (p = c.getAnnotation(Platform.class)).pragma().length <= 0 && p.define().length <= 0 && p.include().length <= 0 && p.cinclude().length <= 0 && p.includepath().length <= 0 && p.compiler().length <= 0 && p.linkpath().length <= 0 && p.link().length <= 0 && p.frameworkpath().length <= 0 && p.framework().length <= 0 && p.preloadpath().length <= 0 && p.preload().length <= 0 && p.library().length() <= 0)) {
            c = c.getDeclaringClass();
        }
        return c;
    }

    public static ClassProperties loadProperties(Class[] cls, java.util.Properties properties, boolean inherit) {
        ClassProperties cp = new ClassProperties(properties);
        for (Class c : cls) {
            cp.load(c, inherit);
        }
        return cp;
    }

    public static ClassProperties loadProperties(Class cls, java.util.Properties properties, boolean inherit) {
        ClassProperties cp = new ClassProperties(properties);
        cp.load(cls, inherit);
        return cp;
    }

    public static Class getCallerClass(int i) {
        Object classContext = null;
        try {
            new SecurityManager(){

                public Class[] getClassContext() {
                    return super.getClassContext();
                }
            }.getClassContext();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (classContext != null) {
            for (int j = 0; j < (classContext).length; ++j) {
                if (classContext[j] != Loader.class) continue;
                return classContext[i + j];
            }
        } else {
            try {
                StackTraceElement[] classNames = Thread.currentThread().getStackTrace();
                for (int j = 0; j < classNames.length; ++j) {
                    if (Class.forName(classNames[j].getClassName()) != Loader.class) continue;
                    return Class.forName(classNames[i + j].getClassName());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static File extractResource(String name, File directory, String prefix, String suffix) throws IOException {
        Class cls = Loader.getCallerClass(2);
        return Loader.extractResource(cls, name, directory, prefix, suffix);
    }

    public static File extractResource(Class cls, String name, File directory, String prefix, String suffix) throws IOException {
        return Loader.extractResource(cls.getResource(name), directory, prefix, suffix);
    }

    public static File extractResource(URL resourceURL, File directory, String prefix, String suffix) throws IOException {
        InputStream is;
        InputStream inputStream = is = resourceURL != null ? resourceURL.openStream() : null;
        if (is == null) {
            return null;
        }
        File file = null;
        boolean fileExisted = false;
        try {
            int length;
            if (prefix == null && suffix == null) {
                if (directory == null) {
                    directory = new File(System.getProperty("java.io.tmpdir"));
                }
                file = new File(directory, new File(resourceURL.getPath()).getName());
                fileExisted = file.exists();
            } else {
                file = File.createTempFile(prefix, suffix, directory);
            }
            FileOutputStream os = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            if (file != null && !fileExisted) {
                file.delete();
            }
            throw e;
        }
        return file;
    }

    public static File getCacheDir() {
        File f;
        if (cacheDir == null && cacheDirName != null && ((f = new File(cacheDirName)).exists() || f.mkdirs())) {
            cacheDir = f;
        }
        return cacheDir;
    }

    public static File getTempDir() {
        if (tempDir == null) {
            File tmpdir = new File(System.getProperty("java.io.tmpdir"));
            File f = null;
            for (int i = 0; i < 1000; ++i) {
                f = new File(tmpdir, "javacpp" + System.nanoTime());
                if (!f.mkdir()) continue;
                tempDir = f;
                tempDir.deleteOnExit();
                break;
            }
        }
        return tempDir;
    }

    public static boolean isLoadLibraries() {
        return loadLibraries;
    }

    public static String load() {
        Class cls = Loader.getCallerClass(2);
        return Loader.load(cls);
    }

    public static String load(Class cls) {
        if (!loadLibraries || cls == null) {
            return null;
        }
        ClassProperties p = Loader.loadProperties(cls = Loader.getEnclosingClass(cls), Loader.loadProperties(), true);
        List<String> targets = p.get("target");
        if (targets.isEmpty()) {
            if (p.getInheritedClasses() != null) {
                for (Class c : p.getInheritedClasses()) {
                    targets.add(c.getName());
                }
            }
            targets.add(cls.getName());
        }
        for (String s : targets) {
            try {
                Class.forName(s, true, cls.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                NoClassDefFoundError e = new NoClassDefFoundError(ex.toString());
                e.initCause(ex);
                throw e;
            }
        }
        ArrayList<String> preloads = new ArrayList<String>();
        preloads.addAll(p.get("platform.preload"));
        preloads.addAll(p.get("platform.link"));
        UnsatisfiedLinkError preloadError = null;
        for (String preload : preloads) {
            try {
                URL[] urls = Loader.findLibrary(cls, p, preload);
                Loader.loadLibrary(urls, preload);
            }
            catch (UnsatisfiedLinkError e) {
                preloadError = e;
            }
        }
        try {
            String library = p.getProperty("platform.library");
            URL[] urls = Loader.findLibrary(cls, p, library);
            return Loader.loadLibrary(urls, library);
        }
        catch (UnsatisfiedLinkError e) {
            if (preloadError != null && e.getCause() == null) {
                e.initCause(preloadError);
            }
            throw e;
        }
    }

    public static URL[] findLibrary(Class cls, ClassProperties properties, String libnameversion) {
        int i;
        String[] s = libnameversion.split("@");
        String libname = s[0];
        String version = s.length > 1 ? s[s.length - 1] : "";
        String filename = loadedLibraries.get(libnameversion);
        if (filename != null) {
            try {
                return new URL[]{new File(filename).toURI().toURL()};
            }
            catch (IOException ex) {
                return new URL[0];
            }
        }
        String subdir = properties.getProperty("platform") + '/';
        String prefix = properties.getProperty("platform.library.prefix", "") + libname;
        String suffix = properties.getProperty("platform.library.suffix", "");
        String[] styles = new String[]{prefix + suffix + version, prefix + version + suffix, prefix + suffix};
        String[] suffixes = properties.get("platform.library.suffix").toArray(new String[0]);
        if (suffixes.length > 1) {
            styles = new String[3 * suffixes.length];
            for (int i2 = 0; i2 < suffixes.length; ++i2) {
                styles[3 * i2] = prefix + suffixes[i2] + version;
                styles[3 * i2 + 1] = prefix + version + suffixes[i2];
                styles[3 * i2 + 2] = prefix + suffixes[i2];
            }
        }
        int k = 0;
        ArrayList<String> paths = new ArrayList<String>();
        paths.addAll(properties.get("platform.preloadpath"));
        paths.addAll(properties.get("platform.linkpath"));
        URL[] urls = new URL[styles.length * (1 + paths.size())];
        for (i = 0; cls != null && i < styles.length; ++i) {
            URL u = cls.getResource(subdir + styles[i]);
            if (u == null) continue;
            urls[k++] = u;
        }
        for (i = 0; paths.size() > 0 && i < styles.length; ++i) {
            for (String path : paths) {
                File file = new File(path, styles[i]);
                if (!file.exists()) continue;
                try {
                    urls[k++] = file.toURI().toURL();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        URL[] newurls = new URL[k];
        System.arraycopy(urls, 0, newurls, 0, k);
        return newurls;
    }

    public static String loadLibrary(URL[] urls, String libnameversion) {
        String libname;
        if (!loadLibraries) {
            return null;
        }
        String filename = loadedLibraries.get(libnameversion);
        if (filename != null) {
            return filename;
        }
        File tempFile = null;
        UnsatisfiedLinkError loadError = null;
        try {
            for (URL url : urls) {
                File file;
                try {
                    file = new File(url.toURI());
                }
                catch (Exception e) {
                    if (Loader.getCacheDir() == null || !(file = new File(Loader.getCacheDir(), new File(url.getPath()).getName())).exists()) {
                        if (tempFile != null && tempFile.exists()) {
                            tempFile.deleteOnExit();
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Extracting " + url);
                        }
                        file = Loader.getCacheDir() != null ? Loader.extractResource(url, Loader.getCacheDir(), null, null) : (tempFile = Loader.extractResource(url, Loader.getTempDir(), null, null));
                    }
                    while (System.currentTimeMillis() - file.lastModified() < 1000L) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (file == null || !file.exists()) continue;
                filename = file.getAbsolutePath();
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Loading " + filename);
                    }
                    loadedLibraries.put(libnameversion, filename);
                    System.load(filename);
                    String e = filename;
                    return e;
                }
                catch (UnsatisfiedLinkError e) {
                    loadError = e;
                    loadedLibraries.remove(libnameversion);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Failed to load " + filename + ": " + e);
                }
            }
            libname = libnameversion.split("@")[0];
            if (logger.isDebugEnabled()) {
                logger.debug("Loading library " + libname);
            }
            loadedLibraries.put(libnameversion, libname);
        }
        catch (UnsatisfiedLinkError e) {
            loadedLibraries.remove(libnameversion);
            if (loadError != null && e.getCause() == null) {
                e.initCause(loadError);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to load for " + libnameversion + ": " + e);
            }
            throw e;
        }
        catch (IOException ex) {
            loadedLibraries.remove(libnameversion);
            if (loadError != null && ex.getCause() == null) {
                ex.initCause(loadError);
            }
            UnsatisfiedLinkError e = new UnsatisfiedLinkError(ex.toString());
            e.initCause(ex);
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to extract for " + libnameversion + ": " + e);
            }
            throw e;
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.deleteOnExit();
            }
        }
        System.loadLibrary(libname);
        String string = libname;
        return string;
    }

    public static void main(String[] args) {
        File tempDir;
        File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        if (!tmpdir.equals((tempDir = new File(args[0])).getParentFile()) || !tempDir.getName().startsWith("javacpp")) {
            return;
        }
        for (File file : tempDir.listFiles()) {
            while (file.exists() && !file.delete()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        tempDir.delete();
    }

    static void putMemberOffset(String typeName, String member, int offset) throws ClassNotFoundException {
        Class<?> c = Class.forName(typeName.replace('/', '.'), false, Loader.class.getClassLoader());
        Loader.putMemberOffset(c.asSubclass(Pointer.class), member, offset);
    }

    static synchronized void putMemberOffset(Class<? extends Pointer> type, String member, int offset) {
        HashMap<String, Integer> offsets = memberOffsets.get(type);
        if (offsets == null) {
            offsets = new HashMap();
            memberOffsets.put(type, offsets);
        }
        offsets.put(member, offset);
    }

    public static int offsetof(Class<? extends Pointer> type, String member) {
        return memberOffsets.get(type).get(member);
    }

    public static int sizeof(Class<? extends Pointer> type) {
        return memberOffsets.get(type).get("sizeof");
    }

    static {
        platformProperties = null;
        String jvmName = System.getProperty("java.vm.name", "").toLowerCase();
        String osName = System.getProperty("os.name", "").toLowerCase();
        String osArch = System.getProperty("os.arch", "").toLowerCase();
        if (jvmName.startsWith("dalvik") && osName.startsWith("linux")) {
            osName = "android";
        } else if (jvmName.startsWith("robovm") && osName.startsWith("darwin")) {
            osName = "ios";
            osArch = "arm";
        } else if (osName.startsWith("mac os x")) {
            osName = "macosx";
        } else {
            int spaceIndex = osName.indexOf(32);
            if (spaceIndex > 0) {
                osName = osName.substring(0, spaceIndex);
            }
        }
        if (osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686")) {
            osArch = "x86";
        } else if (osArch.equals("amd64") || osArch.equals("x86-64") || osArch.equals("x64")) {
            osArch = "x86_64";
        } else if (osArch.startsWith("aarch64") || osArch.startsWith("armv8") || osArch.startsWith("arm64")) {
            osArch = "arm64";
        } else if (osArch.startsWith("arm")) {
            osArch = "arm";
        }
        platform = osName + "-" + osArch;
        cacheDirName = System.getProperty("org.bytedeco.javacpp.cachedir", null);
        cacheDir = null;
        tempDir = null;
        loadLibraries = System.getProperty("org.bytedeco.javacpp.loadlibraries", "true").equals("true");
        loadedLibraries = Collections.synchronizedMap(new HashMap());
        if (Loader.getPlatform().startsWith("windows")) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (tempDir == null) {
                        return;
                    }
                    try {
                        ArrayList<String> command = new ArrayList<String>();
                        command.add(System.getProperty("java.home") + "/bin/java");
                        command.add("-classpath");
                        command.add(new File(Loader.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toString());
                        command.add(Loader.class.getName());
                        command.add(tempDir.getAbsolutePath());
                        new ProcessBuilder(command).start();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        memberOffsets = new WeakHashMap();
    }
}

