/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.nio.CharBuffer;
import org.bytedeco.javacpp.Pointer;

public class CharPointer
extends Pointer {
    public CharPointer(String s) {
        this(s.toCharArray().length + 1);
        this.putString(s);
    }

    public CharPointer(char ... array) {
        this(array.length);
        this.put(array);
    }

    public CharPointer(CharBuffer buffer) {
        super(buffer);
        if (buffer != null && buffer.hasArray()) {
            char[] array = buffer.array();
            this.allocateArray(array.length - buffer.arrayOffset());
            this.put(array, buffer.arrayOffset(), array.length - buffer.arrayOffset());
            this.position(buffer.position());
            this.limit(buffer.limit());
        }
    }

    public CharPointer(int size) {
        try {
            this.allocateArray(size);
        }
        catch (UnsatisfiedLinkError e) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", e);
        }
    }

    public CharPointer() {
    }

    public CharPointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(int var1);

    public CharPointer position(int position) {
        return (CharPointer)super.position(position);
    }

    public CharPointer limit(int limit) {
        return (CharPointer)super.limit(limit);
    }

    public CharPointer capacity(int capacity) {
        return (CharPointer)super.capacity(capacity);
    }

    public char[] getStringChars() {
        char[] newbuffer;
        if (this.limit > this.position) {
            char[] array = new char[this.limit - this.position];
            this.get(array);
            return array;
        }
        char[] buffer = new char[16];
        int i = 0;
        int j = this.position();
        while ((buffer[i] = this.position(j).get()) != '\u0000') {
            ++j;
            if (++i < buffer.length) continue;
            newbuffer = new char[2 * buffer.length];
            System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
            buffer = newbuffer;
        }
        newbuffer = new char[i];
        System.arraycopy(buffer, 0, newbuffer, 0, i);
        return newbuffer;
    }

    public String getString() {
        return new String(this.getStringChars());
    }

    public CharPointer putString(String s) {
        char[] chars = s.toCharArray();
        return this.put(chars).put(chars.length, '\u0000').limit(chars.length);
    }

    public char get() {
        return this.get(0);
    }

    public native char get(int var1);

    public CharPointer put(char c) {
        return this.put(0, c);
    }

    public native CharPointer put(int var1, char var2);

    public CharPointer get(char[] array) {
        return this.get(array, 0, array.length);
    }

    public CharPointer put(char ... array) {
        return this.put(array, 0, array.length);
    }

    public native CharPointer get(char[] var1, int var2, int var3);

    public native CharPointer put(char[] var1, int var2, int var3);

    @Override
    public final CharBuffer asBuffer() {
        return this.asByteBuffer().asCharBuffer();
    }
}

