/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import com.strobel.annotations.NotNull;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.ReadOnlyList;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.Flags;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.ParameterInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.SignatureType;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.Types;
import com.strobel.reflection.emit.AnnotationBuilder;
import com.strobel.reflection.emit.CodeGenerator;
import com.strobel.reflection.emit.Error;
import com.strobel.reflection.emit.GenericParameterBuilder;
import com.strobel.reflection.emit.ParameterBuilder;
import com.strobel.reflection.emit.TypeBuilder;
import com.strobel.reflection.emit.__ExceptionInfo;
import com.strobel.reflection.emit.__ExceptionInstance;
import com.strobel.util.EmptyArrayCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Modifier;

public final class MethodBuilder
extends MethodInfo {
    private final String _name;
    private final TypeBuilder<?> _declaringType;
    private final int _modifiers;
    private SignatureType _signatureType;
    private TypeList _thrownTypes;
    private boolean _isFinished;
    private ReadOnlyList<AnnotationBuilder<? extends Annotation>> _annotations;
    private byte[] _body;
    private int _numberOfExceptions;
    private __ExceptionInstance[] _exceptions;
    private Object _defaultValue;
    GenericParameterBuilder<?>[] genericParameterBuilders;
    ParameterBuilder[] parameterBuilders;
    CodeGenerator generator;
    MethodInfo generatedMethod;

    MethodBuilder(String name, int modifiers, Type<?> returnType, TypeList parameterTypes, TypeList thrownTypes, TypeBuilder<?> declaringType) {
        this._name = VerifyArgument.notNullOrWhitespace((String)name, (String)"name");
        this._modifiers = modifiers;
        this._signatureType = new SignatureType(returnType != null ? returnType : PrimitiveTypes.Void, parameterTypes != null ? parameterTypes : TypeList.empty());
        this._thrownTypes = thrownTypes != null ? thrownTypes : TypeList.empty();
        this._declaringType = (TypeBuilder)VerifyArgument.notNull(declaringType, (String)"declaringType");
        this._annotations = ReadOnlyList.emptyList();
        this.setSignature(returnType, parameterTypes);
    }

    final void verifyNotGeneric() {
        if (this.isGenericMethod() && !this.isGenericMethodDefinition()) {
            throw Error.methodIsGeneric();
        }
    }

    final void verifyNotAbstract() {
        if (this.isAbstract()) {
            throw Error.abstractMethodCannotHaveBody();
        }
    }

    public CodeGenerator getCodeGenerator() {
        this.verifyNotGeneric();
        this.verifyNotAbstract();
        if (this.generator == null) {
            this.generator = new CodeGenerator(this);
        }
        return this.generator;
    }

    public CodeGenerator getCodeGenerator(int initialSize) {
        this.verifyNotGeneric();
        this.verifyNotAbstract();
        if (this.generator == null) {
            this.generator = new CodeGenerator(this, initialSize);
        }
        return this.generator;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Type<?> getReturnType() {
        return this._signatureType.getReturnType();
    }

    @Override
    public SignatureType getSignatureType() {
        return this._signatureType;
    }

    @Override
    public Method getRawMethod() {
        this._declaringType.verifyCreated();
        return this.generatedMethod.getRawMethod();
    }

    @Override
    public Object getDefaultValue() {
        return this._defaultValue;
    }

    public void setDefaultValue(Object value) {
        if (!this._declaringType.isInterface() || !Types.Annotation.isAssignableFrom(this._declaringType)) {
            throw Error.onlyAnnotationMethodsCanHaveDefaultValues();
        }
        this._defaultValue = value;
    }

    @Override
    public TypeBuilder<?> getDeclaringType() {
        return this._declaringType;
    }

    @Override
    public int getModifiers() {
        return this._modifiers;
    }

    @Override
    public ParameterList getParameters() {
        return this._declaringType.isCreated() ? this.generatedMethod.getParameters() : this.createParameters();
    }

    final ParameterList createParameters() {
        List<ParameterBuilder> pb = this.getDefinedParameters();
        ParameterInfo[] p = new ParameterInfo[pb.size()];
        for (int i = 0; i < p.length; ++i) {
            ParameterBuilder b = pb.get(i);
            p[i] = new ParameterInfo(b.getName(), b.getPosition(), b.getParameterType());
        }
        return new ParameterList(p);
    }

    @Override
    public TypeList getThrownTypes() {
        return this._thrownTypes;
    }

    public TypeList getParameterTypes() {
        return this._signatureType.getParameterTypes();
    }

    public List<ParameterBuilder> getDefinedParameters() {
        return ArrayUtilities.asUnmodifiableList((Object[])this.parameterBuilders);
    }

    public boolean isTypeCreated() {
        return this._declaringType.isCreated();
    }

    public boolean isFinished() {
        return this._isFinished;
    }

    public void setReturnType(Type<?> type) {
        this.verifyCodeGeneratorNotCreated();
        this.setSignature(type, null);
    }

    final void verifyCodeGeneratorNotCreated() {
        if (this.generator != null) {
            throw Error.cannotModifyMethodAfterCallingGetGenerator();
        }
    }

    public void setSignature(Type<?> returnType, TypeList parameterTypes) {
        this.verifyNotGeneric();
        Type<?> newReturnType = this._signatureType.getReturnType();
        TypeList newParameterTypes = this._signatureType.getParameterTypes();
        if (returnType != null) {
            newReturnType = returnType;
        }
        if (parameterTypes != null) {
            newParameterTypes = parameterTypes;
            this.parameterBuilders = new ParameterBuilder[parameterTypes.size()];
            int n = parameterTypes.size();
            for (int i = 0; i < n; ++i) {
                this.parameterBuilders[i] = new ParameterBuilder(this, i, null, (Type)parameterTypes.get(i));
            }
        }
        if (!newReturnType.isEquivalentTo(this._signatureType.getReturnType()) || !newParameterTypes.isEquivalentTo(this._signatureType.getParameterTypes())) {
            this._signatureType = new SignatureType(newReturnType, newParameterTypes);
        }
        this.invalidateCaches();
    }

    public void setParameters(TypeList types) {
        this.verifyCodeGeneratorNotCreated();
        this.setSignature(null, types);
    }

    public void setThrownTypes(TypeList types) {
        this.verifyCodeGeneratorNotCreated();
        this._thrownTypes = types != null ? types : TypeList.empty();
        this.invalidateCaches();
    }

    @Override
    public Type getReflectedType() {
        return this._declaringType;
    }

    public void addCustomAnnotation(AnnotationBuilder annotation) {
        VerifyArgument.notNull((Object)annotation, (String)"annotation");
        Object[] newAnnotations = new AnnotationBuilder[this._annotations.size() + 1];
        this._annotations.toArray(newAnnotations);
        newAnnotations[this._annotations.size()] = annotation;
        this._annotations = new ReadOnlyList(newAnnotations);
    }

    public ReadOnlyList<AnnotationBuilder<? extends Annotation>> getCustomAnnotations() {
        return this._annotations;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        this._declaringType.verifyCreated();
        return this.generatedMethod.getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        this._declaringType.verifyCreated();
        return this.generatedMethod.getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        this._declaringType.verifyCreated();
        return this.generatedMethod.getDeclaredAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        this._declaringType.verifyCreated();
        return this.generatedMethod.isAnnotationPresent(annotationClass);
    }

    @Override
    public boolean isGenericMethod() {
        return !ArrayUtilities.isNullOrEmpty((Object[])this.genericParameterBuilders);
    }

    @Override
    public boolean isGenericMethodDefinition() {
        return this.isGenericMethod();
    }

    @Override
    public TypeList getGenericMethodParameters() {
        if (ArrayUtilities.isNullOrEmpty((Object[])this.genericParameterBuilders)) {
            return TypeList.empty();
        }
        return Type.list(this.genericParameterBuilders);
    }

    @Override
    public MethodInfo getErasedMethodDefinition() {
        if (this._declaringType.isCreated()) {
            return this.generatedMethod.getErasedMethodDefinition();
        }
        return super.getErasedMethodDefinition();
    }

    @Override
    public StringBuilder appendDescription(StringBuilder sb) {
        StringBuilder s = new StringBuilder();
        for (Modifier modifier : Flags.asModifierSet(this.getModifiers())) {
            s.append(modifier.toString());
            s.append(' ');
        }
        if (this.isGenericMethodDefinition()) {
            GenericParameterBuilder<?>[] genericParameters = this.genericParameterBuilders;
            s.append('<');
            int n = genericParameters.length;
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    s.append(", ");
                }
                s = genericParameters[i].appendSimpleDescription(s);
            }
            s.append('>');
            s.append(' ');
        }
        Type<?> returnType = this.getReturnType();
        while (returnType.isWildcardType()) {
            returnType = returnType.getExtendsBound();
        }
        if (returnType.isGenericParameter()) {
            s.append(returnType.getName());
        } else {
            s = returnType.appendSimpleDescription(s);
        }
        s.append(' ');
        s.append(this.getName());
        s.append('(');
        ParameterList parameters = this.getParameters();
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterInfo p = (ParameterInfo)parameters.get(i);
            if (i != 0) {
                s.append(", ");
            }
            Type<?> parameterType = p.getParameterType();
            while (parameterType.isWildcardType()) {
                parameterType = parameterType.getExtendsBound();
            }
            if (parameterType.isGenericParameter()) {
                s.append(parameterType.getName());
                continue;
            }
            s = parameterType.appendSimpleDescription(s);
        }
        s.append(')');
        TypeList thrownTypes = this.getThrownTypes();
        if (!thrownTypes.isEmpty()) {
            s.append(" throws ");
            int n2 = thrownTypes.size();
            for (int i = 0; i < n2; ++i) {
                Type t = (Type)thrownTypes.get(i);
                if (i != 0) {
                    s.append(", ");
                }
                s = t.appendBriefDescription(s);
            }
        }
        return s;
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        int n;
        StringBuilder s = new StringBuilder();
        for (Modifier modifier : Flags.asModifierSet(this.getModifiers())) {
            s.append(modifier.toString());
            s.append(' ');
        }
        if (this.isGenericMethodDefinition()) {
            GenericParameterBuilder<?>[] genericParameters = this.genericParameterBuilders;
            s.append('<');
            n = genericParameters.length;
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    s.append(", ");
                }
                s = genericParameters[i].appendSimpleDescription(s);
            }
            s.append('>');
            s.append(' ');
        }
        s = this.getReturnType().appendSimpleDescription(s);
        s.append(' ');
        s.append(this.getName());
        s.append('(');
        ParameterBuilder[] parameters = this.parameterBuilders;
        n = parameters.length;
        for (int i = 0; i < n; ++i) {
            ParameterBuilder p = parameters[i];
            if (i != 0) {
                s.append(", ");
            }
            s = p.getParameterType().appendSimpleDescription(s);
        }
        s.append(')');
        TypeList thrownTypes = this.getThrownTypes();
        if (!thrownTypes.isEmpty()) {
            s.append(" throws ");
            int n2 = thrownTypes.size();
            for (int i = 0; i < n2; ++i) {
                Type t = (Type)thrownTypes.get(i);
                if (i != 0) {
                    s.append(", ");
                }
                s = t.appendSimpleDescription(s);
            }
        }
        return s;
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        StringBuilder s = sb;
        s.append('(');
        TypeList parameterTypes = this.getParameterTypes();
        int n = parameterTypes.size();
        for (int i = 0; i < n; ++i) {
            s = ((Type)parameterTypes.get(i)).appendErasedSignature(s);
        }
        s.append(')');
        s = this.getReturnType().appendErasedSignature(s);
        return s;
    }

    @Override
    public StringBuilder appendSignature(StringBuilder sb) {
        GenericParameterBuilder<?>[] genericParameters;
        int count;
        StringBuilder s = sb;
        if (this.isGenericMethod() && (count = (genericParameters = this.genericParameterBuilders).length) > 0) {
            s.append('<');
            for (int i = 0; i < count; ++i) {
                GenericParameterBuilder<?> type = genericParameters[i];
                s = ((Type)type).appendGenericSignature(s);
            }
            s.append('>');
        }
        s.append('(');
        TypeList parameterTypes = this.getParameterTypes();
        int n = parameterTypes.size();
        for (int i = 0; i < n; ++i) {
            s = ((Type)parameterTypes.get(i)).appendSignature(s);
        }
        s.append(')');
        s = this.getReturnType().appendSignature(s);
        return s;
    }

    public GenericParameterBuilder<?>[] defineGenericParameters(String ... names) {
        VerifyArgument.notEmpty((Object[])names, (String)"names");
        if (this.genericParameterBuilders != null) {
            throw Error.genericParametersAlreadySet();
        }
        GenericParameterBuilder[] parameters = new GenericParameterBuilder[names.length];
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            String name = names[i];
            if (name == null) {
                throw new IllegalArgumentException("Names array contains one or more null elements.");
            }
            parameters[i] = new GenericParameterBuilder(new TypeBuilder(name, i, this));
        }
        this.genericParameterBuilders = parameters;
        return this.genericParameterBuilders;
    }

    public ParameterBuilder defineParameter(int position, String name) {
        this.verifyCodeGeneratorNotCreated();
        VerifyArgument.isNonNegative((int)position, (String)"position");
        this.verifyNotGeneric();
        this._declaringType.verifyNotCreated();
        TypeList parameterTypes = this._signatureType.getParameterTypes();
        if (parameterTypes == null || position >= parameterTypes.size()) {
            throw new IllegalArgumentException("Position is out of range.");
        }
        ParameterBuilder parameterBuilder = this.parameterBuilders[position];
        parameterBuilder.setName(name);
        return parameterBuilder;
    }

    public void createMethodBody(byte[] bytecode, int size) {
        this.verifyNotGeneric();
        if (this.isFinished()) {
            throw Error.methodIsFinished();
        }
        this._declaringType.verifyNotCreated();
        if (bytecode != null) {
            VerifyArgument.inRange((int)0, (int)bytecode.length, (int)size, (String)"size");
        }
        if (bytecode == null) {
            this._body = null;
            return;
        }
        this._body = Arrays.copyOf(bytecode, size);
        this._isFinished = true;
    }

    final byte[] getBody() {
        return this._body;
    }

    final __ExceptionInstance[] getExceptionInstances() {
        return this._exceptions;
    }

    final int getNumberOfExceptions() {
        return this._numberOfExceptions;
    }

    final void createMethodBodyHelper(CodeGenerator code) {
        VerifyArgument.notNull((Object)code, (String)"code");
        int counter = 0;
        this._declaringType.verifyNotCreated();
        if (this._isFinished) {
            throw Error.methodIsFinished();
        }
        if (code.methodBuilder != this && code.methodBuilder != null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        if (code.scopeTree._openScopeCount != 0) {
            throw Error.methodHasOpenLocalScope();
        }
        this._body = code.bakeByteArray();
        __ExceptionInfo[] exceptions = code.getExceptions();
        this._numberOfExceptions = MethodBuilder.calculateNumberOfExceptions(exceptions);
        if (this._numberOfExceptions > 0) {
            this._exceptions = new __ExceptionInstance[this._numberOfExceptions];
            for (__ExceptionInfo exception : exceptions) {
                int[] filterAddresses = exception.getFilterAddresses();
                int[] catchAddresses = exception.getCatchAddresses();
                int[] catchEndAddresses = exception.getCatchEndAddresses();
                Type[] catchClass = exception.getCatchClass();
                int numberOfCatches = exception.getNumberOfCatches();
                int startAddress = exception.getStartAddress();
                int endAddress = exception.getEndAddress();
                int[] exceptionType = exception.getExceptionTypes();
                block5: for (int j = 0; j < numberOfCatches; ++j) {
                    short tkExceptionClass = 0;
                    if (catchClass[j] != null) {
                        tkExceptionClass = this._declaringType.getTypeToken(catchClass[j]);
                    }
                    switch (exceptionType[j]) {
                        case 0: 
                        case 1: {
                            this._exceptions[counter++] = new __ExceptionInstance(startAddress, endAddress, filterAddresses[j], catchAddresses[j], catchEndAddresses[j], exceptionType[j], tkExceptionClass);
                            continue block5;
                        }
                        case 2: {
                            this._exceptions[counter++] = new __ExceptionInstance(startAddress, exception.getEndAddress(), filterAddresses[j], catchAddresses[j], catchEndAddresses[j], exceptionType[j], tkExceptionClass);
                        }
                    }
                }
            }
        } else {
            this._exceptions = (__ExceptionInstance[])EmptyArrayCache.fromElementType(__ExceptionInstance.class);
        }
        this._isFinished = true;
    }

    private static int calculateNumberOfExceptions(__ExceptionInfo[] exceptions) {
        int numberOfExceptions = 0;
        if (exceptions == null) {
            return 0;
        }
        for (__ExceptionInfo exception : exceptions) {
            numberOfExceptions += exception.getNumberOfCatches();
        }
        return numberOfExceptions;
    }

    final void releaseBakedStructures() {
        this._body = null;
    }
}

