/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.CallingConvention;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.SignatureType;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

final class DelegatingMethodInfo
extends MethodInfo {
    private final Type<?> _reflectedType;
    private final Type<?> _declaringType;
    private final MethodInfo _methodInfo;

    DelegatingMethodInfo(MethodInfo method, Type<?> reflectedType) {
        this._methodInfo = DelegatingMethodInfo.unwrap((MethodInfo)VerifyArgument.notNull((Object)method, (String)"method"));
        this._declaringType = this._methodInfo.getDeclaringType();
        this._reflectedType = (Type)VerifyArgument.notNull(reflectedType, (String)"reflectedType");
    }

    DelegatingMethodInfo(MethodInfo method, Type<?> declaringType, Type<?> reflectedType) {
        this._methodInfo = DelegatingMethodInfo.unwrap((MethodInfo)VerifyArgument.notNull((Object)method, (String)"method"));
        this._declaringType = (Type)VerifyArgument.notNull(declaringType, (String)"declaringType");
        this._reflectedType = (Type)VerifyArgument.notNull(reflectedType, (String)"reflectedType");
    }

    private static MethodInfo unwrap(MethodInfo method) {
        MethodInfo m = method;
        while (m instanceof DelegatingMethodInfo) {
            m = ((DelegatingMethodInfo)m)._methodInfo;
        }
        return m;
    }

    @Override
    public Type<?> getReturnType() {
        return this._methodInfo.getReturnType();
    }

    @Override
    public Method getRawMethod() {
        return this._methodInfo.getRawMethod();
    }

    @Override
    public Object getDefaultValue() {
        return this._methodInfo.getDefaultValue();
    }

    @Override
    public String getName() {
        return this._methodInfo.getName();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this._methodInfo.getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this._methodInfo.getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this._methodInfo.getDeclaredAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._methodInfo.isAnnotationPresent(annotationClass);
    }

    @Override
    public Object invoke(Object instance, Object ... args) {
        return this._methodInfo.invoke(instance, args);
    }

    @Override
    public MethodInfo findOverriddenMethod() {
        return this._methodInfo.findOverriddenMethod();
    }

    @Override
    public MethodInfo findBaseMethod(Type<?> relativeTo) {
        return this._methodInfo.findBaseMethod(relativeTo);
    }

    @Override
    public StringBuilder appendDescription(StringBuilder sb) {
        return this._methodInfo.appendDescription(sb);
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        return this._methodInfo.appendSimpleDescription(sb);
    }

    @Override
    public StringBuilder appendBriefDescription(StringBuilder sb) {
        return this._methodInfo.appendBriefDescription(sb);
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        return this._methodInfo.appendErasedDescription(sb);
    }

    @Override
    public StringBuilder appendSignature(StringBuilder sb) {
        return this._methodInfo.appendSignature(sb);
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        return this._methodInfo.appendErasedSignature(sb);
    }

    @Override
    public boolean isGenericMethod() {
        return this._methodInfo.isGenericMethod();
    }

    @Override
    public boolean isGenericMethodDefinition() {
        return this._methodInfo.isGenericMethodDefinition();
    }

    @Override
    public TypeBindings getTypeBindings() {
        return this._methodInfo.getTypeBindings();
    }

    @Override
    public TypeList getTypeArguments() {
        return this._methodInfo.getTypeArguments();
    }

    @Override
    public TypeList getGenericMethodParameters() {
        return this._methodInfo.getGenericMethodParameters();
    }

    @Override
    public MethodInfo getGenericMethodDefinition() {
        return this._methodInfo.getGenericMethodDefinition();
    }

    @Override
    public MethodInfo getErasedMethodDefinition() {
        return this._methodInfo.getErasedMethodDefinition();
    }

    @Override
    public boolean containsGenericParameters() {
        return this._methodInfo.containsGenericParameters();
    }

    @Override
    public MethodInfo makeGenericMethod(Type<?> ... typeArguments) {
        return this._methodInfo.makeGenericMethod(typeArguments);
    }

    @Override
    public MethodInfo makeGenericMethod(TypeList typeArguments) {
        return this._methodInfo.makeGenericMethod(typeArguments);
    }

    @Override
    public SignatureType getSignatureType() {
        return this._methodInfo.getSignatureType();
    }

    @Override
    public ParameterList getParameters() {
        return this._methodInfo.getParameters();
    }

    @Override
    public TypeList getThrownTypes() {
        return this._methodInfo.getThrownTypes();
    }

    @Override
    public CallingConvention getCallingConvention() {
        return this._methodInfo.getCallingConvention();
    }

    @Override
    public Type getDeclaringType() {
        return this._declaringType;
    }

    @Override
    public Type getReflectedType() {
        return this._reflectedType;
    }

    @Override
    public int getModifiers() {
        return this._methodInfo.getModifiers();
    }

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return this._methodInfo.getDeclaredAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return this._methodInfo.getAnnotationsByType(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this._methodInfo.getDeclaredAnnotationsByType(annotationClass);
    }

    @Override
    public boolean isEquivalentTo(MemberInfo m) {
        return this._methodInfo.isEquivalentTo(m);
    }

    @Override
    public String getSignature() {
        return this._methodInfo.getSignature();
    }

    @Override
    public String getErasedSignature() {
        return this._methodInfo.getErasedSignature();
    }

    @Override
    public String getBriefDescription() {
        return this._methodInfo.getBriefDescription();
    }

    @Override
    public String getDescription() {
        return this._methodInfo.getDescription();
    }

    @Override
    public String getErasedDescription() {
        return this._methodInfo.getErasedDescription();
    }

    @Override
    public String getSimpleDescription() {
        return this._methodInfo.getSimpleDescription();
    }

    @Override
    public String toString() {
        return this._methodInfo.toString();
    }
}

