/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBindingVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class NullAnnotationMatching {
    public static final NullAnnotationMatching NULL_ANNOTATIONS_OK = new NullAnnotationMatching(0, null);
    public static final NullAnnotationMatching NULL_ANNOTATIONS_UNCHECKED = new NullAnnotationMatching(1, null);
    public static final NullAnnotationMatching NULL_ANNOTATIONS_MISMATCH = new NullAnnotationMatching(2, null);
    public final int severity;
    public final TypeBinding superTypeHint;

    public NullAnnotationMatching(int severity, TypeBinding superTypeHint) {
        this.severity = severity;
        this.superTypeHint = superTypeHint;
    }

    public boolean isAnyMismatch() {
        return this.severity != 0;
    }

    public boolean isUnchecked() {
        return this.severity == 1;
    }

    public boolean isDefiniteMismatch() {
        return this.severity == 2;
    }

    public String superTypeHintName(CompilerOptions options, boolean shortNames) {
        return String.valueOf(this.superTypeHint.nullAnnotatedReadableName(options, shortNames));
    }

    public static int checkAssignment(BlockScope currentScope, FlowContext flowContext, VariableBinding var, int nullStatus, Expression expression, TypeBinding providedType) {
        long lhsTagBits = 0L;
        boolean hasReported = false;
        if (currentScope.compilerOptions().sourceLevel < 0x340000L) {
            lhsTagBits = var.tagBits & 0x180000000000000L;
        } else {
            if (expression instanceof ConditionalExpression && expression.isPolyExpression()) {
                int status2;
                ConditionalExpression ce = (ConditionalExpression)expression;
                int status1 = NullAnnotationMatching.checkAssignment(currentScope, flowContext, var, ce.ifTrueNullStatus, ce.valueIfTrue, ce.valueIfTrue.resolvedType);
                if (status1 == (status2 = NullAnnotationMatching.checkAssignment(currentScope, flowContext, var, ce.ifFalseNullStatus, ce.valueIfFalse, ce.valueIfFalse.resolvedType))) {
                    return status1;
                }
                return nullStatus;
            }
            lhsTagBits = var.type.tagBits & 0x180000000000000L;
            NullAnnotationMatching annotationStatus = NullAnnotationMatching.analyse(var.type, providedType, nullStatus);
            if (annotationStatus.isDefiniteMismatch()) {
                currentScope.problemReporter().nullityMismatchingTypeAnnotation(expression, providedType, var.type, annotationStatus);
                hasReported = true;
            } else if (annotationStatus.isUnchecked()) {
                flowContext.recordNullityMismatch(currentScope, expression, providedType, var.type, nullStatus);
                hasReported = true;
            }
        }
        if (lhsTagBits == 0x100000000000000L && nullStatus != 4) {
            if (!hasReported) {
                flowContext.recordNullityMismatch(currentScope, expression, providedType, var.type, nullStatus);
            }
            return 4;
        }
        if (lhsTagBits == 0x80000000000000L && nullStatus == 1) {
            return 16;
        }
        return nullStatus;
    }

    public static NullAnnotationMatching analyse(TypeBinding requiredType, TypeBinding providedType, int nullStatus) {
        return NullAnnotationMatching.analyse(requiredType, providedType, nullStatus, false);
    }

    public static NullAnnotationMatching analyse(TypeBinding requiredType, TypeBinding providedType, int nullStatus, boolean strict) {
        int severity = 0;
        TypeBinding superTypeHint = null;
        if (requiredType instanceof ArrayBinding) {
            long[] requiredDimsTagBits = ((ArrayBinding)requiredType).nullTagBitsPerDimension;
            if (requiredDimsTagBits != null) {
                int dims = requiredType.dimensions();
                if (requiredType.dimensions() == providedType.dimensions()) {
                    long[] providedDimsTagBits = ((ArrayBinding)providedType).nullTagBitsPerDimension;
                    if (providedDimsTagBits == null) {
                        severity = 1;
                    } else {
                        int i = 0;
                        while (i <= dims) {
                            long requiredBits = NullAnnotationMatching.validNullTagBits(requiredDimsTagBits[i]);
                            long providedBits = NullAnnotationMatching.validNullTagBits(providedDimsTagBits[i]);
                            if (i > 0) {
                                nullStatus = -1;
                            }
                            if ((severity = Math.max(severity, NullAnnotationMatching.computeNullProblemSeverity(requiredBits, providedBits, nullStatus, strict))) == 2) {
                                return NULL_ANNOTATIONS_MISMATCH;
                            }
                            ++i;
                        }
                    }
                } else if (providedType.id == 12 && dims > 0 && requiredDimsTagBits[0] == 0x100000000000000L) {
                    return NULL_ANNOTATIONS_MISMATCH;
                }
            }
        } else if (requiredType.hasNullTypeAnnotations() || providedType.hasNullTypeAnnotations()) {
            long requiredBits = NullAnnotationMatching.requiredNullTagBits(requiredType);
            if (requiredBits != 0x80000000000000L || nullStatus == -1) {
                long providedBits = NullAnnotationMatching.providedNullTagBits(providedType);
                severity = NullAnnotationMatching.computeNullProblemSeverity(requiredBits, providedBits, nullStatus, strict && nullStatus == -1);
            }
            if (severity < 2) {
                TypeBinding providedSuper = providedType.findSuperTypeOriginatingFrom(requiredType);
                if (providedSuper != providedType) {
                    superTypeHint = providedSuper;
                }
                if (requiredType.isParameterizedType() && providedSuper instanceof ParameterizedTypeBinding) {
                    TypeBinding[] requiredArguments = ((ParameterizedTypeBinding)requiredType).arguments;
                    TypeBinding[] providedArguments = ((ParameterizedTypeBinding)providedSuper).arguments;
                    if (requiredArguments != null && providedArguments != null && requiredArguments.length == providedArguments.length) {
                        int i = 0;
                        while (i < requiredArguments.length) {
                            NullAnnotationMatching status = NullAnnotationMatching.analyse(requiredArguments[i], providedArguments[i], -1, strict);
                            if ((severity = Math.max(severity, status.severity)) == 2) {
                                return new NullAnnotationMatching(severity, superTypeHint);
                            }
                            ++i;
                        }
                    }
                }
                ReferenceBinding requiredEnclosing = requiredType.enclosingType();
                ReferenceBinding providedEnclosing = providedType.enclosingType();
                if (requiredEnclosing != null && providedEnclosing != null) {
                    NullAnnotationMatching status = NullAnnotationMatching.analyse(requiredEnclosing, providedEnclosing, -1, strict);
                    severity = Math.max(severity, status.severity);
                }
            }
        }
        if (severity == 0) {
            return NULL_ANNOTATIONS_OK;
        }
        return new NullAnnotationMatching(severity, superTypeHint);
    }

    static long requiredNullTagBits(TypeBinding type) {
        long tagBits = type.tagBits & 0x180000000000000L;
        if (tagBits != 0L) {
            return NullAnnotationMatching.validNullTagBits(tagBits);
        }
        if (type.isWildcard()) {
            WildcardBinding wildcard = (WildcardBinding)type;
            if (wildcard.boundKind == 0) {
                return 0L;
            }
            tagBits = wildcard.bound.tagBits & 0x180000000000000L;
            if (tagBits == 0L) {
                return 0L;
            }
            switch (wildcard.boundKind) {
                case 1: {
                    if (tagBits == 0x100000000000000L) {
                        return 0x100000000000000L;
                    }
                    return 0x180000000000000L;
                }
                case 2: {
                    if (tagBits == 0x80000000000000L) {
                        return 0x80000000000000L;
                    }
                    return 0x180000000000000L;
                }
            }
            return 0L;
        }
        if (type.isTypeVariable()) {
            TypeBinding lowerBound;
            TypeVariableBinding typeVariable = (TypeVariableBinding)type;
            boolean haveNullBits = false;
            if (type.isCapture() && (lowerBound = ((CaptureBinding)type).lowerBound) != null) {
                tagBits = lowerBound.tagBits & 0x180000000000000L;
                if (tagBits == 0x80000000000000L) {
                    return 0x80000000000000L;
                }
                boolean bl = haveNullBits = tagBits != 0L;
            }
            if (typeVariable.firstBound != null) {
                haveNullBits |= (typeVariable.firstBound.tagBits & 0x180000000000000L) != 0L;
            }
            if (haveNullBits) {
                return 0x100000000000000L;
            }
        }
        return 0L;
    }

    static long providedNullTagBits(TypeBinding type) {
        long tagBits = type.tagBits & 0x180000000000000L;
        if (tagBits != 0L) {
            return NullAnnotationMatching.validNullTagBits(tagBits);
        }
        if (type.isWildcard()) {
            WildcardBinding wildcard = (WildcardBinding)type;
            if (wildcard.boundKind == 0) {
                return 0L;
            }
            tagBits = wildcard.bound.tagBits & 0x180000000000000L;
            if (tagBits == 0L) {
                return 0L;
            }
            switch (wildcard.boundKind) {
                case 1: {
                    if (tagBits == 0x100000000000000L) {
                        return 0x100000000000000L;
                    }
                    return 0x180000000000000L;
                }
                case 2: {
                    if (tagBits == 0x80000000000000L) {
                        return 0x80000000000000L;
                    }
                    return 0x180000000000000L;
                }
            }
            return 0L;
        }
        if (type.isTypeVariable()) {
            TypeBinding lowerBound;
            TypeVariableBinding typeVariable = (TypeVariableBinding)type;
            boolean haveNullBits = false;
            if (typeVariable.isCapture() && (lowerBound = ((CaptureBinding)typeVariable).lowerBound) != null) {
                tagBits = lowerBound.tagBits & 0x180000000000000L;
                if (tagBits == 0x80000000000000L) {
                    return 0x80000000000000L;
                }
                haveNullBits |= tagBits != 0L;
            }
            if (typeVariable.firstBound != null) {
                long boundBits = typeVariable.firstBound.tagBits & 0x180000000000000L;
                if (boundBits == 0x100000000000000L) {
                    return 0x100000000000000L;
                }
                haveNullBits |= boundBits != 0L;
            }
            if (haveNullBits) {
                return 0x180000000000000L;
            }
        }
        return 0L;
    }

    public static long validNullTagBits(long bits) {
        return (bits &= 0x180000000000000L) == 0x180000000000000L ? 0L : bits;
    }

    public static TypeBinding moreDangerousType(TypeBinding one, TypeBinding two) {
        long twoNullBits;
        if (one == null) {
            return null;
        }
        long oneNullBits = NullAnnotationMatching.validNullTagBits(one.tagBits);
        if (oneNullBits != (twoNullBits = NullAnnotationMatching.validNullTagBits(two.tagBits))) {
            if (oneNullBits == 0x80000000000000L) {
                return one;
            }
            if (twoNullBits == 0x80000000000000L) {
                return two;
            }
            if (oneNullBits == 0L) {
                return one;
            }
            return two;
        }
        if (one != two && NullAnnotationMatching.analyse(one, two, -1).isAnyMismatch()) {
            return two;
        }
        return one;
    }

    private static int computeNullProblemSeverity(long requiredBits, long providedBits, int nullStatus, boolean strict) {
        if ((requiredBits != 0L || strict) && requiredBits != providedBits) {
            if (requiredBits == 0x100000000000000L && nullStatus == 4) {
                return 0;
            }
            if (requiredBits == 0x180000000000000L) {
                return 0;
            }
            if (providedBits != 0L) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static MethodBinding checkForContraditions(MethodBinding method, InvocationSite invocationSite, Scope scope) {
        class SearchContradictions
        extends TypeBindingVisitor {
            ReferenceBinding typeWithContradiction;

            SearchContradictions() {
            }

            @Override
            public boolean visit(ReferenceBinding referenceBinding) {
                if ((referenceBinding.tagBits & 0x180000000000000L) == 0x180000000000000L) {
                    this.typeWithContradiction = referenceBinding;
                    return false;
                }
                return true;
            }

            @Override
            public boolean visit(TypeVariableBinding typeVariable) {
                return this.visit((ReferenceBinding)typeVariable);
            }

            @Override
            public boolean visit(RawTypeBinding rawType) {
                return this.visit((ReferenceBinding)rawType);
            }
        }
        SearchContradictions searchContradiction = new SearchContradictions();
        TypeBindingVisitor.visit((TypeBindingVisitor)searchContradiction, method.returnType);
        if (searchContradiction.typeWithContradiction != null) {
            if (scope == null) {
                return new ProblemMethodBinding(method, method.selector, method.parameters, 25);
            }
            scope.problemReporter().contradictoryNullAnnotationsInferred(method, invocationSite);
            return method;
        }
        Expression[] arguments = null;
        if (invocationSite instanceof Invocation) {
            arguments = ((Invocation)invocationSite).arguments();
        }
        int i = 0;
        while (i < method.parameters.length) {
            TypeBindingVisitor.visit((TypeBindingVisitor)searchContradiction, method.parameters[i]);
            if (searchContradiction.typeWithContradiction != null) {
                if (scope == null) {
                    return new ProblemMethodBinding(method, method.selector, method.parameters, 25);
                }
                if (arguments != null && i < arguments.length) {
                    scope.problemReporter().contradictoryNullAnnotationsInferred(method, arguments[i]);
                } else {
                    scope.problemReporter().contradictoryNullAnnotationsInferred(method, invocationSite);
                }
                return method;
            }
            ++i;
        }
        return method;
    }
}

