/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.tree.content;

import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public abstract class StyledLinkLabel<T>
extends Panel {
    private static final StyleBehavior STYLE_CLASS = new StyleBehavior();
    private static final long serialVersionUID = 1L;

    public StyledLinkLabel(String id, IModel<T> model) {
        super(id, model);
        MarkupContainer link = this.newLinkComponent("link", model);
        link.add(new Behavior[]{STYLE_CLASS});
        this.add(new Component[]{link});
        link.add(new Component[]{this.newLabelComponent("label", model)});
    }

    public IModel<T> getModel() {
        return this.getDefaultModel();
    }

    public T getModelObject() {
        return (T)this.getModel().getObject();
    }

    protected MarkupContainer newLinkComponent(String id, IModel<T> model) {
        return new AjaxFallbackLink<Void>(id){
            private static final long serialVersionUID = 1L;

            public boolean isEnabled() {
                return StyledLinkLabel.this.isClickable();
            }

            public void onClick(Optional<AjaxRequestTarget> targetOptional) {
                StyledLinkLabel.this.onClick(targetOptional);
            }
        };
    }

    protected Component newLabelComponent(String id, IModel<T> model) {
        return new Label(id, this.newLabelModel(model));
    }

    protected IModel<?> newLabelModel(IModel<T> model) {
        return model;
    }

    protected abstract String getStyleClass();

    protected boolean isClickable() {
        return false;
    }

    protected void onClick(Optional<AjaxRequestTarget> target) {
    }

    private static class StyleBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;

        private StyleBehavior() {
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            StyledLinkLabel parent = (StyledLinkLabel)component.getParent();
            String styleClass = parent.getStyleClass();
            if (styleClass != null) {
                tag.put("class", (CharSequence)styleClass);
            }
        }
    }
}

