/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class SSLValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(SSLValve.class);

    public SSLValve() {
        super(true);
    }

    public String mygetHeader(Request request, String header) {
        String strcert0 = request.getHeader(header);
        if (strcert0 == null) {
            return null;
        }
        if ("(null)".equals(strcert0)) {
            return null;
        }
        return strcert0;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        String strcert0 = this.mygetHeader(request, "ssl_client_cert");
        if (strcert0 != null && strcert0.length() > 28) {
            String strcert1 = strcert0.replace(' ', '\n');
            String strcert2 = strcert1.substring(28, strcert1.length() - 26);
            String strcert3 = "-----BEGIN CERTIFICATE-----\n";
            String strcert4 = strcert3.concat(strcert2);
            String strcerts = strcert4.concat("\n-----END CERTIFICATE-----\n");
            ByteArrayInputStream bais = new ByteArrayInputStream(strcerts.getBytes());
            X509Certificate[] jsseCerts = null;
            String providerName = (String)request.getConnector().getProperty("clientCertProvider");
            try {
                CertificateFactory cf = providerName == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", providerName);
                X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                jsseCerts = new X509Certificate[]{cert};
            }
            catch (CertificateException e) {
                log.warn((Object)sm.getString("sslValve.certError", new Object[]{strcerts}), (Throwable)e);
            }
            catch (NoSuchProviderException e) {
                log.error((Object)sm.getString("sslValve.invalidProvider", new Object[]{providerName}), (Throwable)e);
            }
            request.setAttribute("javax.servlet.request.X509Certificate", jsseCerts);
        }
        if ((strcert0 = this.mygetHeader(request, "ssl_cipher")) != null) {
            request.setAttribute("javax.servlet.request.cipher_suite", strcert0);
        }
        if ((strcert0 = this.mygetHeader(request, "ssl_session_id")) != null) {
            request.setAttribute("javax.servlet.request.ssl_session", strcert0);
        }
        if ((strcert0 = this.mygetHeader(request, "ssl_cipher_usekeysize")) != null) {
            request.setAttribute("javax.servlet.request.key_size", Integer.valueOf(strcert0));
        }
        this.getNext().invoke(request, response);
    }
}

