/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.process.traversal.strategy.optimization;

import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.process.traversal.step.sideEffect.TinkerGraphStep;

public final class TinkerGraphStepStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final TinkerGraphStepStrategy INSTANCE = new TinkerGraphStepStrategy();

    private TinkerGraphStepStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        if (TraversalHelper.onGraphComputer(traversal)) {
            return;
        }
        TraversalHelper.getStepsOfClass(GraphStep.class, traversal).forEach(originalGraphStep -> {
            TinkerGraphStep tinkerGraphStep = new TinkerGraphStep(originalGraphStep);
            TraversalHelper.replaceStep((Step)originalGraphStep, tinkerGraphStep, (Traversal.Admin)traversal);
            Step currentStep = tinkerGraphStep.getNextStep();
            while (currentStep instanceof HasContainerHolder) {
                ((HasContainerHolder)currentStep).getHasContainers().forEach(hasContainer -> {
                    if (!GraphStep.processHasContainerIds((GraphStep)tinkerGraphStep, (HasContainer)hasContainer)) {
                        tinkerGraphStep.addHasContainer((HasContainer)hasContainer);
                    }
                });
                currentStep.getLabels().forEach(arg_0 -> tinkerGraphStep.addLabel(arg_0));
                traversal.removeStep(currentStep);
                currentStep = currentStep.getNextStep();
            }
        });
    }

    public static TinkerGraphStepStrategy instance() {
        return INSTANCE;
    }
}

