/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn.security;

import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.deploy.yarn.security.YARNHadoopDelegationTokenManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb!B\u0001\u0003\u0001\u0011q!aE!N\u0007J,G-\u001a8uS\u0006d'+\u001a8fo\u0016\u0014(BA\u0002\u0005\u0003!\u0019XmY;sSRL(BA\u0003\u0007\u0003\u0011I\u0018M\u001d8\u000b\u0005\u001dA\u0011A\u00023fa2|\u0017P\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\r\u0001q\"\u0006\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005YIR\"A\f\u000b\u0005aA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005i9\"a\u0002'pO\u001eLgn\u001a\u0005\t9\u0001\u0011\t\u0011)A\u0005=\u0005I1\u000f]1sW\u000e{gNZ\u0002\u0001!\ty\u0002%D\u0001\t\u0013\t\t\u0003BA\u0005Ta\u0006\u00148nQ8oM\"A1\u0005\u0001B\u0001B\u0003%A%\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t\r|gN\u001a\u0006\u0003S)\ta\u0001[1e_>\u0004\u0018BA\u0016'\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"AQ\u0006\u0001B\u0001B\u0003%a&A\tde\u0016$WM\u001c;jC2l\u0015M\\1hKJ\u0004\"a\f\u0019\u000e\u0003\tI!!\r\u0002\u0003Ae\u000b%K\u0014%bI>|\u0007\u000fR3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM\u001d\u0005\u0006g\u0001!\t\u0001N\u0001\u0007y%t\u0017\u000e\u001e \u0015\tU2t\u0007\u000f\t\u0003_\u0001AQ\u0001\b\u001aA\u0002yAQa\t\u001aA\u0002\u0011BQ!\f\u001aA\u00029BqA\u000f\u0001A\u0002\u0013%1(A\rmCN$8I]3eK:$\u0018.\u00197t\r&dWmU;gM&DX#\u0001\u001f\u0011\u0005Ai\u0014B\u0001 \u0012\u0005\rIe\u000e\u001e\u0005\b\u0001\u0002\u0001\r\u0011\"\u0003B\u0003ua\u0017m\u001d;De\u0016$WM\u001c;jC2\u001ch)\u001b7f'V4g-\u001b=`I\u0015\fHC\u0001\"F!\t\u00012)\u0003\u0002E#\t!QK\\5u\u0011\u001d1u(!AA\u0002q\n1\u0001\u001f\u00132\u0011\u0019A\u0005\u0001)Q\u0005y\u0005QB.Y:u\u0007J,G-\u001a8uS\u0006d7OR5mKN+hMZ5yA!9!\n\u0001b\u0001\n\u0013Y\u0015aF2sK\u0012,g\u000e^5bYJ+g.Z<feRC'/Z1e+\u0005a\u0005CA'U\u001b\u0005q%BA(Q\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003#J\u000bA!\u001e;jY*\t1+\u0001\u0003kCZ\f\u0017BA+O\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-\u001a\u0005\u0007/\u0002\u0001\u000b\u0011\u0002'\u00021\r\u0014X\rZ3oi&\fGNU3oK^,'\u000f\u00165sK\u0006$\u0007\u0005C\u0004Z\u0001\t\u0007I\u0011\u0002.\u0002\u0015!\fGm\\8q+RLG.F\u0001\\!\taV,D\u0001\u0007\u0013\tqfAA\bTa\u0006\u00148\u000eS1e_>\u0004X\u000b^5m\u0011\u0019\u0001\u0007\u0001)A\u00057\u0006Y\u0001.\u00193p_B,F/\u001b7!\u0011\u001d\u0011\u0007A1A\u0005\n\r\fqb\u0019:fI\u0016tG/[1mg\u001aKG.Z\u000b\u0002IB\u0011Q\r\u001b\b\u0003!\u0019L!aZ\t\u0002\rA\u0013X\rZ3g\u0013\tI'N\u0001\u0004TiJLgn\u001a\u0006\u0003OFAa\u0001\u001c\u0001!\u0002\u0013!\u0017\u0001E2sK\u0012,g\u000e^5bYN4\u0015\u000e\\3!\u0011\u001dq\u0007A1A\u0005\nm\nq\u0002Z1zgR{7*Z3q\r&dWm\u001d\u0005\u0007a\u0002\u0001\u000b\u0011\u0002\u001f\u0002!\u0011\f\u0017p\u001d+p\u0017\u0016,\u0007OR5mKN\u0004\u0003b\u0002:\u0001\u0005\u0004%IaO\u0001\u000f]Vlg)\u001b7fgR{7*Z3q\u0011\u0019!\b\u0001)A\u0005y\u0005ya.^7GS2,7\u000fV8LK\u0016\u0004\b\u0005C\u0004w\u0001\t\u0007I\u0011B<\u0002\u001f\u0019\u0014Xm\u001d5IC\u0012|w\u000e]\"p]\u001a,\u0012\u0001\n\u0005\u0007s\u0002\u0001\u000b\u0011\u0002\u0013\u0002!\u0019\u0014Xm\u001d5IC\u0012|w\u000e]\"p]\u001a\u0004\u0003bB>\u0001\u0001\u0004%I\u0001`\u0001\u0012i&lWm\u00144OKb$(+\u001a8fo\u0006dW#A?\u0011\u0005Aq\u0018BA@\u0012\u0005\u0011auN\\4\t\u0013\u0005\r\u0001\u00011A\u0005\n\u0005\u0015\u0011!\u0006;j[\u0016|eMT3yiJ+g.Z<bY~#S-\u001d\u000b\u0004\u0005\u0006\u001d\u0001\u0002\u0003$\u0002\u0002\u0005\u0005\t\u0019A?\t\u000f\u0005-\u0001\u0001)Q\u0005{\u0006\u0011B/[7f\u001f\u001atU\r\u001f;SK:,w/\u00197!Q\u0011\tI!a\u0004\u0011\u0007A\t\t\"C\u0002\u0002\u0014E\u0011\u0001B^8mCRLG.\u001a\u0005\t\u0003/\u0001A\u0011\u0001\u0005\u0002\u001a\u000592o\u00195fIVdW\rT8hS:4%o\\7LKf$\u0018M\u0019\u000b\u0002\u0005\"9\u0011Q\u0004\u0001\u0005\n\u0005e\u0011aD2mK\u0006tW\u000f](mI\u001aKG.Z:\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$\u0005IrO]5uK:+wo\u0011:fI\u0016tG/[1mgR{\u0007\n\u0012$T)\u0015\u0011\u0015QEA\u0015\u0011\u001d\t9#a\bA\u0002\u0011\f\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\t\u000f\u0005-\u0012q\u0004a\u0001I\u000611.Z=uC\nDq!a\f\u0001\t\u0003\tI\"\u0001\u0003ti>\u0004\b")
public class AMCredentialRenewer
implements Logging {
    private final SparkConf sparkConf;
    public final YARNHadoopDelegationTokenManager org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager;
    private int org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix;
    private final ScheduledExecutorService org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialRenewerThread;
    private final SparkHadoopUtil org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil;
    private final String credentialsFile;
    private final int daysToKeepFiles;
    private final int numFilesToKeep;
    private final Configuration org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf;
    private volatile long timeOfNextRenewal;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private int org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix() {
        return this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix;
    }

    public void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix = x$1;
    }

    public ScheduledExecutorService org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialRenewerThread() {
        return this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialRenewerThread;
    }

    public SparkHadoopUtil org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil() {
        return this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil;
    }

    private String credentialsFile() {
        return this.credentialsFile;
    }

    private int daysToKeepFiles() {
        return this.daysToKeepFiles;
    }

    private int numFilesToKeep() {
        return this.numFilesToKeep;
    }

    public Configuration org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf() {
        return this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf;
    }

    private long timeOfNextRenewal() {
        return this.timeOfNextRenewal;
    }

    private void timeOfNextRenewal_$eq(long x$1) {
        this.timeOfNextRenewal = x$1;
    }

    public void scheduleLoginFromKeytab() {
        String principal = (String)((Option)this.sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.PRINCIPAL())).get();
        String keytab = (String)((Option)this.sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.KEYTAB())).get();
        Runnable credentialRenewerRunnable = new Runnable(this, principal, keytab){
            private final /* synthetic */ AMCredentialRenewer $outer;
            private final String principal$1;
            private final String keytab$1;

            public void run() {
                try {
                    this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$writeNewCredentialsToHDFS(this.principal$1, this.keytab$1);
                    this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$cleanupOldFiles();
                    this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$scheduleRenewal$1(this);
                    return;
                }
                catch (Exception exception) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Failed to write out new credentials to HDFS, will try again in an hour! If this happens too often tasks will fail.";
                        }
                    }, exception);
                    this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialRenewerThread().schedule(this, 1L, TimeUnit.HOURS);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.principal$1 = principal$1;
                this.keytab$1 = keytab$1;
            }
        };
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$scheduleRenewal$1(credentialRenewerRunnable);
    }

    public void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$cleanupOldFiles() {
        try {
            FileSystem remoteFs = FileSystem.get((Configuration)this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf());
            Path credentialsPath = new Path(this.credentialsFile());
            long thresholdTime = System.currentTimeMillis() - new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(this.daysToKeepFiles())).days().toMillis();
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil().listFilesSorted(remoteFs, credentialsPath.getParent(), credentialsPath.getName(), SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION())).dropRight(this.numFilesToKeep())).takeWhile((Function1)new Serializable(this, thresholdTime){
                public static final long serialVersionUID = 0L;
                private final long thresholdTime$1;

                public final boolean apply(FileStatus x$1) {
                    return x$1.getModificationTime() < this.thresholdTime$1;
                }
                {
                    this.thresholdTime$1 = thresholdTime$1;
                }
            })).foreach((Function1)new Serializable(this, remoteFs){
                public static final long serialVersionUID = 0L;
                private final FileSystem remoteFs$1;

                public final boolean apply(FileStatus x) {
                    return this.remoteFs$1.delete(x.getPath(), true);
                }
                {
                    this.remoteFs$1 = remoteFs$1;
                }
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while attempting to cleanup old credentials. If you are seeing many such warnings there may be an issue with your HDFS cluster.";
                }
            }, exception);
        }
    }

    public void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$writeNewCredentialsToHDFS(String principal, String keytab) {
        long l;
        this.logInfo((Function0<String>)new Serializable(this, principal){
            public static final long serialVersionUID = 0L;
            private final String principal$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to login to KDC using principal: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.principal$2}));
            }
            {
                this.principal$2 = principal$2;
            }
        });
        UserGroupInformation keytabLoggedInUGI = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytab);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Successfully logged into KDC.";
            }
        });
        Credentials tempCreds = keytabLoggedInUGI.getCredentials();
        Path credentialsPath = new Path(this.credentialsFile());
        Path dst = credentialsPath.getParent();
        LongRef nearestNextRenewalTime = LongRef.create((long)Long.MAX_VALUE);
        keytabLoggedInUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(this, tempCreds, nearestNextRenewalTime){
            private final /* synthetic */ AMCredentialRenewer $outer;
            private final Credentials tempCreds$1;
            private final LongRef nearestNextRenewalTime$1;

            public Void run() {
                this.nearestNextRenewalTime$1.elem = this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager.obtainDelegationTokens(this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf(), this.tempCreds$1);
                return null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tempCreds$1 = tempCreds$1;
                this.nearestNextRenewalTime$1 = nearestNextRenewalTime$1;
            }
        });
        long currTime = System.currentTimeMillis();
        if (nearestNextRenewalTime.elem <= currTime) {
            this.logWarning((Function0<String>)new Serializable(this, nearestNextRenewalTime, currTime){
                public static final long serialVersionUID = 0L;
                private final LongRef nearestNextRenewalTime$1;
                private final long currTime$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Next credential renewal time (", ") is earlier than "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.nearestNextRenewalTime$1.elem)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current time (", "), which is unexpected, please check your credential renewal "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.currTime$1)}))).append((Object)"related configurations in the target services.").toString();
                }
                {
                    this.nearestNextRenewalTime$1 = nearestNextRenewalTime$1;
                    this.currTime$1 = currTime$1;
                }
            });
            this.timeOfNextRenewal_$eq(currTime);
            l = currTime;
        } else {
            this.timeOfNextRenewal_$eq(SparkHadoopUtil$.MODULE$.getDateOfNextUpdate(nearestNextRenewalTime.elem, 0.75));
            l = SparkHadoopUtil$.MODULE$.getDateOfNextUpdate(nearestNextRenewalTime.elem, 0.8);
        }
        long timeOfNextUpdate = l;
        UserGroupInformation.getCurrentUser().addCredentials(tempCreds);
        FileSystem remoteFs = FileSystem.get((Configuration)this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf());
        if (this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix() == 0) {
            Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil().listFilesSorted(remoteFs, credentialsPath.getParent(), credentialsPath.getName(), SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION())).lastOption().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AMCredentialRenewer $outer;

                public final void apply(FileStatus status) {
                    this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix_$eq(this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil().getSuffixForCredentialsPath(status.getPath()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        int nextSuffix = this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix() + 1;
        String tokenPathStr = new StringBuilder().append((Object)this.credentialsFile()).append((Object)SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM()).append((Object)((Object)BoxesRunTime.boxToLong((long)timeOfNextUpdate)).toString()).append((Object)SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM()).append((Object)BoxesRunTime.boxToInteger((int)nextSuffix)).toString();
        Path tokenPath = new Path(tokenPathStr);
        Path tempTokenPath = new Path(new StringBuilder().append((Object)tokenPathStr).append((Object)SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION()).toString());
        this.logInfo((Function0<String>)new Serializable(this, tempTokenPath){
            public static final long serialVersionUID = 0L;
            private final Path tempTokenPath$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Writing out delegation tokens to ").append((Object)this.tempTokenPath$1.toString()).toString();
            }
            {
                this.tempTokenPath$1 = tempTokenPath$1;
            }
        });
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        credentials.writeTokenStorageFile(tempTokenPath, this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf());
        this.logInfo((Function0<String>)new Serializable(this, tokenPathStr){
            public static final long serialVersionUID = 0L;
            private final String tokenPathStr$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delegation Tokens written out successfully. Renaming file to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tokenPathStr$1}));
            }
            {
                this.tokenPathStr$1 = tokenPathStr$1;
            }
        });
        remoteFs.rename(tempTokenPath, tokenPath);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Delegation token file rename complete.";
            }
        });
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix_$eq(nextSuffix);
    }

    public void stop() {
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialRenewerThread().shutdown();
    }

    public final void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$scheduleRenewal$1(Runnable runnable) {
        long remainingTime = this.timeOfNextRenewal() - System.currentTimeMillis();
        if (remainingTime <= 0L) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Credentials have expired, creating new ones now.";
                }
            });
            runnable.run();
        } else {
            this.logInfo((Function0<String>)new Serializable(this, remainingTime){
                public static final long serialVersionUID = 0L;
                private final long remainingTime$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scheduling login from keytab in ", " millis."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.remainingTime$1)}));
                }
                {
                    this.remainingTime$1 = remainingTime$1;
                }
            });
            this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialRenewerThread().schedule(runnable, remainingTime, TimeUnit.MILLISECONDS);
        }
    }

    public AMCredentialRenewer(SparkConf sparkConf, Configuration hadoopConf, YARNHadoopDelegationTokenManager credentialManager) {
        this.sparkConf = sparkConf;
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager = credentialManager;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix = 0;
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialRenewerThread = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("Credential Refresh Thread");
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil = SparkHadoopUtil$.MODULE$.get();
        this.credentialsFile = (String)sparkConf.get(package$.MODULE$.CREDENTIALS_FILE_PATH());
        this.daysToKeepFiles = BoxesRunTime.unboxToInt((Object)sparkConf.get(package$.MODULE$.CREDENTIALS_FILE_MAX_RETENTION()));
        this.numFilesToKeep = BoxesRunTime.unboxToInt((Object)sparkConf.get(package$.MODULE$.CREDENTIAL_FILE_MAX_COUNT()));
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf = this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil().getConfBypassingFSCache(hadoopConf, new Path(this.credentialsFile()).toUri().getScheme());
        this.timeOfNextRenewal = BoxesRunTime.unboxToLong((Object)sparkConf.get(package$.MODULE$.CREDENTIALS_RENEWAL_TIME()));
    }
}

