/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetMapValueUtil;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, index) - Returns element of array at given (1-based) index. If index < 0,\n      accesses elements from the last to the first. Returns NULL if the index exceeds the length\n      of the array.\n\n    _FUNC_(map, key) - Returns value for given key, or NULL if the key is not contained in the map\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 2);\n       2\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), 2);\n       b\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\tea\u0001B\u0001\u0003\u0001>\u0011\u0011\"\u00127f[\u0016tG/\u0011;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00155A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0010\u000f\u0016$X*\u00199WC2,X-\u0016;jYB\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t9\u0001K]8ek\u000e$\bCA\u000b\u001c\u0013\tabC\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001f\u0001\tU\r\u0011\"\u0001 \u0003\u0011aWM\u001a;\u0016\u0003\u0001\u0002\"!E\u0011\n\u0005\t\u0012!AC#yaJ,7o]5p]\"AA\u0005\u0001B\tB\u0003%\u0001%A\u0003mK\u001a$\b\u0005\u0003\u0005'\u0001\tU\r\u0011\"\u0001 \u0003\u0015\u0011\u0018n\u001a5u\u0011!A\u0003A!E!\u0002\u0013\u0001\u0013A\u0002:jO\"$\b\u0005C\u0003+\u0001\u0011\u00051&\u0001\u0004=S:LGO\u0010\u000b\u0004Y5r\u0003CA\t\u0001\u0011\u0015q\u0012\u00061\u0001!\u0011\u00151\u0013\u00061\u0001!\u0011!\u0001\u0004\u0001#b\u0001\n\u0013\t\u0014AC7ba.+\u0017\u0010V=qKV\t!\u0007\u0005\u00024m5\tAG\u0003\u00026\r\u0005)A/\u001f9fg&\u0011q\u0007\u000e\u0002\t\t\u0006$\u0018\rV=qK\"A\u0011\b\u0001E\u0001B\u0003&!'A\u0006nCB\\U-\u001f+za\u0016\u0004\u0003F\u0001\u001d<!\t)B(\u0003\u0002>-\tIAO]1og&,g\u000e\u001e\u0005\t\u007f\u0001A)\u0019!C\u0005\u0001\u0006\t\u0012M\u001d:bs\u000e{g\u000e^1j]NtU\u000f\u001c7\u0016\u0003\u0005\u0003\"!\u0006\"\n\u0005\r3\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u000b\u0002A\t\u0011)Q\u0005\u0003\u0006\u0011\u0012M\u001d:bs\u000e{g\u000e^1j]NtU\u000f\u001c7!Q\t!5\b\u0003\u0005I\u0001!\u0015\r\u0011\"\u0003J\u0003!y'\u000fZ3sS:<W#\u0001&\u0011\u0007-\u001bfK\u0004\u0002M#:\u0011Q\nU\u0007\u0002\u001d*\u0011qJD\u0001\u0007yI|w\u000e\u001e \n\u0003]I!A\u0015\f\u0002\u000fA\f7m[1hK&\u0011A+\u0016\u0002\t\u001fJ$WM]5oO*\u0011!K\u0006\t\u0003+]K!\u0001\u0017\f\u0003\u0007\u0005s\u0017\u0010\u0003\u0005[\u0001!\u0005\t\u0015)\u0003K\u0003%y'\u000fZ3sS:<\u0007\u0005\u000b\u0002Zw!AQ\f\u0001EC\u0002\u0013\u0005\u0013'\u0001\u0005eCR\fG+\u001f9f\u0011!y\u0006\u0001#A!B\u0013\u0011\u0014!\u00033bi\u0006$\u0016\u0010]3!Q\tq6\bC\u0003c\u0001\u0011\u00053-\u0001\u0006j]B,H\u000fV=qKN,\u0012\u0001\u001a\t\u0004\u0017\u0016<\u0017B\u00014V\u0005\r\u0019V-\u001d\t\u0003g!L!!\u001b\u001b\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0007\"B6\u0001\t\u0003b\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#A7\u0011\u00059\fX\"A8\u000b\u0005A$\u0011\u0001C1oC2L8/[:\n\u0005I|'a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\t\u000bQ\u0004A\u0011\t!\u0002\u00119,H\u000e\\1cY\u0016DQA\u001e\u0001\u0005B]\fAB\\;mYN\u000bg-Z#wC2$2A\u0016={\u0011\u0015IX\u000f1\u0001W\u0003\u00151\u0018\r\\;f\u0011\u0015YX\u000f1\u0001W\u0003\u001dy'\u000fZ5oC2D\u0001\" \u0001\t\u0006\u0004%IA`\u0001\fI>,E.Z7f]R\fE/F\u0001\u0000!\u0019)\u0012\u0011\u0001,W-&\u0019\u00111\u0001\f\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\"CA\u0004\u0001!\u0005\t\u0015)\u0003\u0000\u00031!w.\u00127f[\u0016tG/\u0011;!Q\r\t)a\u000f\u0005\b\u0003\u001b\u0001A\u0011IA\b\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\u0012\u0005u\u0011q\u0005\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003\u0002\u0002\u000f\r|G-Z4f]&!\u00111DA\u000b\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\u0002CA\u0010\u0003\u0017\u0001\r!!\t\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u0014\u0005\r\u0012\u0002BA\u0013\u0003+\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0005\u0002*\u0005-\u0001\u0019AA\t\u0003\t)g\u000fC\u0004\u0002.\u0001!\t%a\f\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u00022A!\u00111GA\u001d\u001d\r)\u0012QG\u0005\u0004\u0003o1\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002<\u0005u\"AB*ue&twMC\u0002\u00028YA\u0011\"!\u0011\u0001\u0003\u0003%\t!a\u0011\u0002\t\r|\u0007/\u001f\u000b\u0006Y\u0005\u0015\u0013q\t\u0005\t=\u0005}\u0002\u0013!a\u0001A!Aa%a\u0010\u0011\u0002\u0003\u0007\u0001\u0005C\u0005\u0002L\u0001\t\n\u0011\"\u0001\u0002N\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA(U\r\u0001\u0013\u0011K\u0016\u0003\u0003'\u0002B!!\u0016\u0002`5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\f\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002b\u0005]#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\r\u0001\u0012\u0002\u0013\u0005\u0011QJ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\tI\u0007AA\u0001\n\u0003\nY'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003[\u0002B!a\u001c\u0002z5\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\n)(\u0001\u0003mC:<'BAA<\u0003\u0011Q\u0017M^1\n\t\u0005m\u0012\u0011\u000f\u0005\n\u0003{\u0002\u0011\u0011!C\u0001\u0003\u007f\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!!\u0011\u0007U\t\u0019)C\u0002\u0002\u0006Z\u00111!\u00138u\u0011%\tI\tAA\u0001\n\u0003\tY)\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007Y\u000bi\t\u0003\u0006\u0002\u0010\u0006\u001d\u0015\u0011!a\u0001\u0003\u0003\u000b1\u0001\u001f\u00132\u0011%\t\u0019\nAA\u0001\n\u0003\n)*A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\nE\u0003\u0002\u001a\u0006}e+\u0004\u0002\u0002\u001c*\u0019\u0011Q\u0014\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\"\u0006m%\u0001C%uKJ\fGo\u001c:\t\u0013\u0005\u0015\u0006!!A\u0005\u0002\u0005\u001d\u0016\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\u0005\u000bI\u000bC\u0005\u0002\u0010\u0006\r\u0016\u0011!a\u0001-\"I\u0011Q\u0016\u0001\u0002\u0002\u0013\u0005\u0013qV\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0005\u000b\t\fC\u0005\u0002\u0010\u0006-\u0016\u0011!a\u0001-\"z\u0001!!.\u0002<\u0006u\u0016\u0011YAb\u0003\u000f\fI\rE\u0002\u0012\u0003oK1!!/\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a0\u0002\u0005cR\u0001\u0005\t\u0011!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0017!S:$W\r_\u0015![\u0001\u0012V\r^;s]N\u0004S\r\\3nK:$\be\u001c4!CJ\u0014\u0018-\u001f\u0011bi\u0002:\u0017N^3oA!\nTFY1tK\u0012L\u0003%\u001b8eKbt\u0003%\u00134!S:$W\r\u001f\u0011=AAb#\u0002\t\u0011!A\u0001\u0002\u0013mY2fgN,7\u000fI3mK6,g\u000e^:!MJ|W\u000e\t;iK\u0002b\u0017m\u001d;!i>\u0004C\u000f[3!M&\u00148\u000f\u001e\u0018!%\u0016$XO\u001d8tA9+F\n\u0014\u0011jM\u0002\"\b.\u001a\u0011j]\u0012,\u0007\u0010I3yG\u0016,Gm\u001d\u0011uQ\u0016\u0004C.\u001a8hi\"T\u0001\u0005\t\u0011!A\u0001zg\r\t;iK\u0002\n'O]1z])Q\u0001\u0005\t\u0011!?\u001a+fjQ0)[\u0006\u0004H\u0006I6fs&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011wC2,X\r\t4pe\u0002:\u0017N^3oA-,\u0017\u0010\f\u0011pe\u0002rU\u000b\u0014'!S\u001a\u0004C\u000f[3!W\u0016L\b%[:!]>$\beY8oi\u0006Lg.\u001a3!S:\u0004C\u000f[3![\u0006\u0004(\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!2\u0002y*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\nD\u0006\t\u001a-AMJC\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK7ba\"\nD\u0006I\u0014bO1\u0002#\u0007\f\u0011(E\u001eJC\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005-\u0017!\u0002\u001a/i9\u0002t!CAh\u0005\u0005\u0005\t\u0012AAi\u0003%)E.Z7f]R\fE\u000fE\u0002\u0012\u0003'4\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011Q[\n\u0006\u0003'\f9N\u0007\t\b\u00033\fy\u000e\t\u0011-\u001b\t\tYNC\u0002\u0002^Z\tqA];oi&lW-\u0003\u0003\u0002b\u0006m'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9!&a5\u0005\u0002\u0005\u0015HCAAi\u0011)\tI/a5\u0002\u0002\u0013\u0015\u00131^\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u000e\u0005\u000b\u0003_\f\u0019.!A\u0005\u0002\u0006E\u0018!B1qa2LH#\u0002\u0017\u0002t\u0006U\bB\u0002\u0010\u0002n\u0002\u0007\u0001\u0005\u0003\u0004'\u0003[\u0004\r\u0001\t\u0005\u000b\u0003s\f\u0019.!A\u0005\u0002\u0006m\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0003{\u0014I\u0001E\u0003\u0016\u0003\u007f\u0014\u0019!C\u0002\u0003\u0002Y\u0011aa\u00149uS>t\u0007#B\u000b\u0003\u0006\u0001\u0002\u0013b\u0001B\u0004-\t1A+\u001e9mKJB\u0011Ba\u0003\u0002x\u0006\u0005\t\u0019\u0001\u0017\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003\u0010\u0005M\u0017\u0011!C\u0005\u0005#\t1B]3bIJ+7o\u001c7wKR\u0011!1\u0003\t\u0005\u0003_\u0012)\"\u0003\u0003\u0003\u0018\u0005E$AB(cU\u0016\u001cG\u000f")
public class ElementAt
extends GetMapValueUtil
implements Serializable {
    private final Expression left;
    private final Expression right;
    private transient DataType org$apache$spark$sql$catalyst$expressions$ElementAt$$mapKeyType;
    private transient boolean org$apache$spark$sql$catalyst$expressions$ElementAt$$arrayContainsNull;
    private transient Ordering<Object> org$apache$spark$sql$catalyst$expressions$ElementAt$$ordering;
    private transient DataType dataType;
    private transient Function2<Object, Object, Object> doElementAt;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ElementAt elementAt) {
        return ElementAt$.MODULE$.unapply(elementAt);
    }

    public static Function1<Tuple2<Expression, Expression>, ElementAt> tupled() {
        return ElementAt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ElementAt>> curried() {
        return ElementAt$.MODULE$.curried();
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ElementAt$$mapKeyType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ElementAt$$mapKeyType = ((MapType)this.left().dataType()).keyType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.org$apache$spark$sql$catalyst$expressions$ElementAt$$mapKeyType;
        }
    }

    private boolean org$apache$spark$sql$catalyst$expressions$ElementAt$$arrayContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ElementAt$$arrayContainsNull = ((ArrayType)this.left().dataType()).containsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.org$apache$spark$sql$catalyst$expressions$ElementAt$$arrayContainsNull;
        }
    }

    private Ordering org$apache$spark$sql$catalyst$expressions$ElementAt$$ordering$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ElementAt$$ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.org$apache$spark$sql$catalyst$expressions$ElementAt$$mapKeyType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.org$apache$spark$sql$catalyst$expressions$ElementAt$$ordering;
        }
    }

    private DataType dataType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                DataType dataType2;
                DataType dataType3 = this.left().dataType();
                if (dataType3 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType2 = (ArrayType)dataType3;
                    dataType2 = elementType = arrayType2.elementType();
                } else {
                    DataType valueType;
                    if (!(dataType3 instanceof MapType)) {
                        throw new MatchError((Object)dataType3);
                    }
                    MapType mapType2 = (MapType)dataType3;
                    dataType2 = valueType = mapType2.valueType();
                }
                this.dataType = dataType2;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
            return this.dataType;
        }
    }

    private Function2 doElementAt$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                Object object;
                DataType dataType2 = this.left().dataType();
                if (dataType2 instanceof ArrayType) {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ElementAt $outer;

                        public final Object apply(Object value2, Object ordinal) {
                            Object object;
                            ArrayData array = (ArrayData)value2;
                            int index = BoxesRunTime.unboxToInt((Object)ordinal);
                            if (array.numElements() < package$.MODULE$.abs(index)) {
                                object = null;
                            } else {
                                if (index == 0) {
                                    throw new ArrayIndexOutOfBoundsException("SQL array indices start at 1");
                                }
                                int idx = index > 0 ? index - 1 : array.numElements() + index;
                                object = this.$outer.org$apache$spark$sql$catalyst$expressions$ElementAt$$arrayContainsNull() && array.isNullAt(idx) ? null : array.get(idx, this.$outer.dataType());
                            }
                            return object;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                } else {
                    if (!(dataType2 instanceof MapType)) {
                        throw new MatchError((Object)dataType2);
                    }
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ElementAt $outer;

                        public final Object apply(Object value2, Object ordinal) {
                            return this.$outer.getValueEval(value2, ordinal, this.$outer.org$apache$spark$sql$catalyst$expressions$ElementAt$$mapKeyType(), this.$outer.org$apache$spark$sql$catalyst$expressions$ElementAt$$ordering());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                }
                this.doElementAt = object;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
            return this.doElementAt;
        }
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public DataType org$apache$spark$sql$catalyst$expressions$ElementAt$$mapKeyType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.org$apache$spark$sql$catalyst$expressions$ElementAt$$mapKeyType$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ElementAt$$mapKeyType;
    }

    public boolean org$apache$spark$sql$catalyst$expressions$ElementAt$$arrayContainsNull() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.org$apache$spark$sql$catalyst$expressions$ElementAt$$arrayContainsNull$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ElementAt$$arrayContainsNull;
    }

    public Ordering<Object> org$apache$spark$sql$catalyst$expressions$ElementAt$$ordering() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.org$apache$spark$sql$catalyst$expressions$ElementAt$$ordering$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ElementAt$$ordering;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2;
        block8: {
            Seq seq;
            block6: {
                block7: {
                    Seq seq2;
                    block5: {
                        IntegralType integralType;
                        tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
                        if (tuple2 == null) break block5;
                        DataType arr = (DataType)tuple2._1();
                        DataType e2 = (DataType)tuple2._2();
                        if (!(arr instanceof ArrayType)) break block5;
                        ArrayType arrayType2 = (ArrayType)arr;
                        if (!(e2 instanceof IntegralType)) break block5;
                        IntegralType integralType2 = integralType = (IntegralType)e2;
                        LongType$ longType$ = LongType$.MODULE$;
                        if (!(integralType2 == null ? longType$ != null : !integralType2.equals(longType$))) break block5;
                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{arrayType2, IntegerType$.MODULE$}));
                        break block6;
                    }
                    if (tuple2 == null) break block7;
                    DataType dataType2 = (DataType)tuple2._1();
                    DataType e2 = (DataType)tuple2._2();
                    if (!(dataType2 instanceof MapType)) break block7;
                    MapType mapType2 = (MapType)dataType2;
                    DataType keyType = mapType2.keyType();
                    DataType valueType = mapType2.valueType();
                    boolean hasNull = mapType2.valueContainsNull();
                    Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)keyType, (Object)e2);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        DataType dt = (DataType)some.x();
                        seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{new MapType(dt, valueType, hasNull), dt}));
                    } else {
                        seq2 = (Seq)Seq$.MODULE$.empty();
                    }
                    seq = seq2;
                    break block6;
                }
                if (tuple2 == null) break block8;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType e1;
        void var4_8;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType e2 = (DataType)tuple2._2();
            if (tuple2._1() instanceof ArrayType) {
                DataType dataType2 = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType2 == null ? integerType$ != null : !dataType2.equals(integerType$)) {
                    TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input to function ", " should have "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"been ", " followed by a ", ", but it's "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ArrayType$.MODULE$.simpleString(), IntegerType$.MODULE$.simpleString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", ", ", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left().dataType().catalogString(), this.right().dataType().catalogString()}))).toString());
                    return var4_8;
                }
            }
        }
        if (tuple2 != null) {
            MapType mapType2;
            DataType e12;
            DataType dataType3 = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType3 instanceof MapType && !e2.sameType(e12 = (mapType2 = (MapType)dataType3).keyType())) {
                TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input to function ", " should have "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"been ", " followed by a value of same key type, but it's "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MapType$.MODULE$.simpleString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", ", ", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left().dataType().catalogString(), this.right().dataType().catalogString()}))).toString());
                return var4_8;
            }
        }
        if (tuple2 != null && !((e1 = (DataType)tuple2._1()) instanceof MapType) && !(e1 instanceof ArrayType)) {
            TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The first argument to function ", " should "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"have been ", " or ", " type, but its "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ArrayType$.MODULE$.simpleString(), MapType$.MODULE$.simpleString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left().dataType().catalogString()}))).toString());
            return var4_8;
        }
        TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
        return var4_8;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object value2, Object ordinal) {
        return this.doElementAt().apply(value2, ordinal);
    }

    private Function2<Object, Object, Object> doElementAt() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.doElementAt$lzycompute() : this.doElementAt;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType2;
        block4: {
            ExprCode exprCode;
            block3: {
                block2: {
                    dataType2 = this.left().dataType();
                    if (!(dataType2 instanceof ArrayType)) break block2;
                    exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ctx, ev){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ElementAt $outer;
                        private final CodegenContext ctx$12;
                        private final ExprCode ev$12;

                        public final String apply(String eval1, String eval2) {
                            String index = this.ctx$12.freshName("elementAtIndex");
                            String nullCheck = this.$outer.org$apache$spark$sql$catalyst$expressions$ElementAt$$arrayContainsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |if (", ".isNullAt(", ")) {\n               |  ", " = true;\n               |} else\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval1, index, this.ev$12.isNull()})))).stripMargin() : "";
                            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |int ", " = (int) ", ";\n             |if (", ".numElements() < Math.abs(", ")) {\n             |  ", " = true;\n             |} else {\n             |  if (", " == 0) {\n             |    throw new ArrayIndexOutOfBoundsException(\"SQL array indices start at 1\");\n             |  } else if (", " > 0) {\n             |    ", "--;\n             |  } else {\n             |    ", " += ", ".numElements();\n             |  }\n             |  ", "\n             |  {\n             |    ", " = ", ";\n             |  }\n             |}\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{index, eval2, eval1, index, this.ev$12.isNull(), index, index, index, index, eval1, nullCheck, this.ev$12.value(), CodeGenerator$.MODULE$.getValue(eval1, this.$outer.dataType(), index)})))).stripMargin();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.ctx$12 = ctx$12;
                            this.ev$12 = ev$12;
                        }
                    });
                    break block3;
                }
                if (!(dataType2 instanceof MapType)) break block4;
                exprCode = this.doGetValueGenCode(ctx, ev, (MapType)this.left().dataType());
            }
            return exprCode;
        }
        throw new MatchError((Object)dataType2);
    }

    @Override
    public String prettyName() {
        return "element_at";
    }

    public ElementAt copy(Expression left, Expression right) {
        return new ElementAt(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ElementAt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ElementAt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ElementAt)) return false;
        boolean bl = true;
        if (!bl) return false;
        ElementAt elementAt = (ElementAt)x$1;
        Expression expression = this.left();
        Expression expression2 = elementAt.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = elementAt.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!elementAt.canEqual(this)) return false;
        return true;
    }

    public ElementAt(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

