/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.sql.catalyst.expressions.RowBasedKeyValueBatch;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.KVIterator;
import org.apache.spark.unsafe.Platform;

public final class VariableLengthRowBasedKeyValueBatch
extends RowBasedKeyValueBatch {
    private final long[] keyOffsets;

    @Override
    public UnsafeRow appendRow(Object kbase, long koff, int klen, Object vbase, long voff, int vlen) {
        long offset;
        long recordLength = 8 + klen + vlen + 8;
        if (this.numRows >= this.capacity || this.page == null || this.page.size() - this.pageCursor < recordLength) {
            return null;
        }
        long recordOffset = offset = this.page.getBaseOffset() + this.pageCursor;
        Platform.putInt((Object)this.base, (long)offset, (int)(klen + vlen + 4));
        Platform.putInt((Object)this.base, (long)(offset + 4L), (int)klen);
        Platform.copyMemory((Object)kbase, (long)koff, (Object)this.base, (long)(offset += 8L), (long)klen);
        Platform.copyMemory((Object)vbase, (long)voff, (Object)this.base, (long)(offset += (long)klen), (long)vlen);
        Platform.putLong((Object)this.base, (long)(offset += (long)vlen), (long)0L);
        this.pageCursor += recordLength;
        this.keyOffsets[this.numRows] = recordOffset + 8L;
        this.keyRowId = this.numRows++;
        this.keyRow.pointTo(this.base, recordOffset + 8L, klen);
        this.valueRow.pointTo(this.base, recordOffset + 8L + (long)klen, vlen + 4);
        return this.valueRow;
    }

    @Override
    public UnsafeRow getKeyRow(int rowId) {
        assert (rowId >= 0);
        assert (rowId < this.numRows);
        if (this.keyRowId != rowId) {
            long offset = this.keyOffsets[rowId];
            int klen = Platform.getInt((Object)this.base, (long)(offset - 4L));
            this.keyRow.pointTo(this.base, offset, klen);
            this.keyRowId = rowId;
        }
        return this.keyRow;
    }

    @Override
    public UnsafeRow getValueFromKey(int rowId) {
        if (this.keyRowId != rowId) {
            this.getKeyRow(rowId);
        }
        assert (rowId >= 0);
        long offset = this.keyRow.getBaseOffset();
        int klen = this.keyRow.getSizeInBytes();
        int vlen = Platform.getInt((Object)this.base, (long)(offset - 8L)) - klen - 4;
        this.valueRow.pointTo(this.base, offset + (long)klen, vlen + 4);
        return this.valueRow;
    }

    @Override
    public KVIterator<UnsafeRow, UnsafeRow> rowIterator() {
        return new KVIterator<UnsafeRow, UnsafeRow>(){
            private final UnsafeRow key;
            private final UnsafeRow value;
            private long offsetInPage;
            private int recordsInPage;
            private int currentklen;
            private int currentvlen;
            private int totalLength;
            private boolean initialized;
            {
                this.key = new UnsafeRow(VariableLengthRowBasedKeyValueBatch.this.keySchema.length());
                this.value = new UnsafeRow(VariableLengthRowBasedKeyValueBatch.this.valueSchema.length());
                this.offsetInPage = 0L;
                this.recordsInPage = 0;
                this.initialized = false;
            }

            private void init() {
                if (VariableLengthRowBasedKeyValueBatch.this.page != null) {
                    this.offsetInPage = VariableLengthRowBasedKeyValueBatch.this.page.getBaseOffset();
                    this.recordsInPage = VariableLengthRowBasedKeyValueBatch.this.numRows;
                }
                this.initialized = true;
            }

            public boolean next() {
                if (!this.initialized) {
                    this.init();
                }
                if (this.recordsInPage == 0) {
                    this.freeCurrentPage();
                    return false;
                }
                this.totalLength = Platform.getInt((Object)VariableLengthRowBasedKeyValueBatch.this.base, (long)this.offsetInPage) - 4;
                this.currentklen = Platform.getInt((Object)VariableLengthRowBasedKeyValueBatch.this.base, (long)(this.offsetInPage + 4L));
                this.currentvlen = this.totalLength - this.currentklen;
                this.key.pointTo(VariableLengthRowBasedKeyValueBatch.this.base, this.offsetInPage + 8L, this.currentklen);
                this.value.pointTo(VariableLengthRowBasedKeyValueBatch.this.base, this.offsetInPage + 8L + (long)this.currentklen, this.currentvlen + 4);
                this.offsetInPage += (long)(8 + this.totalLength + 8);
                --this.recordsInPage;
                return true;
            }

            public UnsafeRow getKey() {
                return this.key;
            }

            public UnsafeRow getValue() {
                return this.value;
            }

            public void close() {
            }

            private void freeCurrentPage() {
                if (VariableLengthRowBasedKeyValueBatch.this.page != null) {
                    VariableLengthRowBasedKeyValueBatch.this.freePage(VariableLengthRowBasedKeyValueBatch.this.page);
                    VariableLengthRowBasedKeyValueBatch.this.page = null;
                }
            }
        };
    }

    protected VariableLengthRowBasedKeyValueBatch(StructType keySchema, StructType valueSchema, int maxRows2, TaskMemoryManager manager) {
        super(keySchema, valueSchema, maxRows2, manager);
        this.keyOffsets = new long[maxRows2];
    }
}

