/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryMathExpression;
import org.apache.spark.sql.catalyst.expressions.EulerNumber;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Logarithm$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(base, expr) - Returns the logarithm of `expr` with `base`.", extended="\n    Examples:\n      > SELECT _FUNC_(10, 100);\n       2.0\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001>\u0011\u0011\u0002T8hCJLG\u000f[7\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00155A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0015\u0005&t\u0017M]=NCRDW\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u000fA\u0013x\u000eZ;diB\u0011QcG\u0005\u00039Y\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\b\u0001\u0003\u0016\u0004%\taH\u0001\u0005Y\u00164G/F\u0001!!\t\t\u0012%\u0003\u0002#\u0005\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u0011\u0002!\u0011#Q\u0001\n\u0001\nQ\u0001\\3gi\u0002B\u0001B\n\u0001\u0003\u0016\u0004%\taH\u0001\u0006e&<\u0007\u000e\u001e\u0005\tQ\u0001\u0011\t\u0012)A\u0005A\u00051!/[4ii\u0002BQA\u000b\u0001\u0005\u0002-\na\u0001P5oSRtDc\u0001\u0017.]A\u0011\u0011\u0003\u0001\u0005\u0006=%\u0002\r\u0001\t\u0005\u0006M%\u0002\r\u0001\t\u0005\u0006U\u0001!\t\u0001\r\u000b\u0003YEBQAM\u0018A\u0002\u0001\nQa\u00195jY\u0012DQ\u0001\u000e\u0001\u0005BU\n\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002mA\u0011QcN\u0005\u0003qY\u0011qAQ8pY\u0016\fg\u000eC\u0003;\u0001\u0011E3(\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002=\u007f\u0005\u0003\"!F\u001f\n\u0005y2\"aA!os\")\u0001)\u000fa\u0001y\u00051\u0011N\u001c9viFBQAQ\u001dA\u0002q\na!\u001b8qkR\u0014\u0004\"\u0002#\u0001\t\u0003*\u0015!\u00033p\u000f\u0016t7i\u001c3f)\r1E*\u0015\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\n\tqaY8eK\u001e,g.\u0003\u0002L\u0011\nAQ\t\u001f9s\u0007>$W\rC\u0003N\u0007\u0002\u0007a*A\u0002dib\u0004\"aR(\n\u0005AC%AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006%\u000e\u0003\rAR\u0001\u0003KZDq\u0001\u0016\u0001\u0002\u0002\u0013\u0005Q+\u0001\u0003d_BLHc\u0001\u0017W/\"9ad\u0015I\u0001\u0002\u0004\u0001\u0003b\u0002\u0014T!\u0003\u0005\r\u0001\t\u0005\b3\u0002\t\n\u0011\"\u0001[\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a\u0017\u0016\u0003Aq[\u0013!\u0018\t\u0003=\u000el\u0011a\u0018\u0006\u0003A\u0006\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\t4\u0012AC1o]>$\u0018\r^5p]&\u0011Am\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007b\u00024\u0001#\u0003%\tAW\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011\u001dA\u0007!!A\u0005B%\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u00016\u0011\u0005-\u0004X\"\u00017\u000b\u00055t\u0017\u0001\u00027b]\u001eT\u0011a\\\u0001\u0005U\u00064\u0018-\u0003\u0002rY\n11\u000b\u001e:j]\u001eDqa\u001d\u0001\u0002\u0002\u0013\u0005A/\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001v!\t)b/\u0003\u0002x-\t\u0019\u0011J\u001c;\t\u000fe\u0004\u0011\u0011!C\u0001u\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HC\u0001\u001f|\u0011\u001da\b0!AA\u0002U\f1\u0001\u001f\u00132\u0011\u001dq\b!!A\u0005B}\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0003\u0001R!a\u0001\u0002\nqj!!!\u0002\u000b\u0007\u0005\u001da#\u0001\u0006d_2dWm\u0019;j_:LA!a\u0003\u0002\u0006\tA\u0011\n^3sCR|'\u000fC\u0005\u0002\u0010\u0001\t\t\u0011\"\u0001\u0002\u0012\u0005A1-\u00198FcV\fG\u000eF\u00027\u0003'A\u0001\u0002`A\u0007\u0003\u0003\u0005\r\u0001\u0010\u0005\n\u0003/\u0001\u0011\u0011!C!\u00033\ta!Z9vC2\u001cHc\u0001\u001c\u0002\u001c!AA0!\u0006\u0002\u0002\u0003\u0007A\bK\u0006\u0001\u0003?\t)#a\n\u0002,\u00055\u0002cA\t\u0002\"%\u0019\u00111\u0005\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011F\u0001B?\u001a+fjQ0)E\u0006\u001cX\r\f\u0011fqB\u0014\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t7pO\u0006\u0014\u0018\u000e\u001e5nA=4\u0007\u0005Y3yaJ\u0004\u0007e^5uQ\u0002\u0002'-Y:fA:\n\u0001\"\u001a=uK:$W\rZ\u0011\u0003\u0003_\tAH\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152a1\u0002\u0013\u0007\r\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012d\u0006\r\u0006!A\u001dI\u00111\u0007\u0002\u0002\u0002#\u0005\u0011QG\u0001\n\u0019><\u0017M]5uQ6\u00042!EA\u001c\r!\t!!!A\t\u0002\u0005e2#BA\u001c\u0003wQ\u0002cBA\u001f\u0003\u0007\u0002\u0003\u0005L\u0007\u0003\u0003\u007fQ1!!\u0011\u0017\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\u0012\u0002@\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000f)\n9\u0004\"\u0001\u0002JQ\u0011\u0011Q\u0007\u0005\u000b\u0003\u001b\n9$!A\u0005F\u0005=\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003)D!\"a\u0015\u00028\u0005\u0005I\u0011QA+\u0003\u0015\t\u0007\u000f\u001d7z)\u0015a\u0013qKA-\u0011\u0019q\u0012\u0011\u000ba\u0001A!1a%!\u0015A\u0002\u0001B!\"!\u0018\u00028\u0005\u0005I\u0011QA0\u0003\u001d)h.\u00199qYf$B!!\u0019\u0002nA)Q#a\u0019\u0002h%\u0019\u0011Q\r\f\u0003\r=\u0003H/[8o!\u0015)\u0012\u0011\u000e\u0011!\u0013\r\tYG\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005=\u00141LA\u0001\u0002\u0004a\u0013a\u0001=%a!Q\u00111OA\u001c\u0003\u0003%I!!\u001e\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003o\u00022a[A=\u0013\r\tY\b\u001c\u0002\u0007\u001f\nTWm\u0019;")
public class Logarithm
extends BinaryMathExpression {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Logarithm logarithm) {
        return Logarithm$.MODULE$.unapply(logarithm);
    }

    public static Function1<Tuple2<Expression, Expression>, Logarithm> tupled() {
        return Logarithm$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Logarithm>> curried() {
        return Logarithm$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        double dLeft = BoxesRunTime.unboxToDouble((Object)input1);
        double dRight = BoxesRunTime.unboxToDouble((Object)input2);
        return dLeft <= 0.0 || dRight <= 0.0 ? null : BoxesRunTime.boxToDouble((double)(package$.MODULE$.log(dRight) / package$.MODULE$.log(dLeft)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.left() instanceof EulerNumber ? this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ev){
            public static final long serialVersionUID = 0L;
            private final ExprCode ev$7;

            public final String apply(String c1, String c2) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          if (", " <= 0.0) {\n            ", " = true;\n          } else {\n            ", " = java.lang.Math.log(", ");\n          }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c2, this.ev$7.isNull(), this.ev$7.value(), c2}));
            }
            {
                this.ev$7 = ev$7;
            }
        }) : this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ev){
            public static final long serialVersionUID = 0L;
            private final ExprCode ev$7;

            public final String apply(String c1, String c2) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          if (", " <= 0.0 || ", " <= 0.0) {\n            ", " = true;\n          } else {\n            ", " = java.lang.Math.log(", ") / java.lang.Math.log(", ");\n          }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c1, c2, this.ev$7.isNull(), this.ev$7.value(), c2, c1}));
            }
            {
                this.ev$7 = ev$7;
            }
        });
    }

    public Logarithm copy(Expression left, Expression right) {
        return new Logarithm(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Logarithm";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Logarithm;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Logarithm)) return false;
        boolean bl = true;
        if (!bl) return false;
        Logarithm logarithm = (Logarithm)x$1;
        Expression expression = this.left();
        Expression expression2 = logarithm.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = logarithm.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!logarithm.canEqual(this)) return false;
        return true;
    }

    public Logarithm(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        super((Function2<Object, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double c1, double c2) {
                return this.apply$mcDDD$sp(c1, c2);
            }

            public double apply$mcDDD$sp(double c1, double c2) {
                return package$.MODULE$.log(c2) / package$.MODULE$.log(c1);
            }
        }, "LOG");
    }

    public Logarithm(Expression child) {
        this(new EulerNumber(), child);
    }
}

