/*
 * Decompiled with CFR 0.152.
 */
package npanday.registry.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import npanday.registry.NPandayRepositoryException;
import npanday.registry.Repository;
import npanday.registry.RepositoryLoader;
import npanday.registry.RepositoryRegistry;

public class StandardRepositoryLoader
implements RepositoryLoader {
    private RepositoryRegistry repositoryRegistry;

    public Repository loadRepository(String fileUri, String repositoryClass, Hashtable initParams) throws IOException, NPandayRepositoryException {
        Repository repository;
        boolean optional;
        InputStream stream;
        Hashtable props;
        if (this.repositoryRegistry == null) {
            throw new IOException("NPANDAY-084-000: The repository registry has not been set.");
        }
        Hashtable hashtable = props = initParams != null ? initParams : new Hashtable();
        if (fileUri == null || fileUri.trim().equals("")) {
            throw new IOException("NPANDAY-084-001: File uri must be provided.");
        }
        if (repositoryClass == null || repositoryClass.trim().equals("")) {
            throw new IOException("NPANDAY-084-002: Repository class name must be provided: File Name = " + fileUri + ", Properties = " + props.toString());
        }
        try {
            stream = new FileInputStream(fileUri);
        }
        catch (IOException e) {
            stream = this.getClass().getResourceAsStream(fileUri);
        }
        String message = "File Name = " + fileUri + ", Repository Class = " + repositoryClass + ", Properties = " + props.toString();
        boolean bl = optional = initParams.containsKey("optional") && ((String)initParams.get("optional")).equalsIgnoreCase("true");
        if (stream == null && !optional) {
            throw new IOException("NPANDAY-084-003: Unable to loadRegistry config file: " + message);
        }
        if (stream == null && optional) {
            return null;
        }
        try {
            Class<?> c = Class.forName(repositoryClass);
            repository = (Repository)c.newInstance();
            repository.setRepositoryRegistry(this.repositoryRegistry);
            repository.load(stream, props);
            repository.setSourceUri(fileUri);
        }
        catch (NPandayRepositoryException e) {
            throw new NPandayRepositoryException("NPANDAY-084-004: " + e.toString() + " : " + message, e);
        }
        catch (Exception e) {
            throw new NPandayRepositoryException("NPANDAY-084-005: " + e.toString() + " : " + message, e);
        }
        catch (Error e) {
            throw new NPandayRepositoryException("NPANDAY-084-006: " + e.toString() + " : " + message, e);
        }
        return repository;
    }

    public String getLoaderName() {
        return this.getClass().getName();
    }

    public void setRepositoryRegistry(RepositoryRegistry repositoryRegistry) {
        this.repositoryRegistry = repositoryRegistry;
    }
}

