/*
 * Decompiled with CFR 0.152.
 */
package npanday.registry.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import npanday.registry.NPandayRepositoryException;
import npanday.registry.RegistryLoader;
import npanday.registry.Repository;
import npanday.registry.RepositoryLoader;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class StandardRegistryLoader
implements RegistryLoader {
    private List repositories = new ArrayList();
    private Hashtable repoMap = new Hashtable();
    private RepositoryLoader repositoryLoader;

    public void setRepositoryLoader(RepositoryLoader repositoryLoader) {
        this.repositoryLoader = repositoryLoader;
    }

    public final void loadRegistry(InputStream inputStream) throws IOException, NPandayRepositoryException {
        KXmlParser parser = new KXmlParser();
        try {
            parser.setInput(inputStream, null);
        }
        catch (XmlPullParserException e) {
            throw new IOException(e.toString());
        }
        try {
            parser.nextTag();
            parser.require(2, null, "registry-config");
            parser.nextTag();
            parser.require(2, null, "repositories");
            while (parser.nextTag() == 2) {
                parser.require(2, null, "repository");
                RepositoryObject rep = this.getRepositoryObject(parser);
                this.repositories.add(rep);
            }
        }
        catch (XmlPullParserException e) {
            throw new IOException("NPANDAY-083-000: Message = " + e.toString());
        }
        this.loadIntoRegistry();
    }

    public final Hashtable getRepositories() {
        return this.repoMap;
    }

    private String toPath(String fileName) {
        byte[] path = fileName.getBytes();
        int length = path.length;
        StringBuffer env = new StringBuffer();
        StringBuffer filePath = new StringBuffer();
        int i = 0;
        while (i < length) {
            if (i >= length - 2) {
                filePath.append((char)path[i++]);
                continue;
            }
            if (path[i] == 36) {
                if (path[++i] == 123) {
                    ++i;
                    while (i < length - 1 && path[i] != 125) {
                        env.append((char)path[i++]);
                    }
                    if (path[i] == 125) {
                        ++i;
                    }
                } else {
                    --i;
                    --i;
                }
                String pathEnv = System.getProperty(env.toString().trim(), ".");
                filePath.append(pathEnv.toString());
                continue;
            }
            filePath.append((char)path[i++]);
        }
        String str = filePath.toString();
        if (!str.startsWith("/")) {
            str = str.replaceAll("/", "\\\\");
            str = str.replaceAll("\\\\:", ":");
            str = str.replaceAll("\\\\\\\\", "\\\\");
        }
        return str;
    }

    private void loadIntoRegistry() throws IOException, NPandayRepositoryException {
        if (this.repositoryLoader == null) {
            throw new IOException("NPANDAY-083-001:: Repository Loader does not exist");
        }
        for (RepositoryObject repositoryObject : this.repositories) {
            String repositoryName = repositoryObject.getRepositoryName();
            String className = repositoryObject.getRepositoryClass();
            String fileName = repositoryObject.getRepositoryConfig();
            Repository repository = this.repositoryLoader.loadRepository(this.toPath(fileName), className, repositoryObject.getInitParams());
            if (repository == null) continue;
            this.repoMap.put(repositoryName, repository);
        }
    }

    private RepositoryObject getRepositoryObject(KXmlParser parser) throws IOException, XmlPullParserException {
        RepositoryObject repositoryObject = new RepositoryObject();
        Hashtable<String, String> initParams = new Hashtable<String, String>();
        int i = 0;
        while (parser.nextTag() == 2) {
            switch (i) {
                case 0: {
                    parser.require(2, null, "repository-name");
                    repositoryObject.setRepositoryName(parser.nextText());
                    break;
                }
                case 1: {
                    parser.require(2, null, "repository-class");
                    repositoryObject.setRepositoryClass(parser.nextText());
                    break;
                }
                case 2: {
                    parser.require(2, null, "repository-config");
                    repositoryObject.setRepositoryConfig(parser.nextText());
                    break;
                }
                default: {
                    parser.require(2, null, "init-param");
                    String paramName = null;
                    String paramValue = null;
                    int j = 0;
                    while (parser.nextTag() == 2) {
                        switch (j) {
                            case 0: {
                                parser.require(2, null, "param-name");
                                paramName = parser.nextText();
                                break;
                            }
                            case 1: {
                                parser.require(2, null, "param-value");
                                paramValue = parser.nextText();
                                break;
                            }
                            default: {
                                throw new IOException();
                            }
                        }
                        ++j;
                    }
                    if (paramName == null || paramValue == null) break;
                    initParams.put(paramName, paramValue);
                }
            }
            repositoryObject.setInitParams(initParams);
            ++i;
        }
        return repositoryObject;
    }

    private class RepositoryObject {
        private String repositoryName;
        private String repositoryClass;
        private String repositoryConfig;
        private Hashtable initParams;

        RepositoryObject() {
        }

        RepositoryObject(String repositoryName, String repositoryClass, String repositoryConfig) {
            this.repositoryName = repositoryName;
            this.repositoryClass = repositoryClass;
            this.repositoryConfig = repositoryConfig;
        }

        String getRepositoryName() {
            return this.repositoryName;
        }

        void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        String getRepositoryClass() {
            return this.repositoryClass;
        }

        void setRepositoryClass(String repositoryClass) {
            this.repositoryClass = repositoryClass;
        }

        String getRepositoryConfig() {
            return this.repositoryConfig;
        }

        void setRepositoryConfig(String repositoryConfig) {
            this.repositoryConfig = repositoryConfig;
        }

        Hashtable getInitParams() {
            return this.initParams;
        }

        void setInitParams(Hashtable initParams) {
            this.initParams = initParams;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RepositoryObject)) {
                return false;
            }
            RepositoryObject repositoryObject = (RepositoryObject)o;
            if (!this.repositoryClass.equals(repositoryObject.repositoryClass)) {
                return false;
            }
            if (!this.repositoryConfig.equals(repositoryObject.repositoryConfig)) {
                return false;
            }
            return this.repositoryName.equals(repositoryObject.repositoryName);
        }

        public int hashCode() {
            int result = this.repositoryName.hashCode();
            result = 29 * result + this.repositoryClass.hashCode();
            result = 29 * result + this.repositoryConfig.hashCode();
            return result;
        }

        public String toString() {
            return "Name = " + this.repositoryName + ", Class = " + this.repositoryClass + ", Config = " + this.repositoryConfig;
        }
    }
}

