/*
 * Decompiled with CFR 0.152.
 */
package npanday.registry.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import npanday.registry.NPandayRepositoryException;
import npanday.registry.RegistryLoader;
import npanday.registry.Repository;
import npanday.registry.RepositoryLoader;
import npanday.registry.RepositoryRegistry;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class RepositoryRegistryImpl
implements RepositoryRegistry,
Initializable {
    private Hashtable repositories = new Hashtable();
    private RepositoryLoader repositoryLoader;
    private RegistryLoader registryLoader;

    public void initialize() throws InitializationException {
        try {
            this.loadFromResource("/META-INF/npanday/registry-config.xml", this.getClass());
        }
        catch (IOException e) {
            throw new InitializationException("NPANDAY-082-000: Message = ", (Throwable)e);
        }
        catch (NPandayRepositoryException e) {
            throw new InitializationException("NPANDAY-082-010: Message = ", (Throwable)e);
        }
    }

    public boolean isEmpty() {
        return this.repositories.isEmpty();
    }

    public synchronized void setRepositoryLoader(RepositoryLoader loader) {
        this.repositoryLoader = loader;
    }

    public synchronized void setRegistryLoader(RegistryLoader loader) {
        this.registryLoader = loader;
    }

    public synchronized void loadFromInputStream(InputStream inputStream) throws IOException, NPandayRepositoryException {
        if (this.repositoryLoader == null || this.registryLoader == null) {
            Class<?> c;
            String message;
            String loaderClassName;
            InputStream stream = RepositoryRegistry.class.getResourceAsStream("/registry.properties");
            if (stream == null) {
                throw new IOException("NPANDAY-082-001: Could not find /registry.properties file with the jar");
            }
            Properties prop = new Properties();
            prop.load(stream);
            if (this.repositoryLoader == null) {
                loaderClassName = prop.getProperty("repositoryLoader");
                if (loaderClassName == null) {
                    throw new IOException("NPANDAY-082-002: Missing the repositoryLoader from the /registry.properties");
                }
                message = "Repository Loader = " + loaderClassName;
                try {
                    c = Class.forName(loaderClassName);
                    this.repositoryLoader = (RepositoryLoader)c.newInstance();
                }
                catch (Exception e) {
                    throw new NPandayRepositoryException("NPANDAY-082-003: Unable to load repository: " + message, e);
                }
                catch (Error e) {
                    throw new NPandayRepositoryException("NPANDAY-082-004: Unable to load repository: " + message, e);
                }
            }
            if (this.registryLoader == null) {
                loaderClassName = prop.getProperty("registryLoader");
                if (loaderClassName == null) {
                    throw new IOException("NPANDAY-082-005: Missing the registryLoader from the /registry.properties");
                }
                message = "Registry Loader = " + loaderClassName;
                try {
                    c = Class.forName(loaderClassName);
                    this.registryLoader = (RegistryLoader)c.newInstance();
                }
                catch (Exception e) {
                    throw new NPandayRepositoryException("NPANDAY-082-006: Unable to load registry: " + message, e);
                }
                catch (Error e) {
                    throw new NPandayRepositoryException("NPANDAY-082-007: Unable to load registry: " + message, e);
                }
            }
        }
        this.repositoryLoader.setRepositoryRegistry(this);
        this.registryLoader.setRepositoryLoader(this.repositoryLoader);
        this.registryLoader.loadRegistry(inputStream);
        this.repositories.putAll(this.registryLoader.getRepositories());
    }

    public synchronized void loadFromFile(String fileName) throws IOException, NPandayRepositoryException {
        FileInputStream fis = new FileInputStream(fileName);
        this.loadFromInputStream(fis);
    }

    public synchronized void loadFromResource(String fileName, Class sourceClass) throws IOException, NPandayRepositoryException {
        if (sourceClass == null) {
            throw new IOException("NPANDAY-082-008: The class cannot be null when loading from a resource");
        }
        InputStream stream = sourceClass.getResourceAsStream(fileName);
        if (stream == null) {
            throw new IOException("NPANDAY-082-009: Could not locate resource: File Name = " + fileName);
        }
        this.loadFromInputStream(stream);
    }

    public synchronized void addRepository(String name, Repository repository) {
        this.repositories.put(name, repository);
    }

    public synchronized Repository find(String name) {
        return (Repository)this.repositories.get(name);
    }

    public synchronized void removeRepository(String name) {
        this.repositories.remove(name);
    }

    public synchronized Set getRepositoryNames() {
        return Collections.unmodifiableSet(this.repositories.keySet());
    }

    public synchronized void empty() {
        this.repositories.clear();
    }
}

