/*
 * Decompiled with CFR 0.152.
 */
package npanday.registry.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import npanday.registry.ConnectionsRepository;
import npanday.registry.DataAccessObject;
import npanday.registry.DataAccessObjectRegistry;
import npanday.registry.NPandayRepositoryException;
import npanday.registry.Repository;
import npanday.registry.RepositoryRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAccessObjectRegistryImpl
implements DataAccessObjectRegistry {
    private RepositoryRegistry repositoryRegistry;
    private static Logger logger = Logger.getAnonymousLogger();
    private boolean isConnectionsRepoLoaded = false;

    @Override
    public Set<DataAccessObject> findAll() {
        HashSet<DataAccessObject> daos = new HashSet<DataAccessObject>();
        if (this.repositoryRegistry == null) {
            logger.warning("NPANDAY-081-000: Repository registry has not been set");
            return Collections.unmodifiableSet(daos);
        }
        for (String name : this.repositoryRegistry.getRepositoryNames()) {
            Repository repository = this.repositoryRegistry.find(name);
            if (!(repository instanceof ConnectionsRepository)) continue;
            ConnectionsRepository connectionsRepository = (ConnectionsRepository)repository;
            if (!this.isConnectionsRepoLoaded) {
                try {
                    connectionsRepository.lazyLoad();
                    this.isConnectionsRepoLoaded = true;
                }
                catch (NPandayRepositoryException e) {
                    logger.warning("NPANDAY-081-003: " + e.getMessage());
                    return daos;
                }
            }
            daos.addAll(((ConnectionsRepository)repository).getDataAccessObjects());
        }
        return Collections.unmodifiableSet(daos);
    }

    @Override
    public DataAccessObject find(String daoId) {
        if (this.repositoryRegistry == null) {
            logger.warning("NPANDAY-081-001: Repository registry has not been set");
            return null;
        }
        for (String name : this.repositoryRegistry.getRepositoryNames()) {
            Repository repository = this.repositoryRegistry.find(name);
            if (!(repository instanceof ConnectionsRepository)) continue;
            ConnectionsRepository connectionsRepository = (ConnectionsRepository)repository;
            if (!this.isConnectionsRepoLoaded) {
                try {
                    connectionsRepository.lazyLoad();
                    this.isConnectionsRepoLoaded = true;
                }
                catch (NPandayRepositoryException e) {
                    logger.warning("NPANDAY-081-004: " + e.getMessage());
                    return null;
                }
            }
            for (DataAccessObject dao : connectionsRepository.getDataAccessObjects()) {
                if (!dao.getID().trim().equals(daoId)) continue;
                return dao;
            }
        }
        return null;
    }

    @Override
    public Set<String> getDaoIds() {
        HashSet<String> daoIds = new HashSet<String>();
        if (this.repositoryRegistry == null) {
            logger.warning("NPANDAY-081-002: Repository registry has not been set");
            return Collections.unmodifiableSet(daoIds);
        }
        for (String name : this.repositoryRegistry.getRepositoryNames()) {
            Repository repository = this.repositoryRegistry.find(name);
            if (!(repository instanceof ConnectionsRepository)) continue;
            ConnectionsRepository connectionsRepository = (ConnectionsRepository)repository;
            if (!this.isConnectionsRepoLoaded) {
                try {
                    connectionsRepository.lazyLoad();
                    this.isConnectionsRepoLoaded = true;
                }
                catch (NPandayRepositoryException e) {
                    logger.warning("NPANDAY-081-005: " + e.getMessage());
                    return Collections.unmodifiableSet(daoIds);
                }
            }
            for (DataAccessObject dao : ((ConnectionsRepository)repository).getDataAccessObjects()) {
                daoIds.add(dao.getID());
            }
        }
        return Collections.unmodifiableSet(daoIds);
    }
}

