/*
 * Decompiled with CFR 0.152.
 */
package npanday.registry;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Logger;
import npanday.registry.DataAccessObject;
import npanday.registry.NPandayRepositoryException;
import npanday.registry.Repository;
import npanday.registry.RepositoryRegistry;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionsRepository
implements Repository {
    private static Logger logger = Logger.getAnonymousLogger();
    private RepositoryRegistry registry;
    private Set<DataAccessObject> daos = new HashSet<DataAccessObject>();
    private Hashtable properties;
    private ArtifactFactory artifactFactory;

    public void lazyLoad() throws NPandayRepositoryException {
        long start = System.currentTimeMillis();
        File dataDir = new File(System.getProperty("user.home"), ".m2/repository");
        MemoryStore store = new MemoryStore(dataDir);
        store.setPersist(true);
        store.setSyncDelay(0L);
        SailRepository rdfRepository = new SailRepository((Sail)store);
        try {
            rdfRepository.initialize();
        }
        catch (RepositoryException e) {
            throw new NPandayRepositoryException("NPANDAY-080-005: Failed to initialized repository. Message = " + e.getMessage(), e);
        }
        Set keys = this.properties.keySet();
        for (String keyName : keys) {
            if (!keyName.trim().startsWith("dao:")) continue;
            String daoClassName = (String)this.properties.get(keyName);
            try {
                Class<?> c = Class.forName(daoClassName);
                Object o = c.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(o instanceof DataAccessObject)) {
                    throw new NPandayRepositoryException("NPANDAY-080-000: dao tag references a class that does not implement the DataAccessObject interface.");
                }
                DataAccessObject dao = (DataAccessObject)o;
                dao.init(rdfRepository, keyName, daoClassName);
                dao.setRepositoryRegistry(this.registry);
                this.daos.add(dao);
                logger.finest("NPANDAY-080-001: Adding data access object: Class Name = " + daoClassName);
            }
            catch (Exception e) {
                throw new NPandayRepositoryException("NPANDAY-080-002: Problem instantiating the DAO Class: Class Name = " + daoClassName, e);
            }
            catch (Error e) {
                throw new NPandayRepositoryException("NPANDAY-080-003: Problem instantiating the DAO Class: Class Name = " + daoClassName, e);
            }
        }
        logger.finest("NPANDAY-080-004: Connection Start Up: Time = " + (System.currentTimeMillis() - start));
    }

    @Override
    public void load(InputStream inputStream, Hashtable properties) throws NPandayRepositoryException {
        this.properties = properties;
    }

    @Override
    public void setRepositoryRegistry(RepositoryRegistry repositoryRegistry) {
        this.registry = repositoryRegistry;
    }

    @Override
    public void setSourceUri(String fileUri) {
    }

    @Override
    public void reload() {
    }

    public Set<DataAccessObject> getDataAccessObjects() {
        return Collections.unmodifiableSet(this.daos);
    }
}

