/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev.command.update;

import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.accurev.AccuRev;
import org.apache.maven.scm.provider.accurev.AccuRevException;
import org.apache.maven.scm.provider.accurev.AccuRevInfo;
import org.apache.maven.scm.provider.accurev.AccuRevScmProviderRepository;
import org.apache.maven.scm.provider.accurev.AccuRevVersion;
import org.apache.maven.scm.provider.accurev.command.AbstractAccuRevCommand;
import org.apache.maven.scm.provider.accurev.command.update.AccuRevUpdateScmResult;

public class AccuRevUpdateCommand
extends AbstractAccuRevCommand {
    public AccuRevUpdateCommand(ScmLogger logger) {
        super(logger);
    }

    @Override
    protected ScmResult executeAccurevCommand(AccuRevScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException, AccuRevException {
        File basedir;
        AccuRev accuRev = repository.getAccuRev();
        AccuRevInfo info = accuRev.info(basedir = fileSet.getBasedir());
        if (!info.isWorkSpace()) {
            throw new AccuRevException("No workspace at " + basedir.getAbsolutePath());
        }
        String startRevision = this.getStartRevision(repository, parameters, info);
        ScmVersion scmVersion = parameters.getScmVersion(CommandParameter.SCM_VERSION, null);
        String updateTransactionId = null;
        if (scmVersion != null) {
            AccuRevVersion updateVersion = repository.getAccuRevVersion(scmVersion);
            String newBasisStream = updateVersion.getBasisStream();
            if (newBasisStream != null && !newBasisStream.equals(info.getWorkSpace()) && !newBasisStream.equals(info.getBasis())) {
                this.getLogger().info("Reparenting " + info.getWorkSpace() + " to " + newBasisStream);
                accuRev.chws(basedir, info.getWorkSpace(), newBasisStream);
            }
            if (!updateVersion.isNow()) {
                updateTransactionId = updateVersion.getTimeSpec();
            }
        }
        if (updateTransactionId == null) {
            updateTransactionId = repository.getDepotTransactionId(info.getWorkSpace(), "now");
        }
        String endRevision = repository.getRevision(info.getWorkSpace(), updateTransactionId);
        List<File> updatedFiles = accuRev.update(basedir, updateTransactionId);
        if (updatedFiles != null) {
            return new AccuRevUpdateScmResult(accuRev.getCommandLines(), AccuRevUpdateCommand.getScmFiles(updatedFiles, ScmFileStatus.UPDATED), startRevision, endRevision);
        }
        return new AccuRevUpdateScmResult(accuRev.getCommandLines(), "AccuRev error", accuRev.getErrorOutput(), null, null, false);
    }

    private String getStartRevision(AccuRevScmProviderRepository repository, CommandParameters parameters, AccuRevInfo info) throws ScmException, AccuRevException {
        boolean runChangeLog = parameters.getBoolean(CommandParameter.RUN_CHANGELOG_WITH_UPDATE);
        Date startDate = parameters.getDate(CommandParameter.START_DATE, null);
        String workspace = info.getWorkSpace();
        if (!runChangeLog) {
            return null;
        }
        return startDate == null ? repository.getWorkSpaceRevision(workspace) : repository.getRevision(workspace, startDate);
    }

    public UpdateScmResult update(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (UpdateScmResult)this.execute(repository, fileSet, parameters);
    }
}

