/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.surefire.SurefireBooter;

public class SurefirePlugin
extends AbstractMojo {
    private boolean skip;
    private boolean testFailureIgnore;
    private File basedir;
    private File classesDirectory;
    private File testClassesDirectory;
    private List classpathElements;
    private String reportsDirectory;
    private String test;
    private List includes;
    private List excludes;
    private ArtifactRepository localRepository;
    private Properties systemProperties;
    private List pluginArtifacts;
    private boolean printSummary;
    private String reportFormat;
    private boolean useFile;
    private String forkMode;
    private String jvm;
    private String argLine;
    private boolean childDelegation;

    public void execute() throws MojoExecutionException {
        boolean success;
        if (this.skip) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return;
        }
        if (!this.testClassesDirectory.exists()) {
            this.getLog().info((CharSequence)"No tests to run.");
            return;
        }
        SurefireBooter surefireBooter = new SurefireBooter();
        surefireBooter.setForkMode(this.forkMode);
        if (!this.forkMode.equals("none")) {
            surefireBooter.setSystemProperties(this.systemProperties);
            surefireBooter.setJvm(this.jvm);
            surefireBooter.setBasedir(this.basedir.getAbsolutePath());
            surefireBooter.setArgLine(this.argLine);
            surefireBooter.setChildDelegation(this.childDelegation);
            if (this.getLog().isDebugEnabled()) {
                surefireBooter.setDebug(true);
            }
        }
        this.getLog().info((CharSequence)("Setting reports dir: " + this.reportsDirectory));
        surefireBooter.setReportsDirectory(this.reportsDirectory);
        if (this.test != null) {
            ArrayList<String> includes = new ArrayList<String>();
            ArrayList excludes = new ArrayList();
            String[] testRegexes = this.split(this.test, ",", -1);
            for (int i = 0; i < testRegexes.length; ++i) {
                includes.add("**/" + testRegexes[i] + ".java");
            }
            surefireBooter.addBattery("org.apache.maven.surefire.battery.DirectoryBattery", new Object[]{this.testClassesDirectory, includes, excludes});
        } else {
            if (this.includes == null || this.includes.size() == 0) {
                this.includes = new ArrayList<String>(Arrays.asList("**/Test*.java", "**/*Test.java", "**/*TestCase.java"));
            }
            if (this.excludes == null || this.excludes.size() == 0) {
                this.excludes = new ArrayList<String>(Arrays.asList("**/Abstract*Test.java", "**/Abstract*TestCase.java"));
            }
            surefireBooter.addBattery("org.apache.maven.surefire.battery.DirectoryBattery", new Object[]{this.testClassesDirectory, this.includes, this.excludes});
        }
        System.setProperty("basedir", this.basedir.getAbsolutePath());
        System.setProperty("localRepository", this.localRepository.getBasedir());
        if (this.systemProperties != null) {
            Enumeration<?> propertyKeys = this.systemProperties.propertyNames();
            while (propertyKeys.hasMoreElements()) {
                String key = (String)propertyKeys.nextElement();
                System.setProperty(key, this.systemProperties.getProperty(key));
                this.getLog().debug((CharSequence)("Setting system property [" + key + "]=[" + this.systemProperties.getProperty(key) + "]"));
            }
        }
        this.getLog().debug((CharSequence)"Test Classpath :");
        this.getLog().debug((CharSequence)this.testClassesDirectory.getPath());
        surefireBooter.addClassPathUrl(this.testClassesDirectory.getPath());
        this.getLog().debug((CharSequence)this.classesDirectory.getPath());
        surefireBooter.addClassPathUrl(this.classesDirectory.getPath());
        Iterator i = this.classpathElements.iterator();
        while (i.hasNext()) {
            String classpathElement = (String)i.next();
            this.getLog().debug((CharSequence)classpathElement);
            surefireBooter.addClassPathUrl(classpathElement);
        }
        i = this.pluginArtifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            if (!"junit".equals(artifact.getArtifactId()) && !"surefire".equals(artifact.getArtifactId()) && !"surefire-booter".equals(artifact.getArtifactId()) && !"plexus-utils".equals(artifact.getArtifactId())) continue;
            this.getLog().debug((CharSequence)("Adding to surefire test classpath: " + artifact.getFile().getAbsolutePath()));
            surefireBooter.addClassPathUrl(artifact.getFile().getAbsolutePath());
        }
        this.addReporters(surefireBooter);
        try {
            success = surefireBooter.run();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing surefire", e);
        }
        if (!success) {
            String msg = "There are some test failure.";
            if (this.testFailureIgnore) {
                this.getLog().error((CharSequence)msg);
            } else {
                throw new MojoExecutionException(msg);
            }
        }
    }

    protected String[] split(String str, String separator, int max) {
        StringTokenizer tok = separator == null ? new StringTokenizer(str) : new StringTokenizer(str, separator);
        int listSize = tok.countTokens();
        if (max > 0 && listSize > max) {
            listSize = max;
        }
        String[] list = new String[listSize];
        int i = 0;
        int lastTokenEnd = 0;
        while (tok.hasMoreTokens()) {
            int lastTokenBegin;
            if (max > 0 && i == listSize - 1) {
                String endToken = tok.nextToken();
                lastTokenBegin = str.indexOf(endToken, lastTokenEnd);
                list[i] = str.substring(lastTokenBegin);
                break;
            }
            list[i] = tok.nextToken();
            lastTokenBegin = str.indexOf(list[i], lastTokenEnd);
            lastTokenEnd = lastTokenBegin + list[i].length();
            ++i;
        }
        return list;
    }

    private void addReporters(SurefireBooter surefireBooter) {
        if (this.useFile) {
            if (this.printSummary) {
                surefireBooter.addReport("org.apache.maven.surefire.report.ConsoleReporter");
            } else {
                surefireBooter.addReport("org.apache.maven.surefire.report.SummaryConsoleReporter");
            }
            if (this.reportFormat.equals("brief")) {
                surefireBooter.addReport("org.apache.maven.surefire.report.BriefFileReporter");
            } else if (this.reportFormat.equals("plain")) {
                surefireBooter.addReport("org.apache.maven.surefire.report.FileReporter");
            }
        } else if (this.reportFormat.equals("brief")) {
            surefireBooter.addReport("org.apache.maven.surefire.report.BriefConsoleReporter");
        } else if (this.reportFormat.equals("plain")) {
            surefireBooter.addReport("org.apache.maven.surefire.report.DetailedConsoleReporter");
        }
        surefireBooter.addReport("org.apache.maven.surefire.report.XMLReporter");
    }
}

