/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.invoker;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.codehaus.plexus.util.StringUtils;

class InvokerProperties {
    private static final String SELECTOR_PREFIX = "selector.";
    private final Properties properties;

    public InvokerProperties(Properties properties) {
        this.properties = properties != null ? properties : new Properties();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getJobName() {
        return this.properties.getProperty("invoker.name", "");
    }

    public String getJobDescription() {
        return this.properties.getProperty("invoker.description", "");
    }

    public String getJreVersion() {
        return this.properties.getProperty("invoker.java.version", "");
    }

    public String getJreVersion(int index) {
        return this.properties.getProperty(SELECTOR_PREFIX + index + SelectorProperty.JAVA_VERSION.suffix, this.getJreVersion());
    }

    public String getMavenVersion() {
        return this.properties.getProperty("invoker.maven.version", "");
    }

    public String getMavenVersion(int index) {
        return this.properties.getProperty(SELECTOR_PREFIX + index + SelectorProperty.MAVEN_VERSION.suffix, this.getMavenVersion());
    }

    public String getOsFamily() {
        return this.properties.getProperty("invoker.os.family", "");
    }

    public String getOsFamily(int index) {
        return this.properties.getProperty(SELECTOR_PREFIX + index + SelectorProperty.OS_FAMLY.suffix, this.getOsFamily());
    }

    public boolean isInvocationDefined(int index) {
        for (InvocationProperty prop : InvocationProperty.values()) {
            if (this.properties.getProperty(prop.toString() + '.' + index) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isSelectorDefined(int index) {
        for (SelectorProperty prop : SelectorProperty.values()) {
            if (this.properties.getProperty(SELECTOR_PREFIX + index + prop.suffix) == null) continue;
            return true;
        }
        return false;
    }

    public void configureInvocation(InvocationRequest request, int index) {
        String debug;
        String offline;
        String nonRecursive;
        String failureBehavior;
        String mvnOpts;
        String profiles;
        String goals;
        String project = this.get(InvocationProperty.PROJECT, index);
        if (project != null) {
            File file = new File(request.getBaseDirectory(), project);
            if (file.isFile()) {
                request.setBaseDirectory(file.getParentFile());
                request.setPomFile(file);
            } else {
                request.setBaseDirectory(file);
                request.setPomFile(null);
            }
        }
        if ((goals = this.get(InvocationProperty.GOALS, index)) != null) {
            request.setGoals(new ArrayList<String>(Arrays.asList(StringUtils.split((String)goals, (String)", \t\n\r\f"))));
        }
        if ((profiles = this.get(InvocationProperty.PROFILES, index)) != null) {
            request.setProfiles(new ArrayList<String>(Arrays.asList(StringUtils.split((String)profiles, (String)", \t\n\r\f"))));
        }
        if ((mvnOpts = this.get(InvocationProperty.MAVEN_OPTS, index)) != null) {
            request.setMavenOpts(mvnOpts);
        }
        if ((failureBehavior = this.get(InvocationProperty.FAILURE_BEHAVIOR, index)) != null) {
            InvocationRequest.ReactorFailureBehavior valueOf = InvocationRequest.ReactorFailureBehavior.valueOfByLongOption((String)failureBehavior);
            request.setReactorFailureBehavior(valueOf);
        }
        if ((nonRecursive = this.get(InvocationProperty.NON_RECURSIVE, index)) != null) {
            request.setRecursive(Boolean.valueOf(nonRecursive) == false);
        }
        if ((offline = this.get(InvocationProperty.OFFLINE, index)) != null) {
            request.setOffline(Boolean.valueOf(offline).booleanValue());
        }
        if ((debug = this.get(InvocationProperty.DEBUG, index)) != null) {
            request.setDebug(Boolean.valueOf(debug).booleanValue());
        }
    }

    public boolean isExpectedResult(int exitCode, int index) {
        boolean nonZeroExit = "failure".equalsIgnoreCase(this.get("invoker.buildResult", index));
        return exitCode != 0 == nonZeroExit;
    }

    public String getSystemPropertiesFile(int index) {
        return this.get(InvocationProperty.SYSTEM_PROPERTIES_FILE, index);
    }

    public String getSettingsFile(int index) {
        return this.get(InvocationProperty.SETTINGS_FILE, index);
    }

    String get(String key, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("invalid invocation index: " + index);
        }
        String value = this.properties.getProperty(key + '.' + index);
        if (value == null) {
            value = this.properties.getProperty(key);
        }
        return value;
    }

    private String get(InvocationProperty prop, int index) {
        return this.get(prop.toString(), index);
    }

    private static enum SelectorProperty {
        JAVA_VERSION(".java.version"),
        MAVEN_VERSION(".maven.version"),
        OS_FAMLY(".os.family");

        private final String suffix;

        private SelectorProperty(String suffix) {
            this.suffix = suffix;
        }

        public String toString() {
            return this.suffix;
        }
    }

    private static enum InvocationProperty {
        PROJECT("invoker.project"),
        GOALS("invoker.goals"),
        PROFILES("invoker.profiles"),
        MAVEN_OPTS("invoker.mavenOpts"),
        FAILURE_BEHAVIOR("invoker.failureBehavior"),
        NON_RECURSIVE("invoker.nonRecursive"),
        OFFLINE("invoker.offline"),
        SYSTEM_PROPERTIES_FILE("invoker.systemPropertiesFile"),
        DEBUG("invoker.debug"),
        SETTINGS_FILE("invoker.settingsFile");

        private final String key;

        private InvocationProperty(String s) {
            this.key = s;
        }

        public String toString() {
            return this.key;
        }
    }
}

