/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.help.AbstractEffectiveMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

@Mojo(name="effective-pom", aggregator=true)
public class EffectivePomMojo
extends AbstractEffectiveMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> projects;
    @Parameter(defaultValue="${mojo}", required=true, readonly=true)
    private MojoExecution mojoExecution;
    @Parameter(property="artifact")
    private String artifact;

    public void execute() throws MojoExecutionException {
        if (StringUtils.isNotEmpty((String)this.artifact)) {
            this.project = this.getMavenProject(this.artifact);
        }
        StringWriter w = new StringWriter();
        String encoding = this.output != null ? this.project.getModel().getModelEncoding() : System.getProperty("file.encoding");
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, StringUtils.repeat((String)" ", (int)2), encoding, null);
        EffectivePomMojo.writeHeader((XMLWriter)writer);
        if (this.shouldWriteAllEffectivePOMsInReactor()) {
            writer.startElement("projects");
            for (MavenProject subProject : this.projects) {
                EffectivePomMojo.writeEffectivePom(subProject, (XMLWriter)writer);
            }
            writer.endElement();
        } else {
            EffectivePomMojo.writeEffectivePom(this.project, (XMLWriter)writer);
        }
        String effectivePom = EffectivePomMojo.prettyFormat(w.toString(), encoding, false);
        if (this.output != null) {
            try {
                EffectivePomMojo.writeXmlFile(this.output, effectivePom);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write effective-POM to output: " + this.output, (Exception)e);
            }
            this.getLog().info((CharSequence)("Effective-POM written to: " + this.output));
        } else {
            StringBuilder message = new StringBuilder();
            message.append(LS);
            message.append("Effective POMs, after inheritance, interpolation, and profiles are applied:");
            message.append(LS).append(LS);
            message.append(effectivePom);
            message.append(LS);
            this.getLog().info((CharSequence)message.toString());
        }
    }

    private boolean shouldWriteAllEffectivePOMsInReactor() {
        MojoExecution.Source source = this.mojoExecution.getSource();
        return this.projects.size() > 1 && (source == MojoExecution.Source.CLI || source != MojoExecution.Source.CLI && this.projects.get(0).equals((Object)this.project));
    }

    private static void writeEffectivePom(MavenProject project, XMLWriter writer) throws MojoExecutionException {
        Model pom = project.getModel();
        EffectivePomMojo.cleanModel(pom);
        StringWriter sWriter = new StringWriter();
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        try {
            pomWriter.write((Writer)sWriter, pom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot serialize POM to XML.", (Exception)e);
        }
        String effectivePom = EffectivePomMojo.prettyFormat(sWriter.toString(), null, true);
        EffectivePomMojo.writeComment(writer, "Effective POM for project '" + project.getId() + "'");
        writer.writeMarkup(effectivePom);
    }

    private static void cleanModel(Model pom) {
        AbstractEffectiveMojo.SortedProperties properties = new AbstractEffectiveMojo.SortedProperties();
        properties.putAll((Map<?, ?>)pom.getProperties());
        pom.setProperties((Properties)properties);
    }
}

