/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class DefaultProfileManager
implements ProfileManager {
    private PlexusContainer container;
    private List activatedIds = new ArrayList();
    private List deactivatedIds = new ArrayList();
    private List defaultIds = new ArrayList();
    private Map profilesById = new HashMap();

    public DefaultProfileManager(PlexusContainer container) {
        this.container = container;
    }

    public Map getProfilesById() {
        return this.profilesById;
    }

    public void addProfile(Profile profile) {
        String profileId = profile.getId();
        Profile existing = (Profile)this.profilesById.get(profileId);
        if (existing != null) {
            this.container.getLogger().warn("Overriding profile: '" + profileId + "' (source: " + existing.getSource() + ") with new instance from source: " + profile.getSource());
        }
        this.profilesById.put(profile.getId(), profile);
        Activation activation = profile.getActivation();
        if (activation != null && activation.isActiveByDefault()) {
            this.activateAsDefault(profileId);
        }
    }

    public void explicitlyActivate(String profileId) {
        if (!this.activatedIds.contains(profileId)) {
            this.container.getLogger().debug("Profile with id: '" + profileId + "' has been explicitly activated.");
            this.activatedIds.add(profileId);
        }
    }

    public void explicitlyActivate(List profileIds) {
        Iterator it = profileIds.iterator();
        while (it.hasNext()) {
            String profileId = (String)it.next();
            this.explicitlyActivate(profileId);
        }
    }

    public void explicitlyDeactivate(String profileId) {
        if (!this.deactivatedIds.contains(profileId)) {
            this.container.getLogger().debug("Profile with id: '" + profileId + "' has been explicitly deactivated.");
            this.deactivatedIds.add(profileId);
        }
    }

    public void explicitlyDeactivate(List profileIds) {
        Iterator it = profileIds.iterator();
        while (it.hasNext()) {
            String profileId = (String)it.next();
            this.explicitlyDeactivate(profileId);
        }
    }

    public List getActiveProfiles() throws ProfileActivationException {
        ArrayList<Profile> active = new ArrayList<Profile>(this.profilesById.size());
        Iterator it = this.profilesById.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String profileId = (String)entry.getKey();
            Profile profile = (Profile)entry.getValue();
            if (this.activatedIds.contains(profileId)) {
                active.add(profile);
                continue;
            }
            if (this.deactivatedIds.contains(profileId) || !this.isActive(profile)) continue;
            active.add(profile);
        }
        if (active.isEmpty()) {
            it = this.defaultIds.iterator();
            while (it.hasNext()) {
                String profileId = (String)((Object)it.next());
                Profile profile = (Profile)this.profilesById.get(profileId);
                active.add(profile);
            }
        }
        return active;
    }

    private boolean isActive(Profile profile) throws ProfileActivationException {
        List activators = null;
        try {
            activators = this.container.lookupList(ProfileActivator.ROLE);
            Iterator activatorIterator22 = activators.iterator();
            while (activatorIterator22.hasNext()) {
                ProfileActivator activator = (ProfileActivator)activatorIterator22.next();
                if (!activator.canDetermineActivation(profile)) continue;
                boolean bl = activator.isActive(profile);
                return bl;
            }
            boolean activatorIterator22 = false;
            return activatorIterator22;
        }
        catch (ComponentLookupException e) {
            throw new ProfileActivationException("Cannot retrieve list of profile activators.", e);
        }
        finally {
            try {
                this.container.releaseAll(activators);
            }
            catch (ComponentLifecycleException e) {
                this.container.getLogger().debug("Error releasing profile activators - ignoring.", (Throwable)e);
            }
        }
    }

    public void addProfiles(List profiles) {
        Iterator it = profiles.iterator();
        while (it.hasNext()) {
            Profile profile = (Profile)it.next();
            this.addProfile(profile);
        }
    }

    public void activateAsDefault(String profileId) {
        if (!this.defaultIds.contains(profileId)) {
            this.defaultIds.add(profileId);
        }
    }

    public List getExplicitlyActivatedIds() {
        return this.activatedIds;
    }

    public List getExplicitlyDeactivatedIds() {
        return this.deactivatedIds;
    }

    public List getIdsActivatedByDefault() {
        return this.defaultIds;
    }
}

