/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.IOException;
import java.util.ArrayList;
import javaewah.EWAHCompressedBitmap;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.index.bitmap.BitmapObjectInput;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="ewah_bitmap_empty", value="_FUNC_(bitmap) - Predicate that tests whether an EWAH-compressed bitmap is all zeros ")
public class GenericUDFEWAHBitmapEmpty
extends GenericUDF {
    private transient ObjectInspector bitmapOI;
    private transient BooleanObjectInspector boolOI;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("The function EWAH_BITMAP_EMPTY(b) takes exactly 1 argument");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            throw new UDFArgumentTypeException(0, "\"" + ObjectInspector.Category.LIST.toString().toLowerCase() + "\" is expected at function EWAH_BITMAP_EMPTY, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.bitmapOI = (ListObjectInspector)arguments[0];
        this.boolOI = PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
        return this.boolOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        assert (arguments.length == 1);
        Object b = arguments[0].get();
        ListObjectInspector lloi = (ListObjectInspector)this.bitmapOI;
        int length = lloi.getListLength(b);
        ArrayList<LongWritable> bitmapArray = new ArrayList<LongWritable>();
        for (int i = 0; i < length; ++i) {
            long l = PrimitiveObjectInspectorUtils.getLong(lloi.getListElement(b, i), (PrimitiveObjectInspector)lloi.getListElementObjectInspector());
            bitmapArray.add(new LongWritable(l));
        }
        BitmapObjectInput bitmapObjIn = new BitmapObjectInput(bitmapArray);
        EWAHCompressedBitmap bitmap = new EWAHCompressedBitmap();
        try {
            bitmap.readExternal(bitmapObjIn);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new BooleanWritable(!bitmap.iterator().hasNext());
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("EWAH_BITMAP_EMPTY(");
        for (int i = 0; i < children.length; ++i) {
            sb.append(children[i]);
            if (i + 1 == children.length) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

