/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.NumericHistogram;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="percentile_approx", value="_FUNC_(expr, pc, [nb]) - For very large data, computes an approximate percentile value from a histogram, using the optional argument [nb] as the number of histogram bins to use. A higher value of nb results in a more accurate approximation, at the cost of higher memory usage.", extended="'expr' can be any numeric column, including doubles and floats, and 'pc' is either a single double/float with a requested percentile, or an array of double/float with multiple percentiles. If 'nb' is not specified, the default approximation is done with 10,000 histogram bins, which means that if there are 10,000 or fewer unique values in 'expr', you can expect an exact result. The percentile() function always computes an exact percentile and can run out of memory if there are too many unique values in a column, which necessitates this function.\nExample (three percentiles requested using a finer histogram approximation):\n> SELECT percentile_approx(val, array(0.5, 0.95, 0.98), 100000) FROM somedata;\n[0.05,1.64,2.26]\n")
public class GenericUDAFPercentileApprox
extends AbstractGenericUDAFResolver {
    static final Log LOG = LogFactory.getLog((String)GenericUDAFPercentileApprox.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        ObjectInspector[] parameters = info.getParameterObjectInspectors();
        if (parameters.length != 2 && parameters.length != 3) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Please specify either two or three arguments.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " was passed as parameter 1.");
        }
        switch (((PrimitiveObjectInspector)parameters[0]).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case TIMESTAMP: 
            case DECIMAL: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Only numeric type arguments are accepted but " + parameters[0].getTypeName() + " was passed as parameter 1.");
            }
        }
        boolean wantManyQuantiles = false;
        block3 : switch (parameters[1].getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveObjectInspector)parameters[1]).getPrimitiveCategory()) {
                    case FLOAT: 
                    case DOUBLE: {
                        break block3;
                    }
                }
                throw new UDFArgumentTypeException(1, "Only a float/double or float/double array argument is accepted as parameter 2, but " + parameters[1].getTypeName() + " was passed instead.");
            }
            case LIST: {
                if (((ListObjectInspector)parameters[1]).getListElementObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                    throw new UDFArgumentTypeException(1, "A float/double array argument may be passed as parameter 2, but " + parameters[1].getTypeName() + " was passed instead.");
                }
                switch (((PrimitiveObjectInspector)((ListObjectInspector)parameters[1]).getListElementObjectInspector()).getPrimitiveCategory()) {
                    case FLOAT: 
                    case DOUBLE: {
                        break;
                    }
                    default: {
                        throw new UDFArgumentTypeException(1, "A float/double array argument may be passed as parameter 2, but " + parameters[1].getTypeName() + " was passed instead.");
                    }
                }
                wantManyQuantiles = true;
                break;
            }
            default: {
                throw new UDFArgumentTypeException(1, "Only a float/double or float/double array argument is accepted as parameter 2, but " + parameters[1].getTypeName() + " was passed instead.");
            }
        }
        if (!ObjectInspectorUtils.isConstantObjectInspector(parameters[1])) {
            throw new UDFArgumentTypeException(1, "The second argument must be a constant, but " + parameters[1].getTypeName() + " was passed instead.");
        }
        if (parameters.length == 3) {
            if (parameters[2].getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new UDFArgumentTypeException(2, "Only a primitive argument is accepted as parameter 3, but " + parameters[2].getTypeName() + " was passed instead.");
            }
            switch (((PrimitiveObjectInspector)parameters[2]).getPrimitiveCategory()) {
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case TIMESTAMP: {
                    break;
                }
                default: {
                    throw new UDFArgumentTypeException(2, "Only an integer argument is accepted as parameter 3, but " + parameters[2].getTypeName() + " was passed instead.");
                }
            }
            if (!ObjectInspectorUtils.isConstantObjectInspector(parameters[2])) {
                throw new UDFArgumentTypeException(2, "The third argument must be a constant, but " + parameters[2].getTypeName() + " was passed instead.");
            }
        }
        if (wantManyQuantiles) {
            return new GenericUDAFMultiplePercentileApproxEvaluator();
        }
        return new GenericUDAFSinglePercentileApproxEvaluator();
    }

    public static abstract class GenericUDAFPercentileApproxEvaluator
    extends GenericUDAFEvaluator {
        protected PrimitiveObjectInspector inputOI;
        protected double[] quantiles;
        protected Integer nbins = 10000;
        protected transient StandardListObjectInspector loi;

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial == null) {
                return;
            }
            PercentileAggBuf myagg = (PercentileAggBuf)agg;
            List<DoubleWritable> partialHistogram = this.loi.getList(partial);
            int nquantiles = (int)((DoubleWritable)partialHistogram.get(0)).get();
            if (nquantiles > 0) {
                myagg.quantiles = new double[nquantiles];
                for (int i = 1; i <= nquantiles; ++i) {
                    myagg.quantiles[i - 1] = partialHistogram.get(i).get();
                }
                partialHistogram.subList(0, nquantiles + 1).clear();
            }
            myagg.histogram.merge(partialHistogram);
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            PercentileAggBuf myagg = (PercentileAggBuf)agg;
            ArrayList<DoubleWritable> result = new ArrayList<DoubleWritable>();
            if (myagg.quantiles != null) {
                result.add(new DoubleWritable(myagg.quantiles.length));
                for (int i = 0; i < myagg.quantiles.length; ++i) {
                    result.add(new DoubleWritable(myagg.quantiles[i]));
                }
            } else {
                result.add(new DoubleWritable(0.0));
            }
            result.addAll(myagg.histogram.serialize());
            return result;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            assert (parameters.length == 2 || parameters.length == 3);
            if (parameters[0] == null || parameters[1] == null) {
                return;
            }
            PercentileAggBuf myagg = (PercentileAggBuf)agg;
            double v = PrimitiveObjectInspectorUtils.getDouble(parameters[0], this.inputOI);
            myagg.histogram.add(v);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            PercentileAggBuf result = new PercentileAggBuf();
            result.histogram = new NumericHistogram();
            this.reset(result);
            return result;
        }

        protected double[] getQuantileArray(ConstantObjectInspector quantileOI) throws HiveException {
            double[] result = null;
            Object quantileObj = quantileOI.getWritableConstantValue();
            if (quantileOI instanceof ListObjectInspector) {
                ObjectInspector elemOI = ((ListObjectInspector)((Object)quantileOI)).getListElementObjectInspector();
                result = new double[((List)quantileObj).size()];
                assert (result.length >= 1);
                for (int ii = 0; ii < result.length; ++ii) {
                    result[ii] = PrimitiveObjectInspectorUtils.getDouble(((List)quantileObj).get(ii), (PrimitiveObjectInspector)elemOI);
                }
            } else {
                result = new double[]{PrimitiveObjectInspectorUtils.getDouble(quantileObj, (PrimitiveObjectInspector)((Object)quantileOI))};
            }
            for (int ii = 0; ii < result.length; ++ii) {
                if (!(result[ii] <= 0.0) && !(result[ii] >= 1.0)) continue;
                throw new HiveException(this.getClass().getSimpleName() + " requires percentile values to " + "lie strictly between 0 and 1, but you supplied " + result[ii]);
            }
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            PercentileAggBuf result = (PercentileAggBuf)agg;
            result.histogram.reset();
            result.quantiles = null;
            result.histogram.allocate(this.nbins);
            result.quantiles = this.quantiles;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static class PercentileAggBuf
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            NumericHistogram histogram;
            double[] quantiles;

            PercentileAggBuf() {
            }

            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return model.lengthFor(this.histogram) + model.array() + 8 * this.quantiles.length;
            }
        }
    }

    public static class GenericUDAFMultiplePercentileApproxEvaluator
    extends GenericUDAFPercentileApproxEvaluator {
        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
                this.quantiles = this.getQuantileArray((ConstantObjectInspector)parameters[1]);
                if (parameters.length > 2) {
                    this.nbins = PrimitiveObjectInspectorUtils.getInt(((ConstantObjectInspector)parameters[2]).getWritableConstantValue(), (PrimitiveObjectInspector)parameters[2]);
                }
            } else {
                this.loi = (StandardListObjectInspector)parameters[0];
            }
            return ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            GenericUDAFPercentileApproxEvaluator.PercentileAggBuf myagg = (GenericUDAFPercentileApproxEvaluator.PercentileAggBuf)agg;
            if (myagg.histogram.getUsedBins() < 1) {
                return null;
            }
            ArrayList<DoubleWritable> result = new ArrayList<DoubleWritable>();
            assert (myagg.quantiles != null);
            for (int i = 0; i < myagg.quantiles.length; ++i) {
                result.add(new DoubleWritable(myagg.histogram.quantile(myagg.quantiles[i])));
            }
            return result;
        }
    }

    public static class GenericUDAFSinglePercentileApproxEvaluator
    extends GenericUDAFPercentileApproxEvaluator {
        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
                this.quantiles = this.getQuantileArray((ConstantObjectInspector)parameters[1]);
                if (parameters.length > 2) {
                    this.nbins = PrimitiveObjectInspectorUtils.getInt(((ConstantObjectInspector)parameters[2]).getWritableConstantValue(), (PrimitiveObjectInspector)parameters[2]);
                }
            } else {
                this.loi = (StandardListObjectInspector)parameters[0];
            }
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            }
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            GenericUDAFPercentileApproxEvaluator.PercentileAggBuf myagg = (GenericUDAFPercentileApproxEvaluator.PercentileAggBuf)agg;
            if (myagg.histogram.getUsedBins() < 1) {
                return null;
            }
            assert (myagg.quantiles != null);
            return new DoubleWritable(myagg.histogram.quantile(myagg.quantiles[0]));
        }
    }
}

