/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.DoubleNumDistinctValueEstimator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.LongNumDistinctValueEstimator;
import org.apache.hadoop.hive.ql.udf.generic.NumDistinctValueEstimator;
import org.apache.hadoop.hive.ql.udf.generic.StringNumDistinctValueEstimator;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.StringUtils;

@Description(name="compute_stats", value="_FUNC_(x) - Returns the statistical summary of a set of primitive type values.")
public class GenericUDAFComputeStats
extends AbstractGenericUDAFResolver {
    static final Log LOG = LogFactory.getLog((String)GenericUDAFComputeStats.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 2) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly two arguments are expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case BOOLEAN: {
                return new GenericUDAFBooleanStatsEvaluator();
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case TIMESTAMP: {
                return new GenericUDAFLongStatsEvaluator();
            }
            case FLOAT: 
            case DOUBLE: {
                return new GenericUDAFDoubleStatsEvaluator();
            }
            case STRING: 
            case VARCHAR: {
                return new GenericUDAFStringStatsEvaluator();
            }
            case BINARY: {
                return new GenericUDAFBinaryStatsEvaluator();
            }
        }
        throw new UDFArgumentTypeException(0, "Only integer/long/timestamp/float/double/string/binary/boolean type argument is accepted but " + parameters[0].getTypeName() + " is passed.");
    }

    public static class GenericUDAFBinaryStatsEvaluator
    extends GenericUDAFEvaluator {
        private transient PrimitiveObjectInspector inputOI;
        private transient Object[] partialResult;
        private transient StructObjectInspector soi;
        private transient StructField maxLengthField;
        private transient WritableLongObjectInspector maxLengthFieldOI;
        private transient StructField sumLengthField;
        private transient WritableLongObjectInspector sumLengthFieldOI;
        private transient StructField countField;
        private transient WritableLongObjectInspector countFieldOI;
        private transient StructField countNullsField;
        private transient WritableLongObjectInspector countNullsFieldOI;
        private transient Object[] result;
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
            } else {
                this.soi = (StructObjectInspector)parameters[0];
                this.maxLengthField = this.soi.getStructFieldRef("MaxLength");
                this.maxLengthFieldOI = (WritableLongObjectInspector)this.maxLengthField.getFieldObjectInspector();
                this.sumLengthField = this.soi.getStructFieldRef("SumLength");
                this.sumLengthFieldOI = (WritableLongObjectInspector)this.sumLengthField.getFieldObjectInspector();
                this.countField = this.soi.getStructFieldRef("Count");
                this.countFieldOI = (WritableLongObjectInspector)this.countField.getFieldObjectInspector();
                this.countNullsField = this.soi.getStructFieldRef("CountNulls");
                this.countNullsFieldOI = (WritableLongObjectInspector)this.countNullsField.getFieldObjectInspector();
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
                foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                ArrayList<String> fname = new ArrayList<String>();
                fname.add("ColumnType");
                fname.add("MaxLength");
                fname.add("SumLength");
                fname.add("Count");
                fname.add("CountNulls");
                this.partialResult = new Object[5];
                this.partialResult[0] = new Text();
                this.partialResult[1] = new LongWritable(0L);
                this.partialResult[2] = new LongWritable(0L);
                this.partialResult[3] = new LongWritable(0L);
                this.partialResult[4] = new LongWritable(0L);
                return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
            }
            ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
            foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            ArrayList<String> fname = new ArrayList<String>();
            fname.add("ColumnType");
            fname.add("MaxLength");
            fname.add("AvgLength");
            fname.add("CountNulls");
            this.result = new Object[4];
            this.result[0] = new Text();
            this.result[1] = new LongWritable(0L);
            this.result[2] = new DoubleWritable(0.0);
            this.result[3] = new LongWritable(0L);
            return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            BinaryStatsAgg result = new BinaryStatsAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BinaryStatsAgg myagg = (BinaryStatsAgg)agg;
            myagg.columnType = new String("Binary");
            myagg.maxLength = 0L;
            myagg.sumLength = 0L;
            myagg.count = 0L;
            myagg.countNulls = 0L;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block7: {
                Object p = parameters[0];
                BinaryStatsAgg myagg = (BinaryStatsAgg)agg;
                boolean emptyTable = false;
                if (parameters[1] == null) {
                    emptyTable = true;
                }
                if (!emptyTable) {
                    if (p == null) {
                        ++myagg.countNulls;
                    } else {
                        try {
                            BytesWritable v = PrimitiveObjectInspectorUtils.getBinary(p, this.inputOI);
                            int len = v.getLength();
                            if ((long)len > myagg.maxLength) {
                                myagg.maxLength = len;
                            }
                            myagg.sumLength += (long)len;
                            ++myagg.count;
                        }
                        catch (NumberFormatException e) {
                            if (this.warned) break block7;
                            this.warned = true;
                            LOG.warn((Object)(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e)));
                            LOG.warn((Object)(this.getClass().getSimpleName() + " ignoring similar exceptions."));
                        }
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BinaryStatsAgg myagg = (BinaryStatsAgg)agg;
            ((Text)this.partialResult[0]).set(myagg.columnType);
            ((LongWritable)this.partialResult[1]).set(myagg.maxLength);
            ((LongWritable)this.partialResult[2]).set(myagg.sumLength);
            ((LongWritable)this.partialResult[3]).set(myagg.count);
            ((LongWritable)this.partialResult[4]).set(myagg.countNulls);
            return this.partialResult;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                BinaryStatsAgg myagg = (BinaryStatsAgg)agg;
                Object partialValue = this.soi.getStructFieldData(partial, this.maxLengthField);
                if (myagg.maxLength < this.maxLengthFieldOI.get(partialValue)) {
                    myagg.maxLength = this.maxLengthFieldOI.get(partialValue);
                }
                partialValue = this.soi.getStructFieldData(partial, this.sumLengthField);
                myagg.sumLength += this.sumLengthFieldOI.get(partialValue);
                partialValue = this.soi.getStructFieldData(partial, this.countField);
                myagg.count += this.countFieldOI.get(partialValue);
                partialValue = this.soi.getStructFieldData(partial, this.countNullsField);
                myagg.countNulls += this.countNullsFieldOI.get(partialValue);
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BinaryStatsAgg myagg = (BinaryStatsAgg)agg;
            double avgLength = 0.0;
            long count = myagg.count + myagg.countNulls;
            if (count != 0L) {
                avgLength = (double)myagg.sumLength / (1.0 * (double)(myagg.count + myagg.countNulls));
            }
            ((Text)this.result[0]).set(myagg.columnType);
            ((LongWritable)this.result[1]).set(myagg.maxLength);
            ((DoubleWritable)this.result[2]).set(avgLength);
            ((LongWritable)this.result[3]).set(myagg.countNulls);
            return this.result;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public static class BinaryStatsAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            public String columnType;
            public long maxLength;
            public long sumLength;
            public long count;
            public long countNulls;

            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return model.primitive2() * 4 + model.lengthFor(this.columnType);
            }
        }
    }

    public static class GenericUDAFStringStatsEvaluator
    extends GenericUDAFEvaluator {
        private transient PrimitiveObjectInspector inputOI;
        private transient PrimitiveObjectInspector numVectorsOI;
        private transient Object[] partialResult;
        private transient StructObjectInspector soi;
        private transient StructField maxLengthField;
        private transient WritableLongObjectInspector maxLengthFieldOI;
        private transient StructField sumLengthField;
        private transient WritableLongObjectInspector sumLengthFieldOI;
        private transient StructField countField;
        private transient WritableLongObjectInspector countFieldOI;
        private transient StructField countNullsField;
        private transient WritableLongObjectInspector countNullsFieldOI;
        private transient StructField ndvField;
        private transient WritableStringObjectInspector ndvFieldOI;
        private transient StructField numBitVectorsField;
        private transient WritableIntObjectInspector numBitVectorsFieldOI;
        private transient Object[] result;
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
                this.numVectorsOI = (PrimitiveObjectInspector)parameters[1];
            } else {
                this.soi = (StructObjectInspector)parameters[0];
                this.maxLengthField = this.soi.getStructFieldRef("MaxLength");
                this.maxLengthFieldOI = (WritableLongObjectInspector)this.maxLengthField.getFieldObjectInspector();
                this.sumLengthField = this.soi.getStructFieldRef("SumLength");
                this.sumLengthFieldOI = (WritableLongObjectInspector)this.sumLengthField.getFieldObjectInspector();
                this.countField = this.soi.getStructFieldRef("Count");
                this.countFieldOI = (WritableLongObjectInspector)this.countField.getFieldObjectInspector();
                this.countNullsField = this.soi.getStructFieldRef("CountNulls");
                this.countNullsFieldOI = (WritableLongObjectInspector)this.countNullsField.getFieldObjectInspector();
                this.ndvField = this.soi.getStructFieldRef("BitVector");
                this.ndvFieldOI = (WritableStringObjectInspector)this.ndvField.getFieldObjectInspector();
                this.numBitVectorsField = this.soi.getStructFieldRef("NumBitVectors");
                this.numBitVectorsFieldOI = (WritableIntObjectInspector)this.numBitVectorsField.getFieldObjectInspector();
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
                foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                ArrayList<String> fname = new ArrayList<String>();
                fname.add("ColumnType");
                fname.add("MaxLength");
                fname.add("SumLength");
                fname.add("Count");
                fname.add("CountNulls");
                fname.add("BitVector");
                fname.add("NumBitVectors");
                this.partialResult = new Object[7];
                this.partialResult[0] = new Text();
                this.partialResult[1] = new LongWritable(0L);
                this.partialResult[2] = new LongWritable(0L);
                this.partialResult[3] = new LongWritable(0L);
                this.partialResult[4] = new LongWritable(0L);
                this.partialResult[5] = new Text();
                this.partialResult[6] = new IntWritable(0);
                return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
            }
            ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
            foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            ArrayList<String> fname = new ArrayList<String>();
            fname.add("ColumnType");
            fname.add("MaxLength");
            fname.add("AvgLength");
            fname.add("CountNulls");
            fname.add("NumDistinctValues");
            this.result = new Object[5];
            this.result[0] = new Text();
            this.result[1] = new LongWritable(0L);
            this.result[2] = new DoubleWritable(0.0);
            this.result[3] = new LongWritable(0L);
            this.result[4] = new LongWritable(0L);
            return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            StringStatsAgg result = new StringStatsAgg();
            this.reset(result);
            return result;
        }

        public void initNDVEstimator(StringStatsAgg aggBuffer, int numBitVectors) {
            aggBuffer.numDV = new StringNumDistinctValueEstimator(numBitVectors);
            aggBuffer.numDV.reset();
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StringStatsAgg myagg = (StringStatsAgg)agg;
            myagg.columnType = new String("String");
            myagg.maxLength = 0L;
            myagg.sumLength = 0L;
            myagg.count = 0L;
            myagg.countNulls = 0L;
            myagg.firstItem = true;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block9: {
                Object p = parameters[0];
                StringStatsAgg myagg = (StringStatsAgg)agg;
                boolean emptyTable = false;
                if (parameters[1] == null) {
                    emptyTable = true;
                }
                if (myagg.firstItem) {
                    int numVectors = 0;
                    if (!emptyTable) {
                        numVectors = PrimitiveObjectInspectorUtils.getInt(parameters[1], this.numVectorsOI);
                    }
                    this.initNDVEstimator(myagg, numVectors);
                    myagg.firstItem = false;
                    myagg.numBitVectors = numVectors;
                }
                if (!emptyTable) {
                    if (p == null) {
                        ++myagg.countNulls;
                    } else {
                        try {
                            String v = PrimitiveObjectInspectorUtils.getString(p, this.inputOI);
                            int len = v.length();
                            if ((long)len > myagg.maxLength) {
                                myagg.maxLength = len;
                            }
                            myagg.sumLength += (long)len;
                            ++myagg.count;
                            myagg.numDV.addToEstimator(v);
                        }
                        catch (NumberFormatException e) {
                            if (this.warned) break block9;
                            this.warned = true;
                            LOG.warn((Object)(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e)));
                            LOG.warn((Object)(this.getClass().getSimpleName() + " ignoring similar exceptions."));
                        }
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StringStatsAgg myagg = (StringStatsAgg)agg;
            Text t = myagg.numDV.serialize();
            ((Text)this.partialResult[0]).set(myagg.columnType);
            ((LongWritable)this.partialResult[1]).set(myagg.maxLength);
            ((LongWritable)this.partialResult[2]).set(myagg.sumLength);
            ((LongWritable)this.partialResult[3]).set(myagg.count);
            ((LongWritable)this.partialResult[4]).set(myagg.countNulls);
            ((Text)this.partialResult[5]).set(t);
            ((IntWritable)this.partialResult[6]).set(myagg.numBitVectors);
            return this.partialResult;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                Object partialValue;
                StringStatsAgg myagg = (StringStatsAgg)agg;
                if (myagg.firstItem) {
                    partialValue = this.soi.getStructFieldData(partial, this.numBitVectorsField);
                    int numVectors = this.numBitVectorsFieldOI.get(partialValue);
                    this.initNDVEstimator(myagg, numVectors);
                    myagg.firstItem = false;
                    myagg.numBitVectors = numVectors;
                }
                if (myagg.maxLength < this.maxLengthFieldOI.get(partialValue = this.soi.getStructFieldData(partial, this.maxLengthField))) {
                    myagg.maxLength = this.maxLengthFieldOI.get(partialValue);
                }
                partialValue = this.soi.getStructFieldData(partial, this.sumLengthField);
                myagg.sumLength += this.sumLengthFieldOI.get(partialValue);
                partialValue = this.soi.getStructFieldData(partial, this.countField);
                myagg.count += this.countFieldOI.get(partialValue);
                partialValue = this.soi.getStructFieldData(partial, this.countNullsField);
                myagg.countNulls += this.countNullsFieldOI.get(partialValue);
                partialValue = this.soi.getStructFieldData(partial, this.ndvField);
                String v = this.ndvFieldOI.getPrimitiveJavaObject(partialValue);
                NumDistinctValueEstimator o = new NumDistinctValueEstimator(v, myagg.numBitVectors);
                myagg.numDV.mergeEstimators(o);
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StringStatsAgg myagg = (StringStatsAgg)agg;
            long numDV = 0L;
            double avgLength = 0.0;
            long total = myagg.count + myagg.countNulls;
            if (myagg.numBitVectors != 0) {
                numDV = myagg.numDV.estimateNumDistinctValues();
            }
            if (total != 0L) {
                avgLength = (double)myagg.sumLength / (1.0 * (double)total);
            }
            ((Text)this.result[0]).set(myagg.columnType);
            ((LongWritable)this.result[1]).set(myagg.maxLength);
            ((DoubleWritable)this.result[2]).set(avgLength);
            ((LongWritable)this.result[3]).set(myagg.countNulls);
            ((LongWritable)this.result[4]).set(numDV);
            return this.result;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public static class StringStatsAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            public String columnType;
            public long maxLength;
            public long sumLength;
            public long count;
            public long countNulls;
            public StringNumDistinctValueEstimator numDV;
            public int numBitVectors;
            public boolean firstItem;

            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return model.primitive1() * 2 + model.primitive2() * 4 + model.lengthFor(this.columnType) + model.lengthFor(this.numDV);
            }
        }
    }

    public static class GenericUDAFDoubleStatsEvaluator
    extends GenericUDAFEvaluator {
        private transient PrimitiveObjectInspector inputOI;
        private transient PrimitiveObjectInspector numVectorsOI;
        private transient Object[] partialResult;
        private transient StructObjectInspector soi;
        private transient StructField minField;
        private transient WritableDoubleObjectInspector minFieldOI;
        private transient StructField maxField;
        private transient WritableDoubleObjectInspector maxFieldOI;
        private transient StructField countNullsField;
        private transient WritableLongObjectInspector countNullsFieldOI;
        private transient StructField ndvField;
        private transient WritableStringObjectInspector ndvFieldOI;
        private transient StructField numBitVectorsField;
        private transient WritableIntObjectInspector numBitVectorsFieldOI;
        private transient Object[] result;
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
                this.numVectorsOI = (PrimitiveObjectInspector)parameters[1];
            } else {
                this.soi = (StructObjectInspector)parameters[0];
                this.minField = this.soi.getStructFieldRef("Min");
                this.minFieldOI = (WritableDoubleObjectInspector)this.minField.getFieldObjectInspector();
                this.maxField = this.soi.getStructFieldRef("Max");
                this.maxFieldOI = (WritableDoubleObjectInspector)this.maxField.getFieldObjectInspector();
                this.countNullsField = this.soi.getStructFieldRef("CountNulls");
                this.countNullsFieldOI = (WritableLongObjectInspector)this.countNullsField.getFieldObjectInspector();
                this.ndvField = this.soi.getStructFieldRef("BitVector");
                this.ndvFieldOI = (WritableStringObjectInspector)this.ndvField.getFieldObjectInspector();
                this.numBitVectorsField = this.soi.getStructFieldRef("NumBitVectors");
                this.numBitVectorsFieldOI = (WritableIntObjectInspector)this.numBitVectorsField.getFieldObjectInspector();
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
                foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                ArrayList<String> fname = new ArrayList<String>();
                fname.add("ColumnType");
                fname.add("Min");
                fname.add("Max");
                fname.add("CountNulls");
                fname.add("BitVector");
                fname.add("NumBitVectors");
                this.partialResult = new Object[6];
                this.partialResult[0] = new Text();
                this.partialResult[1] = new DoubleWritable(0.0);
                this.partialResult[2] = new DoubleWritable(0.0);
                this.partialResult[3] = new LongWritable(0L);
                this.partialResult[4] = new Text();
                this.partialResult[5] = new IntWritable(0);
                return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
            }
            ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
            foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            ArrayList<String> fname = new ArrayList<String>();
            fname.add("ColumnType");
            fname.add("Min");
            fname.add("Max");
            fname.add("CountNulls");
            fname.add("NumDistinctValues");
            this.result = new Object[5];
            this.result[0] = new Text();
            this.result[1] = new DoubleWritable(0.0);
            this.result[2] = new DoubleWritable(0.0);
            this.result[3] = new LongWritable(0L);
            this.result[4] = new LongWritable(0L);
            return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            DoubleStatsAgg result = new DoubleStatsAgg();
            this.reset(result);
            return result;
        }

        public void initNDVEstimator(DoubleStatsAgg aggBuffer, int numBitVectors) {
            aggBuffer.numDV = new DoubleNumDistinctValueEstimator(numBitVectors);
            aggBuffer.numDV.reset();
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            DoubleStatsAgg myagg = (DoubleStatsAgg)agg;
            myagg.columnType = new String("Double");
            myagg.min = 0.0;
            myagg.max = 0.0;
            myagg.countNulls = 0L;
            myagg.firstItem = true;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block10: {
                Object p = parameters[0];
                DoubleStatsAgg myagg = (DoubleStatsAgg)agg;
                boolean emptyTable = false;
                if (parameters[1] == null) {
                    emptyTable = true;
                }
                if (myagg.firstItem) {
                    int numVectors = 0;
                    if (!emptyTable) {
                        numVectors = PrimitiveObjectInspectorUtils.getInt(parameters[1], this.numVectorsOI);
                    }
                    this.initNDVEstimator(myagg, numVectors);
                    myagg.firstItem = false;
                    myagg.numBitVectors = numVectors;
                }
                if (!emptyTable) {
                    if (p == null) {
                        ++myagg.countNulls;
                    } else {
                        try {
                            double v = PrimitiveObjectInspectorUtils.getDouble(p, this.inputOI);
                            if (v < myagg.min) {
                                myagg.min = v;
                            }
                            if (v > myagg.max) {
                                myagg.max = v;
                            }
                            myagg.numDV.addToEstimator(v);
                        }
                        catch (NumberFormatException e) {
                            if (this.warned) break block10;
                            this.warned = true;
                            LOG.warn((Object)(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e)));
                            LOG.warn((Object)(this.getClass().getSimpleName() + " ignoring similar exceptions."));
                        }
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            DoubleStatsAgg myagg = (DoubleStatsAgg)agg;
            Text t = myagg.numDV.serialize();
            ((Text)this.partialResult[0]).set(myagg.columnType);
            ((DoubleWritable)this.partialResult[1]).set(myagg.min);
            ((DoubleWritable)this.partialResult[2]).set(myagg.max);
            ((LongWritable)this.partialResult[3]).set(myagg.countNulls);
            ((Text)this.partialResult[4]).set(t);
            ((IntWritable)this.partialResult[5]).set(myagg.numBitVectors);
            return this.partialResult;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                Object partialValue;
                DoubleStatsAgg myagg = (DoubleStatsAgg)agg;
                if (myagg.firstItem) {
                    partialValue = this.soi.getStructFieldData(partial, this.numBitVectorsField);
                    int numVectors = this.numBitVectorsFieldOI.get(partialValue);
                    this.initNDVEstimator(myagg, numVectors);
                    myagg.firstItem = false;
                    myagg.numBitVectors = numVectors;
                }
                if (myagg.min > this.minFieldOI.get(partialValue = this.soi.getStructFieldData(partial, this.minField))) {
                    myagg.min = this.minFieldOI.get(partialValue);
                }
                if (myagg.max < this.maxFieldOI.get(partialValue = this.soi.getStructFieldData(partial, this.maxField))) {
                    myagg.max = this.maxFieldOI.get(partialValue);
                }
                partialValue = this.soi.getStructFieldData(partial, this.countNullsField);
                myagg.countNulls += this.countNullsFieldOI.get(partialValue);
                partialValue = this.soi.getStructFieldData(partial, this.ndvField);
                String v = this.ndvFieldOI.getPrimitiveJavaObject(partialValue);
                NumDistinctValueEstimator o = new NumDistinctValueEstimator(v, myagg.numBitVectors);
                myagg.numDV.mergeEstimators(o);
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            DoubleStatsAgg myagg = (DoubleStatsAgg)agg;
            long numDV = 0L;
            if (myagg.numBitVectors != 0) {
                numDV = myagg.numDV.estimateNumDistinctValues();
            }
            ((Text)this.result[0]).set(myagg.columnType);
            ((DoubleWritable)this.result[1]).set(myagg.min);
            ((DoubleWritable)this.result[2]).set(myagg.max);
            ((LongWritable)this.result[3]).set(myagg.countNulls);
            ((LongWritable)this.result[4]).set(numDV);
            return this.result;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public static class DoubleStatsAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            public String columnType;
            public double min;
            public double max;
            public long countNulls;
            public DoubleNumDistinctValueEstimator numDV;
            public boolean firstItem;
            public int numBitVectors;

            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return model.primitive1() * 2 + model.primitive2() * 3 + model.lengthFor(this.columnType) + model.lengthFor(this.numDV);
            }
        }
    }

    public static class GenericUDAFLongStatsEvaluator
    extends GenericUDAFEvaluator {
        private transient PrimitiveObjectInspector inputOI;
        private transient PrimitiveObjectInspector numVectorsOI;
        private transient Object[] partialResult;
        private transient StructObjectInspector soi;
        private transient StructField minField;
        private transient WritableLongObjectInspector minFieldOI;
        private transient StructField maxField;
        private transient WritableLongObjectInspector maxFieldOI;
        private transient StructField countNullsField;
        private transient WritableLongObjectInspector countNullsFieldOI;
        private transient StructField ndvField;
        private transient WritableStringObjectInspector ndvFieldOI;
        private transient StructField numBitVectorsField;
        private transient WritableIntObjectInspector numBitVectorsFieldOI;
        private transient Object[] result;
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
                this.numVectorsOI = (PrimitiveObjectInspector)parameters[1];
            } else {
                this.soi = (StructObjectInspector)parameters[0];
                this.minField = this.soi.getStructFieldRef("Min");
                this.minFieldOI = (WritableLongObjectInspector)this.minField.getFieldObjectInspector();
                this.maxField = this.soi.getStructFieldRef("Max");
                this.maxFieldOI = (WritableLongObjectInspector)this.maxField.getFieldObjectInspector();
                this.countNullsField = this.soi.getStructFieldRef("CountNulls");
                this.countNullsFieldOI = (WritableLongObjectInspector)this.countNullsField.getFieldObjectInspector();
                this.ndvField = this.soi.getStructFieldRef("BitVector");
                this.ndvFieldOI = (WritableStringObjectInspector)this.ndvField.getFieldObjectInspector();
                this.numBitVectorsField = this.soi.getStructFieldRef("NumBitVectors");
                this.numBitVectorsFieldOI = (WritableIntObjectInspector)this.numBitVectorsField.getFieldObjectInspector();
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
                foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                ArrayList<String> fname = new ArrayList<String>();
                fname.add("ColumnType");
                fname.add("Min");
                fname.add("Max");
                fname.add("CountNulls");
                fname.add("BitVector");
                fname.add("NumBitVectors");
                this.partialResult = new Object[6];
                this.partialResult[0] = new Text();
                this.partialResult[1] = new LongWritable(0L);
                this.partialResult[2] = new LongWritable(0L);
                this.partialResult[3] = new LongWritable(0L);
                this.partialResult[4] = new Text();
                this.partialResult[5] = new IntWritable(0);
                return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
            }
            ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
            foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            ArrayList<String> fname = new ArrayList<String>();
            fname.add("ColumnType");
            fname.add("Min");
            fname.add("Max");
            fname.add("CountNulls");
            fname.add("NumDistinctValues");
            this.result = new Object[5];
            this.result[0] = new Text();
            this.result[1] = new LongWritable(0L);
            this.result[2] = new LongWritable(0L);
            this.result[3] = new LongWritable(0L);
            this.result[4] = new LongWritable(0L);
            return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            LongStatsAgg result = new LongStatsAgg();
            this.reset(result);
            return result;
        }

        public void initNDVEstimator(LongStatsAgg aggBuffer, int numBitVectors) {
            aggBuffer.numDV = new LongNumDistinctValueEstimator(numBitVectors);
            aggBuffer.numDV.reset();
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            LongStatsAgg myagg = (LongStatsAgg)agg;
            myagg.columnType = new String("Long");
            myagg.min = 0L;
            myagg.max = 0L;
            myagg.countNulls = 0L;
            myagg.firstItem = true;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block10: {
                Object p = parameters[0];
                LongStatsAgg myagg = (LongStatsAgg)agg;
                boolean emptyTable = false;
                if (parameters[1] == null) {
                    emptyTable = true;
                }
                if (myagg.firstItem) {
                    int numVectors = 0;
                    if (!emptyTable) {
                        numVectors = PrimitiveObjectInspectorUtils.getInt(parameters[1], this.numVectorsOI);
                    }
                    this.initNDVEstimator(myagg, numVectors);
                    myagg.firstItem = false;
                    myagg.numBitVectors = numVectors;
                }
                if (!emptyTable) {
                    if (p == null) {
                        ++myagg.countNulls;
                    } else {
                        try {
                            long v = PrimitiveObjectInspectorUtils.getLong(p, this.inputOI);
                            if (v < myagg.min) {
                                myagg.min = v;
                            }
                            if (v > myagg.max) {
                                myagg.max = v;
                            }
                            myagg.numDV.addToEstimator(v);
                        }
                        catch (NumberFormatException e) {
                            if (this.warned) break block10;
                            this.warned = true;
                            LOG.warn((Object)(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e)));
                            LOG.warn((Object)(this.getClass().getSimpleName() + " ignoring similar exceptions."));
                        }
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            LongStatsAgg myagg = (LongStatsAgg)agg;
            Text t = myagg.numDV.serialize();
            ((Text)this.partialResult[0]).set(myagg.columnType);
            ((LongWritable)this.partialResult[1]).set(myagg.min);
            ((LongWritable)this.partialResult[2]).set(myagg.max);
            ((LongWritable)this.partialResult[3]).set(myagg.countNulls);
            ((Text)this.partialResult[4]).set(t);
            ((IntWritable)this.partialResult[5]).set(myagg.numDV.getnumBitVectors());
            return this.partialResult;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                Object partialValue;
                LongStatsAgg myagg = (LongStatsAgg)agg;
                if (myagg.firstItem) {
                    partialValue = this.soi.getStructFieldData(partial, this.numBitVectorsField);
                    int numVectors = this.numBitVectorsFieldOI.get(partialValue);
                    this.initNDVEstimator(myagg, numVectors);
                    myagg.firstItem = false;
                    myagg.numBitVectors = numVectors;
                }
                if (myagg.min > this.minFieldOI.get(partialValue = this.soi.getStructFieldData(partial, this.minField))) {
                    myagg.min = this.minFieldOI.get(partialValue);
                }
                if (myagg.max < this.maxFieldOI.get(partialValue = this.soi.getStructFieldData(partial, this.maxField))) {
                    myagg.max = this.maxFieldOI.get(partialValue);
                }
                partialValue = this.soi.getStructFieldData(partial, this.countNullsField);
                myagg.countNulls += this.countNullsFieldOI.get(partialValue);
                partialValue = this.soi.getStructFieldData(partial, this.ndvField);
                String v = this.ndvFieldOI.getPrimitiveJavaObject(partialValue);
                NumDistinctValueEstimator o = new NumDistinctValueEstimator(v, myagg.numBitVectors);
                myagg.numDV.mergeEstimators(o);
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            LongStatsAgg myagg = (LongStatsAgg)agg;
            long numDV = 0L;
            if (myagg.numBitVectors != 0) {
                numDV = myagg.numDV.estimateNumDistinctValues();
            }
            ((Text)this.result[0]).set(myagg.columnType);
            ((LongWritable)this.result[1]).set(myagg.min);
            ((LongWritable)this.result[2]).set(myagg.max);
            ((LongWritable)this.result[3]).set(myagg.countNulls);
            ((LongWritable)this.result[4]).set(numDV);
            return this.result;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public static class LongStatsAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            public String columnType;
            public long min;
            public long max;
            public long countNulls;
            public LongNumDistinctValueEstimator numDV;
            public boolean firstItem;
            public int numBitVectors;

            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return model.primitive1() * 2 + model.primitive2() * 3 + model.lengthFor(this.columnType) + model.lengthFor(this.numDV);
            }
        }
    }

    public static class GenericUDAFBooleanStatsEvaluator
    extends GenericUDAFEvaluator {
        private transient PrimitiveObjectInspector inputOI;
        private transient Object[] partialResult;
        private transient StructObjectInspector soi;
        private transient StructField countTruesField;
        private transient WritableLongObjectInspector countTruesFieldOI;
        private transient StructField countFalsesField;
        private transient WritableLongObjectInspector countFalsesFieldOI;
        private transient StructField countNullsField;
        private transient WritableLongObjectInspector countNullsFieldOI;
        private transient Object[] result;
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
            } else {
                this.soi = (StructObjectInspector)parameters[0];
                this.countTruesField = this.soi.getStructFieldRef("CountTrues");
                this.countTruesFieldOI = (WritableLongObjectInspector)this.countTruesField.getFieldObjectInspector();
                this.countFalsesField = this.soi.getStructFieldRef("CountFalses");
                this.countFalsesFieldOI = (WritableLongObjectInspector)this.countFalsesField.getFieldObjectInspector();
                this.countNullsField = this.soi.getStructFieldRef("CountNulls");
                this.countNullsFieldOI = (WritableLongObjectInspector)this.countNullsField.getFieldObjectInspector();
            }
            ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
            foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            ArrayList<String> fname = new ArrayList<String>();
            fname.add("ColumnType");
            fname.add("CountTrues");
            fname.add("CountFalses");
            fname.add("CountNulls");
            this.partialResult = new Object[4];
            this.partialResult[0] = new Text();
            this.partialResult[1] = new LongWritable(0L);
            this.partialResult[2] = new LongWritable(0L);
            this.partialResult[3] = new LongWritable(0L);
            this.result = new Object[4];
            this.result[0] = new Text();
            this.result[1] = new LongWritable(0L);
            this.result[2] = new LongWritable(0L);
            this.result[3] = new LongWritable(0L);
            return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            BooleanStatsAgg result = new BooleanStatsAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BooleanStatsAgg myagg = (BooleanStatsAgg)agg;
            myagg.columnType = new String("Boolean");
            myagg.countTrues = 0L;
            myagg.countFalses = 0L;
            myagg.countNulls = 0L;
        }

        private void printDebugOutput(String functionName, GenericUDAFEvaluator.AggregationBuffer agg) {
            BooleanStatsAgg myagg = (BooleanStatsAgg)agg;
            LOG.debug((Object)functionName);
            LOG.debug((Object)"Count of True Values:");
            LOG.debug((Object)myagg.countTrues);
            LOG.debug((Object)"Count of False Values:");
            LOG.debug((Object)myagg.countFalses);
            LOG.debug((Object)"Count of Null Values:");
            LOG.debug((Object)myagg.countNulls);
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block9: {
                Object p = parameters[0];
                BooleanStatsAgg myagg = (BooleanStatsAgg)agg;
                boolean emptyTable = false;
                if (parameters[1] == null) {
                    emptyTable = true;
                }
                if (!emptyTable) {
                    if (p == null) {
                        ++myagg.countNulls;
                    } else {
                        try {
                            boolean v = PrimitiveObjectInspectorUtils.getBoolean(p, this.inputOI);
                            if (!v) {
                                ++myagg.countFalses;
                            } else if (v) {
                                ++myagg.countTrues;
                            }
                        }
                        catch (NumberFormatException e) {
                            if (this.warned) break block9;
                            this.warned = true;
                            LOG.warn((Object)(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e)));
                            LOG.warn((Object)(this.getClass().getSimpleName() + " ignoring similar exceptions."));
                        }
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BooleanStatsAgg myagg = (BooleanStatsAgg)agg;
            ((Text)this.partialResult[0]).set(myagg.columnType);
            ((LongWritable)this.partialResult[1]).set(myagg.countTrues);
            ((LongWritable)this.partialResult[2]).set(myagg.countFalses);
            ((LongWritable)this.partialResult[3]).set(myagg.countNulls);
            return this.partialResult;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                BooleanStatsAgg myagg = (BooleanStatsAgg)agg;
                Object partialCount = this.soi.getStructFieldData(partial, this.countTruesField);
                myagg.countTrues += this.countTruesFieldOI.get(partialCount);
                partialCount = this.soi.getStructFieldData(partial, this.countFalsesField);
                myagg.countFalses += this.countFalsesFieldOI.get(partialCount);
                partialCount = this.soi.getStructFieldData(partial, this.countNullsField);
                myagg.countNulls += this.countNullsFieldOI.get(partialCount);
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BooleanStatsAgg myagg = (BooleanStatsAgg)agg;
            ((Text)this.result[0]).set(myagg.columnType);
            ((LongWritable)this.result[1]).set(myagg.countTrues);
            ((LongWritable)this.result[2]).set(myagg.countFalses);
            ((LongWritable)this.result[3]).set(myagg.countNulls);
            return this.result;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public static class BooleanStatsAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            public String columnType;
            public long countTrues;
            public long countFalses;
            public long countNulls;

            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return model.primitive2() * 3 + model.lengthFor(this.columnType);
            }
        }
    }
}

