/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.jcraft.jsch;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.Buffer;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.Channel;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.ChannelForwardedTCPIP;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.ChannelX11;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.Cipher;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.Compression;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.HASH;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.HostKey;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.HostKeyRepository;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.IO;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.JSch;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.JSchAuthCancelException;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.JSchException;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.JSchPartialAuthException;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.KeyExchange;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.KnownHosts;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.MAC;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.Packet;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.PortWatcher;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.Proxy;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.Random;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.ServerSocketFactory;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.SocketFactory;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.UserAuth;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.UserAuthNone;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.UserInfo;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.Util;

public class Session
implements Runnable {
    private static final String version = "JSCH-0.1.42";
    static final int SSH_MSG_DISCONNECT = 1;
    static final int SSH_MSG_IGNORE = 2;
    static final int SSH_MSG_UNIMPLEMENTED = 3;
    static final int SSH_MSG_DEBUG = 4;
    static final int SSH_MSG_SERVICE_REQUEST = 5;
    static final int SSH_MSG_SERVICE_ACCEPT = 6;
    static final int SSH_MSG_KEXINIT = 20;
    static final int SSH_MSG_NEWKEYS = 21;
    static final int SSH_MSG_KEXDH_INIT = 30;
    static final int SSH_MSG_KEXDH_REPLY = 31;
    static final int SSH_MSG_KEX_DH_GEX_GROUP = 31;
    static final int SSH_MSG_KEX_DH_GEX_INIT = 32;
    static final int SSH_MSG_KEX_DH_GEX_REPLY = 33;
    static final int SSH_MSG_KEX_DH_GEX_REQUEST = 34;
    static final int SSH_MSG_GLOBAL_REQUEST = 80;
    static final int SSH_MSG_REQUEST_SUCCESS = 81;
    static final int SSH_MSG_REQUEST_FAILURE = 82;
    static final int SSH_MSG_CHANNEL_OPEN = 90;
    static final int SSH_MSG_CHANNEL_OPEN_CONFIRMATION = 91;
    static final int SSH_MSG_CHANNEL_OPEN_FAILURE = 92;
    static final int SSH_MSG_CHANNEL_WINDOW_ADJUST = 93;
    static final int SSH_MSG_CHANNEL_DATA = 94;
    static final int SSH_MSG_CHANNEL_EXTENDED_DATA = 95;
    static final int SSH_MSG_CHANNEL_EOF = 96;
    static final int SSH_MSG_CHANNEL_CLOSE = 97;
    static final int SSH_MSG_CHANNEL_REQUEST = 98;
    static final int SSH_MSG_CHANNEL_SUCCESS = 99;
    static final int SSH_MSG_CHANNEL_FAILURE = 100;
    private byte[] V_S;
    private byte[] V_C = "SSH-2.0-JSCH-0.1.42".getBytes();
    private byte[] I_C;
    private byte[] I_S;
    private byte[] K_S;
    private byte[] session_id;
    private byte[] IVc2s;
    private byte[] IVs2c;
    private byte[] Ec2s;
    private byte[] Es2c;
    private byte[] MACc2s;
    private byte[] MACs2c;
    private int seqi = 0;
    private int seqo = 0;
    String[] guess = null;
    private Cipher s2ccipher;
    private Cipher c2scipher;
    private MAC s2cmac;
    private MAC c2smac;
    private byte[] s2cmac_result1;
    private byte[] s2cmac_result2;
    private Compression deflater;
    private Compression inflater;
    private IO io;
    private Socket socket;
    private int timeout = 0;
    private boolean isConnected = false;
    private boolean isAuthed = false;
    private Thread connectThread = null;
    private Object lock = new Object();
    boolean x11_forwarding = false;
    boolean agent_forwarding = false;
    InputStream in = null;
    OutputStream out = null;
    static Random random;
    Buffer buf;
    Packet packet;
    SocketFactory socket_factory = null;
    private Hashtable config = null;
    private Proxy proxy = null;
    private UserInfo userinfo;
    private String hostKeyAlias = null;
    private int serverAliveInterval = 0;
    private int serverAliveCountMax = 1;
    protected boolean daemon_thread = false;
    String host = "127.0.0.1";
    int port = 22;
    String username = null;
    byte[] password = null;
    JSch jsch;
    private boolean in_kex = false;
    int[] uncompress_len = new int[1];
    private int s2ccipher_size = 8;
    private int c2scipher_size = 8;
    Runnable thread;
    private GlobalRequestReply grr = new GlobalRequestReply();
    private static final byte[] keepalivemsg;
    private HostKey hostkey = null;

    Session(JSch jSch) throws JSchException {
        this.jsch = jSch;
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
    }

    public void connect() throws JSchException {
        this.connect(this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(int n) throws JSchException {
        if (this.isConnected) {
            throw new JSchException("session is already connected");
        }
        this.io = new IO();
        if (random == null) {
            try {
                Class<?> clazz = Class.forName(this.getConfig("random"));
                random = (Random)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new JSchException(exception.toString(), exception);
            }
        }
        Packet.setRandom(random);
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "Connecting to " + this.host + " port " + this.port);
        }
        try {
            try {
                Object object;
                Object object2;
                boolean bl;
                int n2;
                Object object3;
                if (this.proxy == null) {
                    OutputStream outputStream;
                    if (this.socket_factory == null) {
                        this.socket = Util.createSocket(this.host, this.port, n);
                        object3 = this.socket.getInputStream();
                        outputStream = this.socket.getOutputStream();
                    } else {
                        this.socket = this.socket_factory.createSocket(this.host, this.port);
                        object3 = this.socket_factory.getInputStream(this.socket);
                        outputStream = this.socket_factory.getOutputStream(this.socket);
                    }
                    this.socket.setTcpNoDelay(true);
                    this.io.setInputStream((InputStream)object3);
                    this.io.setOutputStream(outputStream);
                } else {
                    object3 = this.proxy;
                    synchronized (object3) {
                        this.proxy.connect(this.socket_factory, this.host, this.port, n);
                        this.io.setInputStream(this.proxy.getInputStream());
                        this.io.setOutputStream(this.proxy.getOutputStream());
                        this.socket = this.proxy.getSocket();
                    }
                }
                if (n > 0 && this.socket != null) {
                    this.socket.setSoTimeout(n);
                }
                this.isConnected = true;
                if (JSch.getLogger().isEnabled(1)) {
                    JSch.getLogger().log(1, "Connection established");
                }
                this.jsch.addSession(this);
                object3 = new byte[this.V_C.length + 1];
                System.arraycopy(this.V_C, 0, object3, 0, this.V_C.length);
                object3[((Object)object3).length - 1] = 10;
                this.io.put((byte[])object3, 0, ((Object)object3).length);
                do {
                    int n3 = 0;
                    for (n2 = 0; n2 < this.buf.buffer.length; ++n2) {
                        n3 = this.io.getByte();
                        if (n3 < 0) break;
                        this.buf.buffer[n2] = (byte)n3;
                        if (n3 != 10) continue;
                    }
                    if (n3 < 0) {
                        throw new JSchException("connection is closed by foreign host");
                    }
                    if (this.buf.buffer[n2 - 1] != 10 || --n2 <= 0 || this.buf.buffer[n2 - 1] != 13) continue;
                    --n2;
                } while (n2 <= 3 || n2 != this.buf.buffer.length && (this.buf.buffer[0] != 83 || this.buf.buffer[1] != 83 || this.buf.buffer[2] != 72 || this.buf.buffer[3] != 45));
                if (n2 == this.buf.buffer.length || n2 < 7 || this.buf.buffer[4] == 49 && this.buf.buffer[6] != 57) {
                    throw new JSchException("invalid server's version string");
                }
                this.V_S = new byte[n2];
                System.arraycopy(this.buf.buffer, 0, this.V_S, 0, n2);
                if (JSch.getLogger().isEnabled(1)) {
                    JSch.getLogger().log(1, "Remote version string: " + new String(this.V_S));
                    JSch.getLogger().log(1, "Local version string: " + new String(this.V_C));
                }
                this.send_kexinit();
                this.buf = this.read(this.buf);
                if (this.buf.getCommand() != 20) {
                    throw new JSchException("invalid protocol: " + this.buf.getCommand());
                }
                if (JSch.getLogger().isEnabled(1)) {
                    JSch.getLogger().log(1, "SSH_MSG_KEXINIT received");
                }
                object3 = this.receive_kexinit(this.buf);
                do {
                    this.buf = this.read(this.buf);
                    if (((KeyExchange)object3).getState() == this.buf.getCommand()) {
                        bl = ((KeyExchange)object3).next(this.buf);
                        if (bl) continue;
                        this.in_kex = false;
                        throw new JSchException("verify: " + bl);
                    }
                    this.in_kex = false;
                    throw new JSchException("invalid protocol(kex): " + this.buf.getCommand());
                } while (((KeyExchange)object3).getState() != 0);
                try {
                    this.checkHost(this.host, this.port, (KeyExchange)object3);
                }
                catch (JSchException jSchException) {
                    this.in_kex = false;
                    throw jSchException;
                }
                this.send_newkeys();
                this.buf = this.read(this.buf);
                if (this.buf.getCommand() == 21) {
                    if (JSch.getLogger().isEnabled(1)) {
                        JSch.getLogger().log(1, "SSH_MSG_NEWKEYS received");
                    }
                } else {
                    this.in_kex = false;
                    throw new JSchException("invalid protocol(newkyes): " + this.buf.getCommand());
                }
                this.receive_newkeys(this.buf, (KeyExchange)object3);
                bl = false;
                boolean bl2 = false;
                UserAuth userAuth = null;
                try {
                    object2 = Class.forName(this.getConfig("userauth.none"));
                    userAuth = (UserAuth)((Class)object2).newInstance();
                }
                catch (Exception exception) {
                    throw new JSchException(exception.toString(), exception);
                }
                bl = userAuth.start(this);
                object2 = this.getConfig("PreferredAuthentications");
                String[] stringArray = Util.split((String)object2, ",");
                Object object4 = null;
                if (!bl) {
                    object4 = ((UserAuthNone)userAuth).getMethods();
                    object4 = object4 != null ? ((String)object4).toLowerCase() : object2;
                }
                String[] stringArray2 = Util.split(object4, ",");
                int n4 = 0;
                while (!bl && stringArray != null && n4 < stringArray.length) {
                    block62: {
                        Object object5;
                        object = stringArray[n4++];
                        boolean bl3 = false;
                        int n5 = 0;
                        while (n5 < stringArray2.length) {
                            if (stringArray2[n5].equals(object)) {
                                bl3 = true;
                                break;
                            }
                            ++n5;
                        }
                        if (!bl3) continue;
                        if (JSch.getLogger().isEnabled(1)) {
                            object5 = "Authentications that can continue: ";
                            int n6 = n4 - 1;
                            while (n6 < stringArray.length) {
                                object5 = (String)object5 + stringArray[n6];
                                if (n6 + 1 < stringArray.length) {
                                    object5 = (String)object5 + ",";
                                }
                                ++n6;
                            }
                            JSch.getLogger().log(1, (String)object5);
                            JSch.getLogger().log(1, "Next authentication method: " + (String)object);
                        }
                        userAuth = null;
                        try {
                            object5 = null;
                            if (this.getConfig("userauth." + (String)object) != null) {
                                object5 = Class.forName(this.getConfig("userauth." + (String)object));
                                userAuth = (UserAuth)((Class)object5).newInstance();
                            }
                        }
                        catch (Exception exception) {
                            if (!JSch.getLogger().isEnabled(2)) break block62;
                            JSch.getLogger().log(2, "failed to load " + (String)object + " method");
                        }
                    }
                    if (userAuth == null) continue;
                    bl2 = false;
                    try {
                        bl = userAuth.start(this);
                        if (!bl || !JSch.getLogger().isEnabled(1)) continue;
                        JSch.getLogger().log(1, "Authentication succeeded (" + (String)object + ").");
                    }
                    catch (JSchAuthCancelException jSchAuthCancelException) {
                        bl2 = true;
                    }
                    catch (JSchPartialAuthException jSchPartialAuthException) {
                        object4 = jSchPartialAuthException.getMethods();
                        stringArray2 = Util.split((String)object4, ",");
                        n4 = 0;
                        bl2 = false;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        break;
                    }
                }
                if (!bl) {
                    if (bl2) {
                        throw new JSchException("Auth cancel");
                    }
                    throw new JSchException("Auth fail");
                }
                if (n > 0 || this.timeout > 0) {
                    this.socket.setSoTimeout(this.timeout);
                }
                this.isAuthed = true;
                object = this.lock;
                synchronized (object) {
                    if (this.isConnected) {
                        this.connectThread = new Thread(this);
                        this.connectThread.setName("Connect thread " + this.host + " session");
                        if (this.daemon_thread) {
                            this.connectThread.setDaemon(this.daemon_thread);
                        }
                        this.connectThread.start();
                    }
                }
                Object var22_32 = null;
            }
            catch (Exception exception) {
                this.in_kex = false;
                if (this.isConnected) {
                    try {
                        this.packet.reset();
                        this.buf.putByte((byte)1);
                        this.buf.putInt(3);
                        this.buf.putString(exception.toString().getBytes());
                        this.buf.putString("en".getBytes());
                        this.write(this.packet);
                        this.disconnect();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                this.isConnected = false;
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof JSchException) {
                    throw (JSchException)exception;
                }
                throw new JSchException("Session.connect: " + exception);
            }
        }
        catch (Throwable throwable) {
            Object var22_33 = null;
            Util.bzero(this.password);
            this.password = null;
            throw throwable;
        }
        Util.bzero(this.password);
        this.password = null;
    }

    private KeyExchange receive_kexinit(Buffer buffer) throws Exception {
        int n = buffer.getInt();
        if (n != buffer.getLength()) {
            buffer.getByte();
            this.I_S = new byte[buffer.index - 5];
        } else {
            this.I_S = new byte[n - 1 - buffer.getByte()];
        }
        System.arraycopy(buffer.buffer, buffer.s, this.I_S, 0, this.I_S.length);
        if (!this.in_kex) {
            this.send_kexinit();
        }
        this.guess = KeyExchange.guess(this.I_S, this.I_C);
        if (this.guess == null) {
            throw new JSchException("Algorithm negotiation fail");
        }
        if (!this.isAuthed && (this.guess[2].equals("none") || this.guess[3].equals("none"))) {
            throw new JSchException("NONE Cipher should not be chosen before authentification is successed.");
        }
        KeyExchange keyExchange = null;
        try {
            Class<?> clazz = Class.forName(this.getConfig(this.guess[0]));
            keyExchange = (KeyExchange)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JSchException(exception.toString(), exception);
        }
        keyExchange.init(this, this.V_S, this.V_C, this.I_S, this.I_C);
        return keyExchange;
    }

    public void rekey() throws Exception {
        this.send_kexinit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send_kexinit() throws Exception {
        if (this.in_kex) {
            return;
        }
        String string = this.getConfig("cipher.c2s");
        String string2 = this.getConfig("cipher.s2c");
        String[] stringArray = this.checkCiphers(this.getConfig("CheckCiphers"));
        if (stringArray != null && stringArray.length > 0) {
            string = Util.diffString(string, stringArray);
            string2 = Util.diffString(string2, stringArray);
            if (string == null || string2 == null) {
                throw new JSchException("There are not any available ciphers.");
            }
        }
        this.in_kex = true;
        Buffer buffer = new Buffer();
        Packet packet = new Packet(buffer);
        packet.reset();
        buffer.putByte((byte)20);
        Random random = Session.random;
        synchronized (random) {
            Session.random.fill(buffer.buffer, buffer.index, 16);
            buffer.skip(16);
        }
        buffer.putString(this.getConfig("kex").getBytes());
        buffer.putString(this.getConfig("server_host_key").getBytes());
        buffer.putString(string.getBytes());
        buffer.putString(string2.getBytes());
        buffer.putString(this.getConfig("mac.c2s").getBytes());
        buffer.putString(this.getConfig("mac.s2c").getBytes());
        buffer.putString(this.getConfig("compression.c2s").getBytes());
        buffer.putString(this.getConfig("compression.s2c").getBytes());
        buffer.putString(this.getConfig("lang.c2s").getBytes());
        buffer.putString(this.getConfig("lang.s2c").getBytes());
        buffer.putByte((byte)0);
        buffer.putInt(0);
        buffer.setOffSet(5);
        this.I_C = new byte[buffer.getLength()];
        buffer.getByte(this.I_C);
        this.write(packet);
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "SSH_MSG_KEXINIT sent");
        }
    }

    private void send_newkeys() throws Exception {
        this.packet.reset();
        this.buf.putByte((byte)21);
        this.write(this.packet);
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "SSH_MSG_NEWKEYS sent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHost(String string, int n, KeyExchange keyExchange) throws JSchException {
        String string2;
        HostKeyRepository hostKeyRepository;
        String string3 = this.getConfig("StrictHostKeyChecking");
        if (this.hostKeyAlias != null) {
            string = this.hostKeyAlias;
        }
        byte[] byArray = keyExchange.getHostKey();
        String string4 = keyExchange.getKeyType();
        String string5 = keyExchange.getFingerPrint();
        if (this.hostKeyAlias == null && n != 22) {
            string = "[" + string + "]:" + n;
        }
        HostKeyRepository hostKeyRepository2 = this.jsch.getHostKeyRepository();
        int n2 = 0;
        HostKeyRepository hostKeyRepository3 = hostKeyRepository2;
        synchronized (hostKeyRepository3) {
            n2 = hostKeyRepository2.check(string, byArray);
        }
        boolean bl = false;
        if ((string3.equals("ask") || string3.equals("yes")) && n2 == 2) {
            Object object;
            String string6 = null;
            hostKeyRepository = hostKeyRepository2;
            synchronized (hostKeyRepository) {
                string6 = hostKeyRepository2.getKnownHostsRepositoryID();
            }
            if (string6 == null) {
                string6 = "known_hosts";
            }
            boolean bl2 = false;
            if (this.userinfo != null) {
                object = "WARNING: REMOTE HOST IDENTIFICATION HAS CHANGED!\nIT IS POSSIBLE THAT SOMEONE IS DOING SOMETHING NASTY!\nSomeone could be eavesdropping on you right now (man-in-the-middle attack)!\nIt is also possible that the " + string4 + " host key has just been changed.\n" + "The fingerprint for the " + string4 + " key sent by the remote host is\n" + string5 + ".\n" + "Please contact your system administrator.\n" + "Add correct host key in " + string6 + " to get rid of this message.";
                if (string3.equals("ask")) {
                    bl2 = this.userinfo.promptYesNo((String)object + "\nDo you want to delete the old key and insert the new key?");
                } else {
                    this.userinfo.showMessage((String)object);
                }
            }
            if (!bl2) {
                throw new JSchException("HostKey has been changed: " + string);
            }
            object = hostKeyRepository2;
            synchronized (object) {
                hostKeyRepository2.remove(string, string4.equals("DSA") ? "ssh-dss" : "ssh-rsa", null);
                bl = true;
            }
        }
        if ((string3.equals("ask") || string3.equals("yes")) && n2 != 0 && !bl) {
            if (string3.equals("yes")) {
                throw new JSchException("reject HostKey: " + this.host);
            }
            if (this.userinfo != null) {
                boolean bl3 = this.userinfo.promptYesNo("The authenticity of host '" + this.host + "' can't be established.\n" + string4 + " key fingerprint is " + string5 + ".\n" + "Are you sure you want to continue connecting?");
                if (!bl3) {
                    throw new JSchException("reject HostKey: " + this.host);
                }
                bl = true;
            } else {
                if (n2 == 1) {
                    throw new JSchException("UnknownHostKey: " + this.host + ". " + string4 + " key fingerprint is " + string5);
                }
                throw new JSchException("HostKey has been changed: " + this.host);
            }
        }
        if (string3.equals("no") && 1 == n2) {
            bl = true;
        }
        if (n2 == 0 && JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "Host '" + this.host + "' is known and mathces the " + string4 + " host key");
        }
        if (bl && JSch.getLogger().isEnabled(2)) {
            JSch.getLogger().log(2, "Permanently added '" + this.host + "' (" + string4 + ") to the list of known hosts.");
        }
        this.hostkey = (string2 = this.getConfig("HashKnownHosts")).equals("yes") && hostKeyRepository2 instanceof KnownHosts ? ((KnownHosts)hostKeyRepository2).createHashedHostKey(string, byArray) : new HostKey(string, byArray);
        if (bl) {
            hostKeyRepository = hostKeyRepository2;
            synchronized (hostKeyRepository) {
                hostKeyRepository2.add(this.hostkey, this.userinfo);
            }
        }
    }

    public Channel openChannel(String string) throws JSchException {
        if (!this.isConnected) {
            throw new JSchException("session is down");
        }
        try {
            Channel channel = Channel.getChannel(string);
            this.addChannel(channel);
            channel.init();
            return channel;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(Packet packet) throws Exception {
        if (this.deflater != null) {
            packet.buffer.index = this.deflater.compress(packet.buffer.buffer, 5, packet.buffer.index);
        }
        if (this.c2scipher != null) {
            packet.padding(this.c2scipher_size);
            byte by = packet.buffer.buffer[4];
            Random random = Session.random;
            synchronized (random) {
                Session.random.fill(packet.buffer.buffer, packet.buffer.index - by, by);
            }
        } else {
            packet.padding(8);
        }
        if (this.c2smac != null) {
            this.c2smac.update(this.seqo);
            this.c2smac.update(packet.buffer.buffer, 0, packet.buffer.index);
            this.c2smac.doFinal(packet.buffer.buffer, packet.buffer.index);
        }
        if (this.c2scipher != null) {
            byte[] byArray = packet.buffer.buffer;
            this.c2scipher.update(byArray, 0, packet.buffer.index, byArray, 0);
        }
        if (this.c2smac != null) {
            packet.buffer.skip(this.c2smac.getBlockSize());
        }
    }

    public Buffer read(Buffer buffer) throws Exception {
        block17: {
            int n;
            Object object;
            int n2 = 0;
            while (true) {
                Object object2;
                buffer.reset();
                this.io.getByte(buffer.buffer, buffer.index, this.s2ccipher_size);
                buffer.index += this.s2ccipher_size;
                if (this.s2ccipher != null) {
                    this.s2ccipher.update(buffer.buffer, 0, this.s2ccipher_size, buffer.buffer, 0);
                }
                if ((n2 = buffer.buffer[0] << 24 & 0xFF000000 | buffer.buffer[1] << 16 & 0xFF0000 | buffer.buffer[2] << 8 & 0xFF00 | buffer.buffer[3] & 0xFF) < 5 || n2 > 32764) {
                    throw new IOException("invalid data");
                }
                if (buffer.index + (n2 = n2 + 4 - this.s2ccipher_size) > buffer.buffer.length) {
                    object2 = new byte[buffer.index + n2];
                    System.arraycopy(buffer.buffer, 0, object2, 0, buffer.index);
                    buffer.buffer = object2;
                }
                if (n2 % this.s2ccipher_size != 0) {
                    object2 = "Bad packet length " + n2;
                    if (JSch.getLogger().isEnabled(4)) {
                        JSch.getLogger().log(4, (String)object2);
                    }
                    this.packet.reset();
                    buffer.putByte((byte)1);
                    buffer.putInt(3);
                    buffer.putString(((String)object2).getBytes());
                    buffer.putString("en".getBytes());
                    this.write(this.packet);
                    this.disconnect();
                    throw new JSchException("SSH_MSG_DISCONNECT: " + (String)object2);
                }
                if (n2 > 0) {
                    this.io.getByte(buffer.buffer, buffer.index, n2);
                    buffer.index += n2;
                    if (this.s2ccipher != null) {
                        this.s2ccipher.update(buffer.buffer, this.s2ccipher_size, n2, buffer.buffer, this.s2ccipher_size);
                    }
                }
                if (this.s2cmac != null) {
                    this.s2cmac.update(this.seqi);
                    this.s2cmac.update(buffer.buffer, 0, buffer.index);
                    this.s2cmac.doFinal(this.s2cmac_result1, 0);
                    this.io.getByte(this.s2cmac_result2, 0, this.s2cmac_result2.length);
                    if (!Arrays.equals(this.s2cmac_result1, this.s2cmac_result2)) {
                        throw new IOException("MAC Error");
                    }
                }
                ++this.seqi;
                if (this.inflater != null) {
                    byte by = buffer.buffer[4];
                    this.uncompress_len[0] = buffer.index - 5 - by;
                    object = this.inflater.uncompress(buffer.buffer, 5, this.uncompress_len);
                    if (object == null) {
                        System.err.println("fail in inflater");
                        break block17;
                    }
                    buffer.buffer = object;
                    buffer.index = 5 + this.uncompress_len[0];
                }
                if ((n = buffer.getCommand() & 0xFF) == 1) {
                    buffer.rewind();
                    buffer.getInt();
                    buffer.getShort();
                    int n3 = buffer.getInt();
                    byte[] byArray = buffer.getString();
                    byte[] byArray2 = buffer.getString();
                    throw new JSchException("SSH_MSG_DISCONNECT: " + n3 + " " + new String(byArray) + " " + new String(byArray2));
                }
                if (n == 2) continue;
                if (n == 3) {
                    buffer.rewind();
                    buffer.getInt();
                    buffer.getShort();
                    int n4 = buffer.getInt();
                    if (!JSch.getLogger().isEnabled(1)) continue;
                    JSch.getLogger().log(1, "Received SSH_MSG_UNIMPLEMENTED for " + n4);
                    continue;
                }
                if (n == 4) {
                    buffer.rewind();
                    buffer.getInt();
                    buffer.getShort();
                    continue;
                }
                if (n != 93) break;
                buffer.rewind();
                buffer.getInt();
                buffer.getShort();
                object = Channel.getChannel(buffer.getInt(), this);
                if (object == null) continue;
                object.addRemoteWindowSize(buffer.getInt());
            }
            if (n == 52) {
                this.isAuthed = true;
                if (this.inflater == null && this.deflater == null) {
                    object = this.guess[6];
                    this.initDeflater((String)object);
                    object = this.guess[7];
                    this.initInflater((String)object);
                }
            }
        }
        buffer.rewind();
        return buffer;
    }

    byte[] getSessionId() {
        return this.session_id;
    }

    private void receive_newkeys(Buffer buffer, KeyExchange keyExchange) throws Exception {
        this.updateKeys(keyExchange);
        this.in_kex = false;
    }

    private void updateKeys(KeyExchange keyExchange) throws Exception {
        int n;
        byte[] byArray = keyExchange.getK();
        byte[] byArray2 = keyExchange.getH();
        HASH hASH = keyExchange.getHash();
        if (this.session_id == null) {
            this.session_id = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.session_id, 0, byArray2.length);
        }
        this.buf.reset();
        this.buf.putMPInt(byArray);
        this.buf.putByte(byArray2);
        this.buf.putByte((byte)65);
        this.buf.putByte(this.session_id);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.IVc2s = hASH.digest();
        int n2 = n = this.buf.index - this.session_id.length - 1;
        this.buf.buffer[n2] = (byte)(this.buf.buffer[n2] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.IVs2c = hASH.digest();
        int n3 = n;
        this.buf.buffer[n3] = (byte)(this.buf.buffer[n3] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.Ec2s = hASH.digest();
        int n4 = n;
        this.buf.buffer[n4] = (byte)(this.buf.buffer[n4] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.Es2c = hASH.digest();
        int n5 = n;
        this.buf.buffer[n5] = (byte)(this.buf.buffer[n5] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.MACc2s = hASH.digest();
        int n6 = n;
        this.buf.buffer[n6] = (byte)(this.buf.buffer[n6] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.MACs2c = hASH.digest();
        try {
            byte[] byArray3;
            byte[] byArray4;
            String string = this.guess[3];
            Class<?> clazz = Class.forName(this.getConfig(string));
            this.s2ccipher = (Cipher)clazz.newInstance();
            while (this.s2ccipher.getBlockSize() > this.Es2c.length) {
                this.buf.reset();
                this.buf.putMPInt(byArray);
                this.buf.putByte(byArray2);
                this.buf.putByte(this.Es2c);
                hASH.update(this.buf.buffer, 0, this.buf.index);
                byArray4 = hASH.digest();
                byArray3 = new byte[this.Es2c.length + byArray4.length];
                System.arraycopy(this.Es2c, 0, byArray3, 0, this.Es2c.length);
                System.arraycopy(byArray4, 0, byArray3, this.Es2c.length, byArray4.length);
                this.Es2c = byArray3;
            }
            this.s2ccipher.init(1, this.Es2c, this.IVs2c);
            this.s2ccipher_size = this.s2ccipher.getIVSize();
            string = this.guess[5];
            clazz = Class.forName(this.getConfig(string));
            this.s2cmac = (MAC)clazz.newInstance();
            this.s2cmac.init(this.MACs2c);
            this.s2cmac_result1 = new byte[this.s2cmac.getBlockSize()];
            this.s2cmac_result2 = new byte[this.s2cmac.getBlockSize()];
            string = this.guess[2];
            clazz = Class.forName(this.getConfig(string));
            this.c2scipher = (Cipher)clazz.newInstance();
            while (this.c2scipher.getBlockSize() > this.Ec2s.length) {
                this.buf.reset();
                this.buf.putMPInt(byArray);
                this.buf.putByte(byArray2);
                this.buf.putByte(this.Ec2s);
                hASH.update(this.buf.buffer, 0, this.buf.index);
                byArray4 = hASH.digest();
                byArray3 = new byte[this.Ec2s.length + byArray4.length];
                System.arraycopy(this.Ec2s, 0, byArray3, 0, this.Ec2s.length);
                System.arraycopy(byArray4, 0, byArray3, this.Ec2s.length, byArray4.length);
                this.Ec2s = byArray3;
            }
            this.c2scipher.init(0, this.Ec2s, this.IVc2s);
            this.c2scipher_size = this.c2scipher.getIVSize();
            string = this.guess[4];
            clazz = Class.forName(this.getConfig(string));
            this.c2smac = (MAC)clazz.newInstance();
            this.c2smac.init(this.MACc2s);
            string = this.guess[6];
            this.initDeflater(string);
            string = this.guess[7];
            this.initInflater(string);
        }
        catch (Exception exception) {
            if (exception instanceof JSchException) {
                throw exception;
            }
            throw new JSchException(exception.toString(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Packet packet, Channel channel, int n) throws Exception {
        while (true) {
            if (this.in_kex) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Channel channel2 = channel;
            synchronized (channel2) {
                if (channel.rwsize >= n) {
                    channel.rwsize -= n;
                    break;
                }
            }
            if (channel.close || !channel.isConnected()) {
                throw new IOException("channel is broken");
            }
            boolean bl = false;
            int n2 = 0;
            byte by = 0;
            int n3 = -1;
            Channel channel3 = channel;
            synchronized (channel3) {
                if (channel.rwsize > 0) {
                    int n4 = channel.rwsize;
                    if (n4 > n) {
                        n4 = n;
                    }
                    if (n4 != n) {
                        n2 = packet.shift(n4, this.c2smac != null ? this.c2smac.getBlockSize() : 0);
                    }
                    by = packet.buffer.getCommand();
                    n3 = channel.getRecipient();
                    n -= n4;
                    channel.rwsize -= n4;
                    bl = true;
                }
            }
            if (bl) {
                this._write(packet);
                if (n == 0) {
                    return;
                }
                packet.unshift(by, n3, n2, n);
            }
            Channel channel4 = channel;
            synchronized (channel4) {
                Object var13_16;
                if (this.in_kex) {
                    continue;
                }
                if (channel.rwsize >= n) {
                    channel.rwsize -= n;
                    break;
                }
                try {
                    try {
                        ++channel.notifyme;
                        channel.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        var13_16 = null;
                        --channel.notifyme;
                    }
                    var13_16 = null;
                    --channel.notifyme;
                }
                catch (Throwable throwable) {
                    var13_16 = null;
                    --channel.notifyme;
                    throw throwable;
                }
            }
        }
        this._write(packet);
    }

    public void write(Packet packet) throws Exception {
        while (this.in_kex) {
            byte by = packet.buffer.getCommand();
            if (by == 20 || by == 21 || by == 30 || by == 31 || by == 31 || by == 32 || by == 33 || by == 34 || by == 1) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._write(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _write(Packet packet) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.encode(packet);
            if (this.io != null) {
                this.io.put(packet);
                ++this.seqo;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block37: {
            this.thread = this;
            var1_1 = new Buffer();
            var2_2 = new Packet(var1_1);
            var3_3 = 0;
            var4_4 = new int[1];
            var5_5 = new int[1];
            var6_6 = null;
            var7_7 = 0;
            try lbl-1000:
            // 33 sources

            {
                block28: while (this.isConnected && this.thread != null) {
                    try {
                        var1_1 = this.read(var1_1);
                        var7_7 = 0;
                    }
                    catch (InterruptedIOException var8_8) {
                        if (!this.in_kex && var7_7 < this.serverAliveCountMax) {
                            this.sendKeepAliveMsg();
                            ++var7_7;
                            continue;
                        }
                        throw var8_8;
                    }
                    var8_9 = var1_1.getCommand() & 255;
                    if (var6_6 != null && var6_6.getState() == var8_9) {
                        var9_12 = var6_6.next(var1_1);
                        if (var9_12 != 0) continue;
                        throw new JSchException("verify: " + (boolean)var9_12);
                    }
                    switch (var8_9) {
                        case 20: {
                            var6_6 = this.receive_kexinit(var1_1);
                            ** break;
                        }
                        case 21: {
                            this.send_newkeys();
                            this.receive_newkeys(var1_1, var6_6);
                            var6_6 = null;
                            ** break;
                        }
                        case 94: {
                            var1_1.getInt();
                            var1_1.getByte();
                            var1_1.getByte();
                            var3_3 = var1_1.getInt();
                            var10_15 = Channel.getChannel(var3_3, this);
                            var11_16 = var1_1.getString(var4_4, var5_5);
                            if (var10_15 == null || var5_5[0] == 0) continue block28;
                            try {
                                var10_15.write(var11_16, var4_4[0], var5_5[0]);
                            }
                            catch (Exception var9_13) {
                                try {
                                    var10_15.disconnect();
                                }
                                catch (Exception var12_17) {}
                                continue block28;
                            }
                            var9_12 = var5_5[0];
                            var10_15.setLocalWindowSize(var10_15.lwsize - var9_12);
                            if (var10_15.lwsize >= var10_15.lwsize_max / 2) continue block28;
                            var2_2.reset();
                            var1_1.putByte((byte)93);
                            var1_1.putInt(var10_15.getRecipient());
                            var1_1.putInt(var10_15.lwsize_max - var10_15.lwsize);
                            this.write(var2_2);
                            var10_15.setLocalWindowSize(var10_15.lwsize_max);
                            ** break;
                        }
                        case 95: {
                            var1_1.getInt();
                            var1_1.getShort();
                            var3_3 = var1_1.getInt();
                            var10_15 = Channel.getChannel(var3_3, this);
                            var1_1.getInt();
                            var11_16 = var1_1.getString(var4_4, var5_5);
                            if (var10_15 == null || var5_5[0] == 0) continue block28;
                            var10_15.write_ext(var11_16, var4_4[0], var5_5[0]);
                            var9_12 = var5_5[0];
                            var10_15.setLocalWindowSize(var10_15.lwsize - var9_12);
                            if (var10_15.lwsize >= var10_15.lwsize_max / 2) continue block28;
                            var2_2.reset();
                            var1_1.putByte((byte)93);
                            var1_1.putInt(var10_15.getRecipient());
                            var1_1.putInt(var10_15.lwsize_max - var10_15.lwsize);
                            this.write(var2_2);
                            var10_15.setLocalWindowSize(var10_15.lwsize_max);
                            ** break;
                        }
                        case 93: {
                            var1_1.getInt();
                            var1_1.getShort();
                            var3_3 = var1_1.getInt();
                            var10_15 = Channel.getChannel(var3_3, this);
                            if (var10_15 == null) continue block28;
                            var10_15.addRemoteWindowSize(var1_1.getInt());
                            ** break;
                        }
                        case 96: {
                            var1_1.getInt();
                            var1_1.getShort();
                            var3_3 = var1_1.getInt();
                            var10_15 = Channel.getChannel(var3_3, this);
                            if (var10_15 == null) continue block28;
                            var10_15.eof_remote();
                            ** break;
                        }
                        case 97: {
                            var1_1.getInt();
                            var1_1.getShort();
                            var3_3 = var1_1.getInt();
                            var10_15 = Channel.getChannel(var3_3, this);
                            if (var10_15 == null) continue block28;
                            var10_15.disconnect();
                            ** break;
                        }
                        case 91: {
                            var1_1.getInt();
                            var1_1.getShort();
                            var3_3 = var1_1.getInt();
                            var10_15 = Channel.getChannel(var3_3, this);
                            if (var10_15 == null) {
                                // empty if block
                            }
                            var12_18 = var1_1.getInt();
                            var13_19 = var1_1.getInt();
                            var14_20 = var1_1.getInt();
                            var10_15.setRemoteWindowSize(var13_19);
                            var10_15.setRemotePacketSize(var14_20);
                            var10_15.setRecipient(var12_18);
                            ** break;
                        }
                        case 92: {
                            var1_1.getInt();
                            var1_1.getShort();
                            var3_3 = var1_1.getInt();
                            var10_15 = Channel.getChannel(var3_3, this);
                            if (var10_15 == null) {
                                // empty if block
                            }
                            var10_15.exitstatus = var15_21 = var1_1.getInt();
                            var10_15.close = true;
                            var10_15.eof_remote = true;
                            var10_15.setRecipient(0);
                            ** break;
                        }
                        case 98: {
                            var1_1.getInt();
                            var1_1.getShort();
                            var3_3 = var1_1.getInt();
                            var11_16 = var1_1.getString();
                            v0 = var16_22 = var1_1.getByte() != 0;
                            var10_15 = Channel.getChannel(var3_3, this);
                            if (var10_15 == null) continue block28;
                            var17_23 = 100;
                            if (new String(var11_16).equals("exit-status")) {
                                var3_3 = var1_1.getInt();
                                var10_15.setExitStatus(var3_3);
                                var17_23 = 99;
                            }
                            if (!var16_22) continue block28;
                            var2_2.reset();
                            var1_1.putByte((byte)var17_23);
                            var1_1.putInt(var10_15.getRecipient());
                            this.write(var2_2);
                            ** break;
                        }
                        case 90: {
                            var1_1.getInt();
                            var1_1.getShort();
                            var11_16 = var1_1.getString();
                            var17_24 = new String(var11_16);
                            if (!("forwarded-tcpip".equals(var17_24) || "x11".equals(var17_24) && this.x11_forwarding || "auth-agent@openssh.com".equals(var17_24) && this.agent_forwarding)) {
                                var2_2.reset();
                                var1_1.putByte((byte)92);
                                var1_1.putInt(var1_1.getInt());
                                var1_1.putInt(1);
                                var1_1.putString("".getBytes());
                                var1_1.putString("".getBytes());
                                this.write(var2_2);
                            } else {
                                var10_15 = Channel.getChannel(var17_24);
                                this.addChannel(var10_15);
                                var10_15.getData(var1_1);
                                var10_15.init();
                                var18_25 = new Thread(var10_15);
                                var18_25.setName("Channel " + var17_24 + " " + this.host);
                                if (this.daemon_thread) {
                                    var18_25.setDaemon(this.daemon_thread);
                                }
                                var18_25.start();
                                ** break;
                            }
                        }
                        case 99: {
                            var1_1.getInt();
                            var1_1.getShort();
                            var3_3 = var1_1.getInt();
                            var10_15 = Channel.getChannel(var3_3, this);
                            if (var10_15 == null) continue block28;
                            var10_15.reply = 1;
                            ** break;
                        }
                        case 100: {
                            var1_1.getInt();
                            var1_1.getShort();
                            var3_3 = var1_1.getInt();
                            var10_15 = Channel.getChannel(var3_3, this);
                            if (var10_15 == null) continue block28;
                            var10_15.reply = 0;
                            ** break;
                        }
                        case 80: {
                            var1_1.getInt();
                            var1_1.getShort();
                            var11_16 = var1_1.getString();
                            var16_22 = var1_1.getByte() != 0;
                            if (!var16_22) continue block28;
                            var2_2.reset();
                            var1_1.putByte((byte)82);
                            this.write(var2_2);
                            ** break;
                        }
                        case 81: 
                        case 82: {
                            var18_25 = this.grr.getThread();
                            if (var18_25 == null) continue block28;
                            this.grr.setReply(var8_9 == 81 ? 1 : 0);
                            var18_25.interrupt();
                            ** break;
                        }
                    }
                    throw new IOException("Unknown SSH message type " + var8_9);
                }
            }
            catch (Exception var8_10) {
                if (!JSch.getLogger().isEnabled(1)) break block37;
                JSch.getLogger().log(1, "Caught an exception, leaving main loop due to " + var8_10.getMessage());
            }
        }
        try {
            this.disconnect();
        }
        catch (NullPointerException var8_11) {
        }
        catch (Exception var9_14) {
            // empty catch block
        }
        this.isConnected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        block17: {
            if (!this.isConnected) {
                return;
            }
            if (JSch.getLogger().isEnabled(1)) {
                JSch.getLogger().log(1, "Disconnecting from " + this.host + " port " + this.port);
            }
            Channel.disconnect(this);
            this.isConnected = false;
            PortWatcher.delPort(this);
            ChannelForwardedTCPIP.delPort(this);
            Object object = this.lock;
            synchronized (object) {
                if (this.connectThread != null) {
                    Thread.yield();
                    this.connectThread.interrupt();
                    this.connectThread = null;
                }
            }
            this.thread = null;
            try {
                if (this.io != null) {
                    if (this.io.in != null) {
                        this.io.in.close();
                    }
                    if (this.io.out != null) {
                        this.io.out.close();
                    }
                    if (this.io.out_ext != null) {
                        this.io.out_ext.close();
                    }
                }
                if (this.proxy == null) {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                    break block17;
                }
                Proxy proxy = this.proxy;
                synchronized (proxy) {
                    this.proxy.close();
                }
                this.proxy = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.io = null;
        this.socket = null;
        this.jsch.removeSession(this);
    }

    public int setPortForwardingL(int n, String string, int n2) throws JSchException {
        return this.setPortForwardingL("127.0.0.1", n, string, n2);
    }

    public int setPortForwardingL(String string, int n, String string2, int n2) throws JSchException {
        return this.setPortForwardingL(string, n, string2, n2, null);
    }

    public int setPortForwardingL(String string, int n, String string2, int n2, ServerSocketFactory serverSocketFactory) throws JSchException {
        PortWatcher portWatcher = PortWatcher.addPort(this, string, n, string2, n2, serverSocketFactory);
        Thread thread = new Thread(portWatcher);
        thread.setName("PortWatcher Thread for " + string2);
        if (this.daemon_thread) {
            thread.setDaemon(this.daemon_thread);
        }
        thread.start();
        return portWatcher.lport;
    }

    public void delPortForwardingL(int n) throws JSchException {
        this.delPortForwardingL("127.0.0.1", n);
    }

    public void delPortForwardingL(String string, int n) throws JSchException {
        PortWatcher.delPort(this, string, n);
    }

    public String[] getPortForwardingL() throws JSchException {
        return PortWatcher.getPortForwarding(this);
    }

    public void setPortForwardingR(int n, String string, int n2) throws JSchException {
        this.setPortForwardingR(null, n, string, n2, null);
    }

    public void setPortForwardingR(String string, int n, String string2, int n2) throws JSchException {
        this.setPortForwardingR(string, n, string2, n2, null);
    }

    public void setPortForwardingR(int n, String string, int n2, SocketFactory socketFactory) throws JSchException {
        this.setPortForwardingR(null, n, string, n2, socketFactory);
    }

    public void setPortForwardingR(String string, int n, String string2, int n2, SocketFactory socketFactory) throws JSchException {
        ChannelForwardedTCPIP.addPort(this, string, n, string2, n2, socketFactory);
        this.setPortForwarding(string, n);
    }

    public void setPortForwardingR(int n, String string) throws JSchException {
        this.setPortForwardingR(null, n, string, null);
    }

    public void setPortForwardingR(int n, String string, Object[] objectArray) throws JSchException {
        this.setPortForwardingR(null, n, string, objectArray);
    }

    public void setPortForwardingR(String string, int n, String string2, Object[] objectArray) throws JSchException {
        ChannelForwardedTCPIP.addPort(this, string, n, string2, objectArray);
        this.setPortForwarding(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPortForwarding(String string, int n) throws JSchException {
        GlobalRequestReply globalRequestReply = this.grr;
        synchronized (globalRequestReply) {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            String string2 = ChannelForwardedTCPIP.normalize(string);
            try {
                packet.reset();
                buffer.putByte((byte)80);
                buffer.putString("tcpip-forward".getBytes());
                buffer.putByte((byte)1);
                buffer.putString(string2.getBytes());
                buffer.putInt(n);
                this.write(packet);
            }
            catch (Exception exception) {
                if (exception instanceof Throwable) {
                    throw new JSchException(exception.toString(), exception);
                }
                throw new JSchException(exception.toString());
            }
            this.grr.setThread(Thread.currentThread());
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n2 = this.grr.getReply();
            this.grr.setThread(null);
            if (n2 == 0) {
                throw new JSchException("remote port forwarding failed for listen port " + n);
            }
        }
    }

    public void delPortForwardingR(int n) throws JSchException {
        ChannelForwardedTCPIP.delPort(this, n);
    }

    private void initDeflater(String string) throws JSchException {
        if (string.equals("none")) {
            this.deflater = null;
            return;
        }
        String string2 = this.getConfig(string);
        if (string2 != null && (string.equals("zlib") || this.isAuthed && string.equals("zlib@openssh.com"))) {
            try {
                Class<?> clazz = Class.forName(string2);
                this.deflater = (Compression)clazz.newInstance();
                int n = 6;
                try {
                    n = Integer.parseInt(this.getConfig("compression_level"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.deflater.init(1, n);
            }
            catch (Exception exception) {
                throw new JSchException(exception.toString(), exception);
            }
        }
    }

    private void initInflater(String string) throws JSchException {
        if (string.equals("none")) {
            this.inflater = null;
            return;
        }
        String string2 = this.getConfig(string);
        if (string2 != null && (string.equals("zlib") || this.isAuthed && string.equals("zlib@openssh.com"))) {
            try {
                Class<?> clazz = Class.forName(string2);
                this.inflater = (Compression)clazz.newInstance();
                this.inflater.init(0, 0);
            }
            catch (Exception exception) {
                throw new JSchException(exception.toString(), exception);
            }
        }
    }

    void addChannel(Channel channel) {
        channel.setSession(this);
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    void setUserName(String string) {
        this.username = string;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userinfo = userInfo;
    }

    public UserInfo getUserInfo() {
        return this.userinfo;
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void setX11Host(String string) {
        ChannelX11.setHost(string);
    }

    public void setX11Port(int n) {
        ChannelX11.setPort(n);
    }

    public void setX11Cookie(String string) {
        ChannelX11.setCookie(string);
    }

    public void setPassword(String string) {
        if (string != null) {
            this.password = Util.str2byte(string);
        }
    }

    public void setPassword(byte[] byArray) {
        if (byArray != null) {
            this.password = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.password, 0, byArray.length);
        }
    }

    public void setConfig(Properties properties) {
        this.setConfig((Hashtable)properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(Hashtable hashtable) {
        Object object = this.lock;
        synchronized (object) {
            if (this.config == null) {
                this.config = new Hashtable();
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.config.put(string, (String)hashtable.get(string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.config == null) {
                this.config = new Hashtable();
            }
            this.config.put(string, string2);
        }
    }

    public String getConfig(String string) {
        String string2 = null;
        if (this.config != null && (string2 = (String)this.config.get(string)) instanceof String) {
            return string2;
        }
        string2 = JSch.getConfig(string);
        if (string2 instanceof String) {
            return string2;
        }
        return null;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socket_factory = socketFactory;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) throws JSchException {
        if (this.socket == null) {
            if (n < 0) {
                throw new JSchException("invalid timeout value");
            }
            this.timeout = n;
            return;
        }
        try {
            this.socket.setSoTimeout(n);
            this.timeout = n;
        }
        catch (Exception exception) {
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    public String getServerVersion() {
        return new String(this.V_S);
    }

    public String getClientVersion() {
        return new String(this.V_C);
    }

    public void setClientVersion(String string) {
        this.V_C = string.getBytes();
    }

    public void sendIgnore() throws Exception {
        Buffer buffer = new Buffer();
        Packet packet = new Packet(buffer);
        packet.reset();
        buffer.putByte((byte)2);
        this.write(packet);
    }

    public void sendKeepAliveMsg() throws Exception {
        Buffer buffer = new Buffer();
        Packet packet = new Packet(buffer);
        packet.reset();
        buffer.putByte((byte)80);
        buffer.putString(keepalivemsg);
        buffer.putByte((byte)1);
        this.write(packet);
    }

    public HostKey getHostKey() {
        return this.hostkey;
    }

    public String getHost() {
        return this.host;
    }

    public String getUserName() {
        return this.username;
    }

    public int getPort() {
        return this.port;
    }

    public void setHostKeyAlias(String string) {
        this.hostKeyAlias = string;
    }

    public String getHostKeyAlias() {
        return this.hostKeyAlias;
    }

    public void setServerAliveInterval(int n) throws JSchException {
        this.setTimeout(n);
        this.serverAliveInterval = n;
    }

    public void setServerAliveCountMax(int n) {
        this.serverAliveCountMax = n;
    }

    public int getServerAliveInterval() {
        return this.serverAliveInterval;
    }

    public int getServerAliveCountMax() {
        return this.serverAliveCountMax;
    }

    public void setDaemonThread(boolean bl) {
        this.daemon_thread = bl;
    }

    private String[] checkCiphers(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "CheckCiphers: " + string);
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = Util.split(string, ",");
        int n = 0;
        while (n < stringArray.length) {
            if (!Session.checkCipher(this.getConfig(stringArray[n]))) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray2 = new String[vector.size()];
        System.arraycopy(vector.toArray(), 0, stringArray2, 0, vector.size());
        if (JSch.getLogger().isEnabled(1)) {
            int n2 = 0;
            while (n2 < stringArray2.length) {
                JSch.getLogger().log(1, stringArray2[n2] + " is not available.");
                ++n2;
            }
        }
        return stringArray2;
    }

    static boolean checkCipher(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Cipher cipher = (Cipher)clazz.newInstance();
            cipher.init(0, new byte[cipher.getBlockSize()], new byte[cipher.getIVSize()]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        keepalivemsg = "keepalive@jcraft.com".getBytes();
    }

    private class GlobalRequestReply {
        private Thread thread = null;
        private int reply = -1;

        private GlobalRequestReply() {
        }

        void setThread(Thread thread) {
            this.thread = thread;
            this.reply = -1;
        }

        Thread getThread() {
            return this.thread;
        }

        void setReply(int n) {
            this.reply = n;
        }

        int getReply() {
            return this.reply;
        }
    }
}

