/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.jcraft.jsch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.ChannelSession;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.JSchException;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.Request;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.RequestPtyReq;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.RequestSubsystem;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.RequestX11;
import org.apache.hadoop.hbase.shaded.com.jcraft.jsch.Session;

public class ChannelSubsystem
extends ChannelSession {
    boolean xforwading = false;
    boolean pty = false;
    boolean want_reply = true;
    String subsystem = "";

    public void setXForwarding(boolean bl) {
        this.xforwading = true;
    }

    public void setPty(boolean bl) {
        this.pty = bl;
    }

    public void setWantReply(boolean bl) {
        this.want_reply = bl;
    }

    public void setSubsystem(String string) {
        this.subsystem = string;
    }

    public void start() throws JSchException {
        Session session = this.getSession();
        try {
            Request request;
            if (this.xforwading) {
                request = new RequestX11();
                request.request(session, this);
            }
            if (this.pty) {
                request = new RequestPtyReq();
                request.request(session, this);
            }
            request = new RequestSubsystem();
            ((RequestSubsystem)request).request(session, this, this.subsystem, this.want_reply);
        }
        catch (Exception exception) {
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            if (exception instanceof Throwable) {
                throw new JSchException("ChannelSubsystem", exception);
            }
            throw new JSchException("ChannelSubsystem");
        }
        if (this.io.in != null) {
            this.thread = new Thread(this);
            this.thread.setName("Subsystem for " + session.host);
            if (session.daemon_thread) {
                this.thread.setDaemon(session.daemon_thread);
            }
            this.thread.start();
        }
    }

    void init() throws JSchException {
        this.io.setInputStream(this.getSession().in);
        this.io.setOutputStream(this.getSession().out);
    }

    public void setErrStream(OutputStream outputStream) {
        this.setExtOutputStream(outputStream);
    }

    public InputStream getErrStream() throws IOException {
        return this.getExtInputStream();
    }
}

