/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.protobuf.Message;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.LoadBalancerProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class LoadBalancerTracker
extends ZooKeeperNodeTracker {
    private static final Log LOG = LogFactory.getLog(LoadBalancerTracker.class);

    public LoadBalancerTracker(ZooKeeperWatcher watcher, Abortable abortable) {
        super(watcher, watcher.balancerZNode, abortable);
    }

    public boolean isBalancerOn() {
        byte[] upData = super.getData(false);
        try {
            return upData == null || this.parseFrom(upData).getBalancerOn();
        }
        catch (DeserializationException dex) {
            LOG.error((Object)("ZK state for LoadBalancer could not be parsed " + Bytes.toStringBinary((byte[])upData)));
            return false;
        }
    }

    public void setBalancerOn(boolean balancerOn) throws KeeperException {
        byte[] upData = this.toByteArray(balancerOn);
        try {
            ZKUtil.setData((ZooKeeperWatcher)this.watcher, (String)this.watcher.balancerZNode, (byte[])upData);
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil.createAndWatch((ZooKeeperWatcher)this.watcher, (String)this.watcher.balancerZNode, (byte[])upData);
        }
        super.nodeDataChanged(this.watcher.balancerZNode);
    }

    private byte[] toByteArray(boolean isBalancerOn) {
        LoadBalancerProtos.LoadBalancerState.Builder builder = LoadBalancerProtos.LoadBalancerState.newBuilder();
        builder.setBalancerOn(isBalancerOn);
        return ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
    }

    private LoadBalancerProtos.LoadBalancerState parseFrom(byte[] pbBytes) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix((byte[])pbBytes);
        LoadBalancerProtos.LoadBalancerState.Builder builder = LoadBalancerProtos.LoadBalancerState.newBuilder();
        try {
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])pbBytes, (int)magicLen, (int)(pbBytes.length - magicLen));
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
        return builder.build();
    }
}

