/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.api.observer;

import org.apache.fluo.api.client.TransactionBase;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.metrics.MetricsReporter;

public interface Observer {
    public void init(Context var1) throws Exception;

    public void process(TransactionBase var1, Bytes var2, Column var3) throws Exception;

    public ObservedColumn getObservedColumn();

    public void close();

    public static interface Context {
        public SimpleConfiguration getAppConfiguration();

        public SimpleConfiguration getObserverConfiguration();

        public MetricsReporter getMetricsReporter();
    }

    public static class ObservedColumn {
        private final Column col;
        private final NotificationType notificationType;

        public ObservedColumn(Column col, NotificationType notificationType) {
            this.col = col;
            this.notificationType = notificationType;
        }

        public Column getColumn() {
            return this.col;
        }

        public NotificationType getType() {
            return this.notificationType;
        }
    }

    public static enum NotificationType {
        WEAK,
        STRONG;

    }
}

