/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.api.data;

import java.io.Serializable;
import java.util.Objects;
import org.apache.fluo.api.data.Bytes;

public final class Column
implements Comparable<Column>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Bytes UNSET = Bytes.of(new byte[0]);
    private Bytes family = UNSET;
    private Bytes qualifier = UNSET;
    private Bytes visibility = UNSET;
    public static final Column EMPTY = new Column();

    public Column() {
    }

    public Column(Bytes family) {
        Objects.requireNonNull(family, "Family must not be null");
        this.family = family;
    }

    public Column(CharSequence family) {
        this(Bytes.of(family));
    }

    public Column(Bytes family, Bytes qualifier) {
        Objects.requireNonNull(family, "Family must not be null");
        Objects.requireNonNull(qualifier, "Qualifier must not be null");
        this.family = family;
        this.qualifier = qualifier;
    }

    public Column(CharSequence family, CharSequence qualifier) {
        this(Bytes.of(family), Bytes.of(qualifier));
    }

    public Column(Bytes family, Bytes qualifier, Bytes visibility) {
        Objects.requireNonNull(family, "Family must not be null");
        Objects.requireNonNull(qualifier, "Qualifier must not be null");
        Objects.requireNonNull(visibility, "Visibility must not be null");
        this.family = family;
        this.qualifier = qualifier;
        this.visibility = visibility;
    }

    public Column(CharSequence family, CharSequence qualifier, CharSequence visibility) {
        this(Bytes.of(family), Bytes.of(qualifier), Bytes.of(visibility));
    }

    public boolean isFamilySet() {
        return this.family != UNSET;
    }

    public Bytes getFamily() {
        if (!this.isFamilySet()) {
            return Bytes.EMPTY;
        }
        return this.family;
    }

    public String getsFamily() {
        return this.getFamily().toString();
    }

    public boolean isQualifierSet() {
        return this.qualifier != UNSET;
    }

    public Bytes getQualifier() {
        if (!this.isQualifierSet()) {
            return Bytes.EMPTY;
        }
        return this.qualifier;
    }

    public String getsQualifier() {
        return this.getQualifier().toString();
    }

    public boolean isVisibilitySet() {
        return this.visibility != UNSET;
    }

    public Bytes getVisibility() {
        if (!this.isVisibilitySet()) {
            return Bytes.EMPTY;
        }
        return this.visibility;
    }

    public String getsVisibility() {
        return this.getVisibility().toString();
    }

    public String toString() {
        return this.family + " " + this.qualifier + " " + this.visibility;
    }

    public int hashCode() {
        return Objects.hash(this.family, this.qualifier, this.visibility);
    }

    @Override
    public int compareTo(Column other) {
        int result = this.family.compareTo(other.family);
        if (result == 0 && (result = this.qualifier.compareTo(other.qualifier)) == 0) {
            result = this.visibility.compareTo(other.visibility);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof Column) {
            Column oc = (Column)o;
            return this.family.equals(oc.getFamily()) && this.qualifier.equals(oc.getQualifier()) && this.visibility.equals(oc.getVisibility());
        }
        return false;
    }
}

