/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import akka.actor.ActorSystem;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.client.program.ContextEnvironment;
import org.apache.flink.client.program.ContextEnvironmentFactory;
import org.apache.flink.client.program.DetachedEnvironment;
import org.apache.flink.client.program.JobWithJars;
import org.apache.flink.client.program.OptimizerPlanEnvironment;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.costs.DefaultCostEstimator;
import org.apache.flink.optimizer.plan.FlinkPlan;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.StreamingPlan;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.client.JobClient;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.clusterframework.messages.GetClusterStatusResponse;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.messages.accumulators.AccumulatorResultsErroneous;
import org.apache.flink.runtime.messages.accumulators.AccumulatorResultsFound;
import org.apache.flink.runtime.messages.accumulators.RequestAccumulatorResults;
import org.apache.flink.runtime.net.ConnectionUtils;
import org.apache.flink.runtime.util.LeaderConnectionInfo;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public abstract class ClusterClient {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    final Optimizer compiler;
    protected final LazyActorSystemLoader actorSystemLoader;
    protected final Configuration flinkConfig;
    protected final FiniteDuration timeout;
    private final FiniteDuration lookupTimeout;
    private boolean printStatusDuringExecution = true;
    private JobExecutionResult lastJobExecutionResult;
    private boolean detachedJobSubmission = false;

    public ClusterClient(Configuration flinkConfig) throws IOException {
        this.flinkConfig = (Configuration)Preconditions.checkNotNull((Object)flinkConfig);
        this.compiler = new Optimizer(new DataStatistics(), (CostEstimator)new DefaultCostEstimator(), flinkConfig);
        this.timeout = AkkaUtils.getClientTimeout((Configuration)flinkConfig);
        this.lookupTimeout = AkkaUtils.getLookupTimeout((Configuration)flinkConfig);
        this.actorSystemLoader = new LazyActorSystemLoader(flinkConfig, this.LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ClusterClient clusterClient = this;
        synchronized (clusterClient) {
            try {
                this.finalizeCluster();
            }
            finally {
                this.actorSystemLoader.shutdown();
            }
        }
    }

    public void setPrintStatusDuringExecution(boolean print) {
        this.printStatusDuringExecution = print;
    }

    public boolean getPrintStatusDuringExecution() {
        return this.printStatusDuringExecution;
    }

    public InetSocketAddress getJobManagerAddress() {
        try {
            LeaderConnectionInfo leaderConnectionInfo = LeaderRetrievalUtils.retrieveLeaderConnectionInfo((LeaderRetrievalService)LeaderRetrievalUtils.createLeaderRetrievalService((Configuration)this.flinkConfig), (FiniteDuration)this.timeout);
            return AkkaUtils.getInetSockeAddressFromAkkaURL((String)leaderConnectionInfo.getAddress());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve JobManager address", e);
        }
    }

    public static String getOptimizedPlanAsJson(Optimizer compiler, PackagedProgram prog, int parallelism) throws CompilerException, ProgramInvocationException {
        PlanJSONDumpGenerator jsonGen = new PlanJSONDumpGenerator();
        return jsonGen.getOptimizerPlanAsJSON((OptimizedPlan)ClusterClient.getOptimizedPlan(compiler, prog, parallelism));
    }

    public static FlinkPlan getOptimizedPlan(Optimizer compiler, PackagedProgram prog, int parallelism) throws CompilerException, ProgramInvocationException {
        Thread.currentThread().setContextClassLoader(prog.getUserCodeClassLoader());
        if (prog.isUsingProgramEntryPoint()) {
            return ClusterClient.getOptimizedPlan(compiler, prog.getPlanWithJars(), parallelism);
        }
        if (prog.isUsingInteractiveMode()) {
            OptimizerPlanEnvironment env = new OptimizerPlanEnvironment(compiler);
            if (parallelism > 0) {
                env.setParallelism(parallelism);
            }
            return env.getOptimizedPlan(prog);
        }
        throw new RuntimeException("Couldn't determine program mode.");
    }

    public static OptimizedPlan getOptimizedPlan(Optimizer compiler, Plan p, int parallelism) throws CompilerException {
        Logger log = LoggerFactory.getLogger(ClusterClient.class);
        if (parallelism > 0 && p.getDefaultParallelism() <= 0) {
            log.debug("Changing plan default parallelism from {} to {}", (Object)p.getDefaultParallelism(), (Object)parallelism);
            p.setDefaultParallelism(parallelism);
        }
        log.debug("Set parallelism {}, plan default parallelism {}", (Object)parallelism, (Object)p.getDefaultParallelism());
        return compiler.compile(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobSubmissionResult run(PackagedProgram prog, int parallelism) throws ProgramInvocationException {
        Thread.currentThread().setContextClassLoader(prog.getUserCodeClassLoader());
        if (prog.isUsingProgramEntryPoint()) {
            return this.run(prog.getPlanWithJars(), parallelism, prog.getSavepointPath());
        }
        if (prog.isUsingInteractiveMode()) {
            this.LOG.info("Starting program in interactive mode");
            ContextEnvironmentFactory factory = new ContextEnvironmentFactory(this, prog.getAllLibraries(), prog.getClasspaths(), prog.getUserCodeClassLoader(), parallelism, this.isDetached(), prog.getSavepointPath());
            ContextEnvironment.setAsContext(factory);
            try {
                prog.invokeInteractiveModeForExecution();
                if (this.lastJobExecutionResult == null && factory.getLastEnvCreated() == null) {
                    throw new ProgramInvocationException("The program didn't contain Flink jobs. Perhaps you forgot to call execute() on the execution environment.");
                }
                if (this.isDetached()) {
                    JobSubmissionResult jobSubmissionResult = ((DetachedEnvironment)factory.getLastEnvCreated()).finalizeExecute();
                    return jobSubmissionResult;
                }
                JobExecutionResult jobExecutionResult = this.lastJobExecutionResult;
                return jobExecutionResult;
            }
            finally {
                ContextEnvironment.unsetContext();
            }
        }
        throw new ProgramInvocationException("PackagedProgram does not have a valid invocation mode.");
    }

    public JobSubmissionResult run(JobWithJars program, int parallelism) throws ProgramInvocationException {
        return this.run(program, parallelism, null);
    }

    public JobSubmissionResult run(JobWithJars program, int parallelism, String savepointPath) throws CompilerException, ProgramInvocationException {
        ClassLoader classLoader = program.getUserCodeClassLoader();
        if (classLoader == null) {
            throw new IllegalArgumentException("The given JobWithJars does not provide a usercode class loader.");
        }
        OptimizedPlan optPlan = ClusterClient.getOptimizedPlan(this.compiler, program, parallelism);
        return this.run((FlinkPlan)optPlan, program.getJarFiles(), program.getClasspaths(), classLoader, savepointPath);
    }

    public JobSubmissionResult run(FlinkPlan compiledPlan, List<URL> libraries, List<URL> classpaths, ClassLoader classLoader) throws ProgramInvocationException {
        return this.run(compiledPlan, libraries, classpaths, classLoader, null);
    }

    public JobSubmissionResult run(FlinkPlan compiledPlan, List<URL> libraries, List<URL> classpaths, ClassLoader classLoader, String savepointPath) throws ProgramInvocationException {
        JobGraph job = this.getJobGraph(compiledPlan, libraries, classpaths, savepointPath);
        return this.submitJob(job, classLoader);
    }

    public JobExecutionResult run(JobGraph jobGraph, ClassLoader classLoader) throws ProgramInvocationException {
        LeaderRetrievalService leaderRetrievalService;
        this.waitForClusterToBeReady();
        try {
            leaderRetrievalService = LeaderRetrievalUtils.createLeaderRetrievalService((Configuration)this.flinkConfig);
        }
        catch (Exception e) {
            throw new ProgramInvocationException("Could not create the leader retrieval service", e);
        }
        try {
            this.logAndSysout("Submitting job with JobID: " + jobGraph.getJobID() + ". Waiting for job completion.");
            this.lastJobExecutionResult = JobClient.submitJobAndWait((ActorSystem)this.actorSystemLoader.get(), (LeaderRetrievalService)leaderRetrievalService, (JobGraph)jobGraph, (FiniteDuration)this.timeout, (boolean)this.printStatusDuringExecution, (ClassLoader)classLoader);
            return this.lastJobExecutionResult;
        }
        catch (JobExecutionException e) {
            throw new ProgramInvocationException("The program execution failed: " + e.getMessage(), e);
        }
    }

    public JobSubmissionResult runDetached(JobGraph jobGraph, ClassLoader classLoader) throws ProgramInvocationException {
        ActorGateway jobManagerGateway;
        this.waitForClusterToBeReady();
        try {
            jobManagerGateway = this.getJobManagerGateway();
        }
        catch (Exception e) {
            throw new ProgramInvocationException("Failed to retrieve the JobManager gateway.", e);
        }
        try {
            this.logAndSysout("Submitting Job with JobID: " + jobGraph.getJobID() + ". Returning after job submission.");
            JobClient.submitJobDetached((ActorGateway)jobManagerGateway, (JobGraph)jobGraph, (FiniteDuration)this.timeout, (ClassLoader)classLoader);
            return new JobSubmissionResult(jobGraph.getJobID());
        }
        catch (JobExecutionException e) {
            throw new ProgramInvocationException("The program execution failed: " + e.getMessage(), e);
        }
    }

    public void cancel(JobID jobId) throws Exception {
        Future response;
        ActorGateway jobManagerGateway = this.getJobManagerGateway();
        try {
            response = jobManagerGateway.ask((Object)new JobManagerMessages.CancelJob(jobId), this.timeout);
        }
        catch (Exception e) {
            throw new ProgramInvocationException("Failed to query the job manager gateway.", e);
        }
        Object result = Await.result((Awaitable)response, (Duration)this.timeout);
        if (!(result instanceof JobManagerMessages.CancellationSuccess)) {
            if (result instanceof JobManagerMessages.CancellationFailure) {
                Throwable t = ((JobManagerMessages.CancellationFailure)result).cause();
                this.LOG.info("Job cancellation with ID " + jobId + " failed.", t);
                throw new Exception("Failed to cancel the job because of \n" + t.getMessage());
            }
            throw new Exception("Unknown message received while cancelling: " + result.getClass().getName());
        }
        this.LOG.info("Job cancellation with ID " + jobId + " succeeded.");
    }

    public void stop(JobID jobId) throws Exception {
        Future response;
        ActorGateway jobManagerGateway = this.getJobManagerGateway();
        try {
            response = jobManagerGateway.ask((Object)new JobManagerMessages.StopJob(jobId), this.timeout);
        }
        catch (Exception e) {
            throw new ProgramInvocationException("Failed to query the job manager gateway.", e);
        }
        Object result = Await.result((Awaitable)response, (Duration)this.timeout);
        if (!(result instanceof JobManagerMessages.StoppingSuccess)) {
            if (result instanceof JobManagerMessages.StoppingFailure) {
                Throwable t = ((JobManagerMessages.StoppingFailure)result).cause();
                this.LOG.info("Job stopping with ID " + jobId + " failed.", t);
                throw new Exception("Failed to stop the job because of \n" + t.getMessage());
            }
            throw new Exception("Unknown message received while stopping: " + result.getClass().getName());
        }
        this.LOG.info("Job stopping with ID " + jobId + " succeeded.");
    }

    public Map<String, Object> getAccumulators(JobID jobID) throws Exception {
        return this.getAccumulators(jobID, ClassLoader.getSystemClassLoader());
    }

    public Map<String, Object> getAccumulators(JobID jobID, ClassLoader loader) throws Exception {
        Future response;
        ActorGateway jobManagerGateway = this.getJobManagerGateway();
        try {
            response = jobManagerGateway.ask((Object)new RequestAccumulatorResults(jobID), this.timeout);
        }
        catch (Exception e) {
            throw new Exception("Failed to query the job manager gateway for accumulators.", e);
        }
        Object result = Await.result((Awaitable)response, (Duration)this.timeout);
        if (result instanceof AccumulatorResultsFound) {
            Map serializedAccumulators = ((AccumulatorResultsFound)result).result();
            return AccumulatorHelper.deserializeAccumulators((Map)serializedAccumulators, (ClassLoader)loader);
        }
        if (result instanceof AccumulatorResultsErroneous) {
            throw ((AccumulatorResultsErroneous)result).cause();
        }
        throw new Exception("Failed to fetch accumulators for the job " + jobID + ".");
    }

    public void endSession(JobID jobId) throws Exception {
        if (jobId == null) {
            throw new IllegalArgumentException("The JobID must not be null.");
        }
        this.endSessions(Collections.singletonList(jobId));
    }

    public void endSessions(List<JobID> jobIds) throws Exception {
        if (jobIds == null) {
            throw new IllegalArgumentException("The JobIDs must not be null");
        }
        ActorGateway jobManagerGateway = this.getJobManagerGateway();
        for (JobID jid : jobIds) {
            if (jid == null) continue;
            this.LOG.info("Telling job manager to end the session {}.", (Object)jid);
            jobManagerGateway.tell((Object)new JobManagerMessages.RemoveCachedJob(jid));
        }
    }

    private static OptimizedPlan getOptimizedPlan(Optimizer compiler, JobWithJars prog, int parallelism) throws CompilerException, ProgramInvocationException {
        return ClusterClient.getOptimizedPlan(compiler, prog.getPlan(), parallelism);
    }

    public JobGraph getJobGraph(PackagedProgram prog, FlinkPlan optPlan) throws ProgramInvocationException {
        return this.getJobGraph(optPlan, prog.getAllLibraries(), prog.getClasspaths(), null);
    }

    public JobGraph getJobGraph(PackagedProgram prog, FlinkPlan optPlan, String savepointPath) throws ProgramInvocationException {
        return this.getJobGraph(optPlan, prog.getAllLibraries(), prog.getClasspaths(), savepointPath);
    }

    private JobGraph getJobGraph(FlinkPlan optPlan, List<URL> jarFiles, List<URL> classpaths, String savepointPath) {
        JobGraph job;
        if (optPlan instanceof StreamingPlan) {
            job = ((StreamingPlan)optPlan).getJobGraph();
            job.setSavepointPath(savepointPath);
        } else {
            JobGraphGenerator gen = new JobGraphGenerator(this.flinkConfig);
            job = gen.compileJobGraph((OptimizedPlan)optPlan);
        }
        for (URL jar : jarFiles) {
            try {
                job.addJar(new Path(jar.toURI()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("URL is invalid. This should not happen.", e);
            }
        }
        job.setClasspaths(classpaths);
        return job;
    }

    public ActorGateway getJobManagerGateway() throws Exception {
        this.LOG.debug("Looking up JobManager");
        return LeaderRetrievalUtils.retrieveLeaderGateway((LeaderRetrievalService)LeaderRetrievalUtils.createLeaderRetrievalService((Configuration)this.flinkConfig), (ActorSystem)this.actorSystemLoader.get(), (FiniteDuration)this.lookupTimeout);
    }

    protected void logAndSysout(String message) {
        this.LOG.info(message);
        if (this.printStatusDuringExecution) {
            System.out.println(message);
        }
    }

    public abstract void waitForClusterToBeReady();

    public abstract String getWebInterfaceURL();

    public abstract GetClusterStatusResponse getClusterStatus();

    protected abstract List<String> getNewMessages();

    public abstract String getClusterIdentifier();

    protected abstract void finalizeCluster();

    public void setDetached(boolean isDetached) {
        this.detachedJobSubmission = isDetached;
    }

    public boolean isDetached() {
        return this.detachedJobSubmission;
    }

    public Configuration getFlinkConfiguration() {
        return this.flinkConfig.clone();
    }

    public abstract int getMaxSlots();

    protected abstract JobSubmissionResult submitJob(JobGraph var1, ClassLoader var2) throws ProgramInvocationException;

    protected static class LazyActorSystemLoader {
        private final Logger LOG;
        private final Configuration flinkConfig;
        private ActorSystem actorSystem;

        private LazyActorSystemLoader(Configuration flinkConfig, Logger LOG) {
            this.flinkConfig = flinkConfig;
            this.LOG = LOG;
        }

        public boolean isLoaded() {
            return this.actorSystem != null;
        }

        public void shutdown() {
            if (this.isLoaded()) {
                this.actorSystem.shutdown();
                this.actorSystem.awaitTermination();
                this.actorSystem = null;
            }
        }

        public ActorSystem get() {
            if (!this.isLoaded()) {
                InetAddress ownHostname;
                this.LOG.info("Starting client actor system.");
                String hostName = this.flinkConfig.getString("jobmanager.rpc.address", null);
                int port = this.flinkConfig.getInteger("jobmanager.rpc.port", -1);
                if (hostName == null || port == -1) {
                    throw new RuntimeException("The initial JobManager address has not been set correctly.");
                }
                InetSocketAddress initialJobManagerAddress = new InetSocketAddress(hostName, port);
                try {
                    ownHostname = ConnectionUtils.findConnectingAddress((InetSocketAddress)initialJobManagerAddress, (long)2000L, (long)400L);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to resolve JobManager address at " + initialJobManagerAddress, e);
                }
                this.actorSystem = AkkaUtils.createActorSystem((Configuration)this.flinkConfig, (Option)new Some((Object)new Tuple2((Object)ownHostname.getCanonicalHostName(), (Object)0)));
            }
            return this.actorSystem;
        }
    }
}

