/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.util.List;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.AVA;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.name.TooComplexException;
import org.apache.directory.shared.ldap.util.Position;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FastDnParser {
    INSTANCE;


    public static FastDnParser getNameParser() {
        return INSTANCE;
    }

    public DN parse(String name) throws LdapException {
        DN dn = new DN();
        this.parseDn(name, dn);
        return dn;
    }

    public void parseDn(String name, DN dn) throws LdapInvalidDnException {
        this.parseDn(name, dn.rdns);
        dn.setUpName(name);
        dn.normalizeInternal();
    }

    void parseDn(String name, List<RDN> rdns) throws LdapInvalidDnException {
        block5: {
            char c;
            if (name == null || name.trim().length() == 0) {
                return;
            }
            Position pos = new Position();
            pos.start = 0;
            pos.length = name.length();
            block3: while (true) {
                RDN rdn = new RDN();
                this.parseRdnInternal(name, pos, rdn);
                rdns.add(rdn);
                if (!this.hasMoreChars(pos)) break block5;
                c = this.nextChar(name, pos, true);
                switch (c) {
                    case ',': 
                    case ';': {
                        continue block3;
                    }
                }
                break;
            }
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err("ERR_04192", Character.valueOf(c), pos.start));
        }
    }

    public void parseRdn(String name, RDN rdn) throws LdapInvalidDnException {
        if (name == null || name.length() == 0) {
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err("ERR_04193", new Object[0]));
        }
        if (rdn == null) {
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err("ERR_04194", new Object[0]));
        }
        Position pos = new Position();
        pos.start = 0;
        pos.length = name.length();
        this.parseRdnInternal(name, pos, rdn);
    }

    private void parseRdnInternal(String name, Position pos, RDN rdn) throws LdapInvalidDnException {
        int rdnStart = pos.start;
        this.matchSpaces(name, pos);
        String type = this.matchAttributeType(name, pos);
        this.matchSpaces(name, pos);
        this.matchEquals(name, pos);
        this.matchSpaces(name, pos);
        String upValue = this.matchValue(name, pos);
        String value = StringTools.trimRight(upValue);
        this.matchSpaces(name, pos);
        String upName = name.substring(rdnStart, pos.start);
        AVA ava = new AVA(type, type, new StringValue(upValue), new StringValue(value), upName);
        rdn.addAttributeTypeAndValue(ava);
        rdn.setUpName(upName);
        rdn.normalize();
    }

    private void matchSpaces(String name, Position pos) throws LdapInvalidDnException {
        while (this.hasMoreChars(pos)) {
            char c = this.nextChar(name, pos, true);
            if (c == ' ') continue;
            --pos.start;
            break;
        }
    }

    private String matchAttributeType(String name, Position pos) throws LdapInvalidDnException {
        char c = this.nextChar(name, pos, false);
        switch (c) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return this.matchAttributeTypeDescr(name, pos);
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.matchAttributeTypeNumericOid(name, pos);
            }
        }
        throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err("ERR_04195", Character.valueOf(c), pos.start));
    }

    private String matchAttributeTypeDescr(String name, Position pos) throws LdapInvalidDnException {
        StringBuilder descr = new StringBuilder();
        block5: while (this.hasMoreChars(pos)) {
            char c = this.nextChar(name, pos, true);
            switch (c) {
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    descr.append(c);
                    continue block5;
                }
                case ' ': 
                case '=': {
                    --pos.start;
                    return descr.toString();
                }
                case '.': {
                    throw new TooComplexException();
                }
            }
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err("ERR_04196", Character.valueOf(c), pos.start));
        }
        return descr.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String matchAttributeTypeNumericOid(String name, Position pos) throws LdapInvalidDnException {
        numericOid = new StringBuilder();
        dotCount = 0;
        block14: while (true) {
            c = this.nextChar(name, pos, true);
            switch (c) {
                case '0': {
                    numericOid.append(c);
                    c = this.nextChar(name, pos, true);
                    switch (c) {
                        case '.': {
                            numericOid.append(c);
                            ++dotCount;
                            continue block14;
                        }
                        case ' ': 
                        case '=': {
                            --pos.start;
                            continue block14;
                        }
                    }
                    throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err("ERR_04197", new Object[]{Character.valueOf(c), pos.start}));
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    numericOid.append(c);
                    inInnerLoop = true;
                    block15: while (true) {
                        if (inInnerLoop) ** break;
                        continue block14;
                        c = this.nextChar(name, pos, true);
                        switch (c) {
                            case ' ': 
                            case '=': {
                                inInnerLoop = false;
                                --pos.start;
                                continue block15;
                            }
                            case '.': {
                                inInnerLoop = false;
                                ++dotCount;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                numericOid.append(c);
                                continue block15;
                            }
                        }
                        break;
                    }
                    throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err("ERR_04197", new Object[]{Character.valueOf(c), pos.start}));
                }
                case ' ': 
                case '=': {
                    --pos.start;
                    if (dotCount > 0) {
                        return numericOid.toString();
                    }
                    throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err("ERR_04198", new Object[0]));
                }
            }
            break;
        }
        throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err("ERR_04199", new Object[]{Character.valueOf(c), pos.start}));
    }

    private void matchEquals(String name, Position pos) throws LdapInvalidDnException {
        char c = this.nextChar(name, pos, true);
        if (c != '=') {
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err("ERR_04200", Character.valueOf(c), pos.start));
        }
    }

    private String matchValue(String name, Position pos) throws LdapInvalidDnException {
        StringBuilder value = new StringBuilder();
        int numTrailingSpaces = 0;
        block5: while (true) {
            if (!this.hasMoreChars(pos)) {
                pos.start -= numTrailingSpaces;
                return value.substring(0, value.length() - numTrailingSpaces);
            }
            char c = this.nextChar(name, pos, true);
            switch (c) {
                case '\"': 
                case '#': 
                case '+': 
                case '\\': {
                    throw new TooComplexException();
                }
                case ',': 
                case ';': {
                    --pos.start;
                    pos.start -= numTrailingSpaces;
                    return value.substring(0, value.length() - numTrailingSpaces);
                }
                case ' ': {
                    ++numTrailingSpaces;
                    value.append(c);
                    continue block5;
                }
            }
            numTrailingSpaces = 0;
            value.append(c);
        }
    }

    private char nextChar(String name, Position pos, boolean increment) throws LdapInvalidDnException {
        if (!this.hasMoreChars(pos)) {
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err("ERR_04201", pos.start));
        }
        char c = name.charAt(pos.start);
        if (increment) {
            ++pos.start;
        }
        return c;
    }

    private boolean hasMoreChars(Position pos) {
        return pos.start < pos.length;
    }
}

