/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptionKeyEncoder;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StoreUtils.class);

    public static ServerEntry toServerEntry(CoreSession session, DN dn, PrincipalStoreEntry principalEntry) throws Exception {
        ServerEntry outAttrs = session.getDirectoryService().newEntry(dn);
        outAttrs.add("objectClass", "top", "uidObject", "uidObject", "extensibleObject", "person", "organizationalPerson", "inetOrgPerson", "krb5Principal", "krb5KDCEntry");
        outAttrs.add("uid", principalEntry.getUserId());
        outAttrs.add("apacheSamType", "7");
        outAttrs.add("sn", principalEntry.getUserId());
        outAttrs.add("cn", principalEntry.getCommonName());
        EncryptionKey encryptionKey = principalEntry.getKeyMap().get((Object)EncryptionType.DES_CBC_MD5);
        outAttrs.add("krb5Key", (byte[][])new byte[][]{EncryptionKeyEncoder.encode(encryptionKey)});
        int keyVersion = encryptionKey.getKeyVersion();
        outAttrs.add("krb5PrincipalName", principalEntry.getPrincipal().getName());
        outAttrs.add("krb5KeyVersionNumber", Integer.toString(keyVersion));
        return outAttrs;
    }

    private static ExprNode getFilter(SchemaManager schemaManager, String principal) throws Exception {
        AttributeType type = schemaManager.lookupAttributeTypeRegistry("krb5PrincipalName");
        StringValue value = new StringValue(type, principal);
        return new EqualityNode<String>("krb5PrincipalName", value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerEntry findPrincipalEntry(CoreSession session, DN searchBaseDn, String principal) throws Exception {
        Cursor cursor = null;
        try {
            SchemaManager schemaManager = session.getDirectoryService().getSchemaManager();
            cursor = session.search(searchBaseDn, SearchScope.SUBTREE, StoreUtils.getFilter(schemaManager, principal), AliasDerefMode.DEREF_ALWAYS, null);
            cursor.beforeFirst();
            if (cursor.next()) {
                ServerEntry entry = (ServerEntry)cursor.get();
                LOG.debug("Found entry {} for kerberos principal name {}", entry, (Object)principal);
                while (cursor.next()) {
                    LOG.error(I18n.err(I18n.ERR_149, principal, cursor.next()));
                }
                ServerEntry serverEntry = entry;
                return serverEntry;
            }
            LOG.warn("No server entry found for kerberos principal name {}", (Object)principal);
            ServerEntry serverEntry = null;
            return serverEntry;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }
}

