/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidSearchFilterException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.name.DN;

public class ScopeEvaluator
implements Evaluator {
    public boolean evaluate(ExprNode node, String dn, ServerEntry record) throws LdapException {
        ScopeNode snode = (ScopeNode)node;
        switch (snode.getScope()) {
            case OBJECT: {
                return dn.equals(snode.getBaseDn());
            }
            case ONELEVEL: {
                if (dn.endsWith(snode.getBaseDn())) {
                    DN candidateDn = new DN(dn);
                    DN scopeDn = new DN(snode.getBaseDn());
                    return scopeDn.size() + 1 == candidateDn.size();
                }
            }
            case SUBTREE: {
                return dn.endsWith(snode.getBaseDn());
            }
        }
        throw new LdapInvalidSearchFilterException(I18n.err(I18n.ERR_247, new Object[0]));
    }
}

