/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;

abstract class AbstractSwaggerFeature
extends AbstractFeature {
    protected boolean scan = true;
    protected boolean runAsFilter;
    private String resourcePackage;
    private String version = "1.0.0";
    private String basePath;
    private String title = "Sample REST Application";
    private String description = "The Application";
    private String contact = "committer@apache.org";
    private String license = "Apache 2.0 License";
    private String licenseUrl = "http://www.apache.org/licenses/LICENSE-2.0.html";

    AbstractSwaggerFeature() {
    }

    public void initialize(Server server, Bus bus) {
        this.calculateDefaultResourcePackage(server);
        this.calculateDefaultBasePath(server);
        this.addSwaggerResource(server);
        this.initializeProvider((InterceptorProvider)server.getEndpoint(), bus);
    }

    protected abstract void addSwaggerResource(Server var1);

    protected abstract void setBasePathByAddress(String var1);

    private void calculateDefaultResourcePackage(Server server) {
        JAXRSServiceFactoryBean serviceFactoryBean = (JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName());
        AbstractResourceInfo resourceInfo = (AbstractResourceInfo)serviceFactoryBean.getClassResourceInfo().get(0);
        if (resourceInfo != null && (this.getResourcePackage() == null || this.getResourcePackage().length() == 0)) {
            this.setResourcePackage(resourceInfo.getServiceClass().getPackage().getName());
        }
    }

    private void calculateDefaultBasePath(Server server) {
        if (this.getBasePath() == null || this.getBasePath().length() == 0) {
            String address = server.getEndpoint().getEndpointInfo().getAddress();
            this.setBasePathByAddress(address);
        }
    }

    public String getResourcePackage() {
        return this.resourcePackage;
    }

    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public boolean isScan() {
        return this.scan;
    }

    public void setScan(boolean scan) {
        this.scan = scan;
    }

    public boolean isRunAsFilter() {
        return this.runAsFilter;
    }

    public void setRunAsFilter(boolean runAsFilter) {
        this.runAsFilter = runAsFilter;
    }
}

