/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.EncryptionToken;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.ProtectionToken;
import org.apache.cxf.ws.security.policy.model.SignatureToken;
import org.apache.cxf.ws.security.policy.model.SymmetricAsymmetricBindingBase;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

public class SymmetricBinding
extends SymmetricAsymmetricBindingBase {
    private EncryptionToken encryptionToken;
    private SignatureToken signatureToken;
    private ProtectionToken protectionToken;

    public SymmetricBinding(PolicyBuilder b) {
        super(SP12Constants.INSTANCE, b);
    }

    public SymmetricBinding(SPConstants version, PolicyBuilder b) {
        super(version, b);
    }

    public EncryptionToken getEncryptionToken() {
        return this.encryptionToken;
    }

    public void setEncryptionToken(EncryptionToken encryptionToken) {
        this.encryptionToken = encryptionToken;
    }

    public ProtectionToken getProtectionToken() {
        return this.protectionToken;
    }

    public void setProtectionToken(ProtectionToken protectionToken) {
        this.protectionToken = protectionToken;
    }

    public SignatureToken getSignatureToken() {
        return this.signatureToken;
    }

    public void setSignatureToken(SignatureToken signatureToken) {
        this.signatureToken = signatureToken;
    }

    public QName getRealName() {
        return this.constants.getSymmetricBinding();
    }

    public QName getName() {
        return SP12Constants.INSTANCE.getSymmetricBinding();
    }

    @Override
    public PolicyComponent normalize() {
        All all = new All();
        all.addPolicyComponent(this.getPolicy().getFirstPolicyComponent());
        all.addPolicyComponent((PolicyComponent)this);
        return all;
    }

    public Policy getPolicy() {
        Policy p = new Policy();
        ExactlyOne ea = new ExactlyOne();
        p.addPolicyComponent((PolicyComponent)ea);
        All all = new All();
        if (this.getProtectionToken() != null) {
            all.addPolicyComponent((PolicyComponent)this.getProtectionToken());
        }
        if (this.getSignatureToken() != null) {
            all.addPolicyComponent((PolicyComponent)this.getSignatureToken());
        }
        if (this.getEncryptionToken() != null) {
            all.addPolicyComponent((PolicyComponent)this.getEncryptionToken());
        }
        if (this.isIncludeTimestamp()) {
            all.addPolicyComponent((PolicyComponent)SP12Constants.INCLUDE_TIMESTAMP_ASSERTION);
        }
        if (this.getLayout() != null) {
            all.addPolicyComponent((PolicyComponent)this.getLayout());
        }
        ea.addPolicyComponent((PolicyComponent)all);
        Policy pc = p.normalize(this.builder.getPolicyRegistry(), true);
        if (pc != null) {
            return pc;
        }
        return new Policy();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String wspPrefix;
        String prefix;
        String localname = this.getRealName().getLocalPart();
        String namespaceURI = this.getRealName().getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = this.getRealName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String policyLocalName = SPConstants.POLICY.getLocalPart();
        String policyNamespaceURI = SPConstants.POLICY.getNamespaceURI();
        String wspWriterPrefix = writer.getPrefix(policyNamespaceURI);
        if (wspWriterPrefix == null) {
            wspPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(wspPrefix, policyNamespaceURI);
        } else {
            wspPrefix = wspWriterPrefix;
        }
        writer.writeStartElement(wspPrefix, policyLocalName, policyNamespaceURI);
        if (this.encryptionToken != null) {
            this.encryptionToken.serialize(writer);
        } else if (this.protectionToken != null) {
            this.protectionToken.serialize(writer);
        } else {
            throw new RuntimeException("Either EncryptionToken or ProtectionToken must be set");
        }
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        if (algorithmSuite == null) {
            throw new RuntimeException("AlgorithmSuite must be set");
        }
        algorithmSuite.serialize(writer);
        Layout layout = this.getLayout();
        if (layout != null) {
            layout.serialize(writer);
        }
        if (this.isIncludeTimestamp()) {
            writer.writeStartElement(prefix, "IncludeTimestamp", namespaceURI);
            writer.writeEndElement();
        }
        if (SPConstants.ProtectionOrder.EncryptBeforeSigning == this.getProtectionOrder()) {
            writer.writeStartElement(prefix, "EncryptBeforeSigning", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isSignatureProtection()) {
            writer.writeStartElement(prefix, "EncryptSignature", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isEntireHeadersAndBodySignatures()) {
            writer.writeEmptyElement(prefix, "OnlySignEntireHeadersAndBody", namespaceURI);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

