/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.tcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.tcp.SoapTcpChannel;
import org.apache.cxf.binding.soap.tcp.SoapTcpUtils;
import org.apache.cxf.binding.soap.tcp.TCPConduit;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.Assertor;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;

public class BackendTcpConduit
extends AbstractConduit
implements Configurable,
Assertor {
    private static final Logger LOG = LogUtils.getL7dLogger(TCPConduit.class);
    private IoSession session;

    public BackendTcpConduit(IoSession session) {
        super(null);
        this.session = session;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public String getBeanName() {
        return null;
    }

    @Override
    public void assertMessage(Message message) {
    }

    @Override
    public boolean canAssert(QName type) {
        return false;
    }

    @Override
    public void prepare(Message message) throws IOException {
        message.setContent(OutputStream.class, new ByteArrayOutputStream(512));
    }

    @Override
    public void close(Message msg) throws IOException {
        ByteArrayOutputStream baos = (ByteArrayOutputStream)msg.getContent(OutputStream.class);
        Exchange exchange = msg.getExchange();
        SoapTcpChannel channel = exchange.getInMessage().getContent(SoapTcpChannel.class);
        String message = new String(baos.toByteArray());
        SoapTcpMessage soapTcpMessage = SoapTcpMessage.createSoapTcpMessage(message, channel.getChannelId());
        IoBuffer buffer = IoBuffer.allocate((int)512);
        buffer.setAutoExpand(true);
        SoapTcpUtils.writeSoapTcpMessage(buffer.asOutputStream(), soapTcpMessage);
        buffer.flip();
        this.session.write((Object)buffer);
    }
}

