/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.EndpointSelectionInterceptor;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.ws.addressing.JAXWSAConstants;

public class SoapActionInInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(SoapActionInInterceptor.class);

    public SoapActionInInterceptor() {
        super("read");
        this.addAfter(ReadHeadersInterceptor.class.getName());
        this.addAfter(EndpointSelectionInterceptor.class.getName());
    }

    public static String getSoapAction(Message m) {
        if (!(m instanceof SoapMessage)) {
            return null;
        }
        SoapMessage message = (SoapMessage)m;
        if (message.getVersion() instanceof Soap11) {
            List sa;
            Map headers = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
            if (headers != null && (sa = (List)headers.get("SOAPAction")) != null && sa.size() > 0) {
                String action = (String)sa.get(0);
                if (action.startsWith("\"")) {
                    action = action.substring(1, action.length() - 1);
                }
                return action;
            }
        } else if (message.getVersion() instanceof Soap12) {
            String ct = (String)message.get("Content-Type");
            if (ct == null) {
                return null;
            }
            int start = ct.indexOf("action=");
            if (start != -1) {
                int end;
                if (ct.charAt(start + 7) == '\"') {
                    end = ct.indexOf(34, start += 8);
                } else {
                    end = ct.indexOf(59, start += 7);
                    if (end == -1) {
                        end = ct.length();
                    }
                }
                return ct.substring(start, end);
            }
        }
        return null;
    }

    @Override
    public void handleMessage(SoapMessage message) throws Fault {
        if (this.isRequestor(message)) {
            return;
        }
        String action = SoapActionInInterceptor.getSoapAction(message);
        if (!StringUtils.isEmpty(action)) {
            SoapActionInInterceptor.getAndSetOperation(message, action);
            message.put("SOAPAction", (Object)action);
        }
    }

    public static void getAndSetOperation(SoapMessage message, String action) {
        if (StringUtils.isEmpty(action)) {
            return;
        }
        Exchange ex = message.getExchange();
        Endpoint ep = ex.get(Endpoint.class);
        if (ep == null) {
            return;
        }
        BindingOperationInfo bindingOp = null;
        Collection<BindingOperationInfo> bops = ep.getEndpointInfo().getBinding().getOperations();
        if (bops != null) {
            for (BindingOperationInfo boi : bops) {
                Object o;
                SoapOperationInfo soi = boi.getExtensor(SoapOperationInfo.class);
                if (soi != null && action.equals(soi.getAction())) {
                    if (bindingOp != null) {
                        return;
                    }
                    bindingOp = boi;
                }
                if ((o = boi.getOperationInfo().getInput().getExtensionAttribute(JAXWSAConstants.WSAM_ACTION_QNAME)) == null) {
                    o = boi.getOperationInfo().getInput().getExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME);
                }
                if (o == null || !action.equals(o.toString())) continue;
                if (bindingOp != null && bindingOp != boi) {
                    return;
                }
                bindingOp = boi;
            }
        }
        if (bindingOp == null) {
            message.getInterceptorChain().add(new SoapActionInAttemptTwoInterceptor());
            return;
        }
        ex.put(BindingOperationInfo.class, bindingOp);
        ex.put(OperationInfo.class, bindingOp.getOperationInfo());
    }

    public static class SoapActionInAttemptTwoInterceptor
    extends AbstractSoapInterceptor {
        public SoapActionInAttemptTwoInterceptor() {
            super("pre-logical");
        }

        @Override
        public void handleMessage(SoapMessage message) throws Fault {
            BindingOperationInfo boi = message.getExchange().getBindingOperationInfo();
            if (boi == null) {
                return;
            }
            String action = SoapActionInInterceptor.getSoapAction(message);
            if (StringUtils.isEmpty(action)) {
                return;
            }
            SoapOperationInfo soi = boi.getExtensor(SoapOperationInfo.class);
            if (soi == null || action.equals(soi.getAction())) {
                return;
            }
            Object o = boi.getOperationInfo().getInput().getExtensionAttribute(JAXWSAConstants.WSAM_ACTION_QNAME);
            if (o == null) {
                o = boi.getOperationInfo().getInput().getExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME);
            }
            if (o != null && action.equals(o.toString())) {
                return;
            }
            throw new Fault("SOAP_ACTION_MISMATCH", LOG, null, action);
        }
    }
}

