/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jetty.JettyContentExchange;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyHttpProducer
extends DefaultAsyncProducer
implements AsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(JettyHttpProducer.class);
    private HttpClient client;
    private boolean sharedClient;
    private JettyHttpBinding binding;

    public JettyHttpProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public JettyHttpProducer(Endpoint endpoint, HttpClient client) {
        super(endpoint);
        this.setClient(client);
    }

    public JettyHttpEndpoint getEndpoint() {
        return (JettyHttpEndpoint)super.getEndpoint();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.processInternal(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processInternal(Exchange exchange, AsyncCallback callback) throws Exception {
        String hostHeader;
        String url = HttpHelper.createURL((Exchange)exchange, (HttpCommonEndpoint)this.getEndpoint());
        URI uri = HttpHelper.createURI((Exchange)exchange, (String)url, (HttpCommonEndpoint)this.getEndpoint());
        String rewriteUrl = HttpHelper.urlRewrite((Exchange)exchange, (String)(url = uri.toASCIIString()), (HttpCommonEndpoint)this.getEndpoint(), (Producer)this);
        if (rewriteUrl != null) {
            url = rewriteUrl;
        }
        String methodName = HttpHelper.createMethod((Exchange)exchange, (HttpCommonEndpoint)this.getEndpoint(), (exchange.getIn().getBody() != null ? 1 : 0) != 0).name();
        JettyContentExchange httpExchange = this.getEndpoint().createContentExchange();
        httpExchange.init(exchange, this.getBinding(), this.client, callback);
        httpExchange.setURL(url);
        httpExchange.setMethod(methodName);
        if (this.getEndpoint().getHttpClientParameters() != null) {
            String supportRedirect;
            String timeout = (String)this.getEndpoint().getHttpClientParameters().get("timeout");
            if (timeout != null) {
                httpExchange.setTimeout(new Long(timeout));
            }
            if ((supportRedirect = (String)this.getEndpoint().getHttpClientParameters().get("supportRedirect")) != null) {
                httpExchange.setSupportRedirect(Boolean.valueOf(supportRedirect));
            }
        }
        LOG.trace("Using URL: {} with method: {}", (Object)url, (Object)methodName);
        if (exchange.getIn().getBody() != null) {
            String contentType = ExchangeHelper.getContentType((Exchange)exchange);
            if (contentType != null) {
                httpExchange.setRequestContentType(contentType);
            }
            if (contentType != null && "application/x-java-serialized-object".equals(contentType)) {
                if (!this.getEndpoint().getComponent().isAllowJavaSerializedObject() && !this.getEndpoint().isTransferException()) throw new RuntimeCamelException("Content-type application/x-java-serialized-object is not allowed");
                Serializable obj = (Serializable)exchange.getIn().getMandatoryBody(Serializable.class);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    HttpHelper.writeObjectToStream((OutputStream)bos, (Object)obj);
                    httpExchange.setRequestContent(bos.toByteArray());
                }
                finally {
                    IOHelper.close((Closeable)bos, (String)"body", (Logger)LOG);
                }
            } else {
                Object body = exchange.getIn().getBody();
                if (body instanceof String) {
                    String data = (String)body;
                    String charset = IOHelper.getCharsetName((Exchange)exchange, (boolean)false);
                    httpExchange.setRequestContent(data, charset);
                } else {
                    InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, exchange.getIn().getBody());
                    httpExchange.setRequestContent(is);
                    String length = (String)exchange.getIn().getHeader("Content-Length", String.class);
                    if (ObjectHelper.isNotEmpty((Object)length)) {
                        httpExchange.addRequestHeader("Content-Length", length);
                    }
                }
            }
        }
        Map skipRequestHeaders = null;
        if (this.getEndpoint().isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
            String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
            if (queryString != null) {
                skipRequestHeaders = URISupport.parseQuery((String)queryString, (boolean)false, (boolean)true);
            }
        }
        Message in = exchange.getIn();
        HeaderFilterStrategy strategy = this.getEndpoint().getHeaderFilterStrategy();
        for (Map.Entry entry : in.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object headerValue = in.getHeader(key);
            if (headerValue == null) continue;
            Iterator it = ObjectHelper.createIterator((Object)headerValue, null, (boolean)true);
            ArrayList<String> values = new ArrayList<String>();
            while (it.hasNext()) {
                String value = (String)exchange.getContext().getTypeConverter().convertTo(String.class, it.next());
                if (skipRequestHeaders != null && skipRequestHeaders.containsKey(key) || value == null || strategy == null || strategy.applyFilterToCamelHeaders(key, (Object)value, exchange)) continue;
                values.add(value);
            }
            if (values.size() <= 0) continue;
            String s = values.size() > 1 ? ((Object)values).toString() : (String)values.get(0);
            httpExchange.addRequestHeader(key, s);
        }
        if (this.getEndpoint().isPreserveHostHeader() && (hostHeader = (String)exchange.getIn().getHeader("Host", String.class)) != null) {
            httpExchange.addRequestHeader("Host", hostHeader);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending HTTP request to: {}", (Object)httpExchange.getUrl());
        }
        httpExchange.send(this.client);
    }

    public JettyHttpBinding getBinding() {
        return this.binding;
    }

    public void setBinding(JettyHttpBinding binding) {
        this.binding = binding;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public void setClient(HttpClient client) {
        this.client = client;
        this.sharedClient = false;
    }

    public HttpClient getSharedClient() {
        if (this.sharedClient) {
            return this.client;
        }
        return null;
    }

    public void setSharedClient(HttpClient sharedClient) {
        this.client = sharedClient;
        this.sharedClient = true;
    }

    private Object getClientThreadPool() {
        try {
            return this.client.getClass().getMethod("getThreadPool", new Class[0]).invoke((Object)this.client, new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void doStart() throws Exception {
        if (!this.sharedClient && this.client != null) {
            this.client.start();
            Object tp = this.getClientThreadPool();
            if (tp instanceof LifeCycle) {
                LOG.debug("Starting client thread pool {}", tp);
                ((LifeCycle)tp).start();
            }
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (!this.sharedClient && this.client != null) {
            this.client.stop();
            Object tp = this.getClientThreadPool();
            if (tp instanceof LifeCycle) {
                LOG.debug("Stopping client thread pool {}", tp);
                ((LifeCycle)tp).stop();
            }
        }
    }
}

