/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.trace.instrument.receivers;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.trace.instrument.receivers.SendSpansViaThrift;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ZooSpanClient
extends SendSpansViaThrift {
    private static final Logger log = Logger.getLogger(ZooSpanClient.class);
    private static final int TOTAL_TIME_WAIT_CONNECT_MS = 10000;
    private static final int TIME_WAIT_CONNECT_CHECK_MS = 100;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    ZooKeeper zoo = null;
    final String path;
    final Random random = new Random();
    final List<String> hosts = new ArrayList<String>();

    public ZooSpanClient(String keepers, final String path, String host, String service, long millis, int maxQueueSize) throws IOException, KeeperException, InterruptedException {
        super(host, service, millis, maxQueueSize);
        this.path = path;
        this.zoo = new ZooKeeper(keepers, 30000, new Watcher(){

            public void process(WatchedEvent event) {
                try {
                    if (ZooSpanClient.this.zoo != null) {
                        ZooSpanClient.this.updateHosts(path, ZooSpanClient.this.zoo.getChildren(path, null));
                    }
                }
                catch (Exception ex) {
                    log.error((Object)"unable to get destination hosts in zookeeper", (Throwable)ex);
                }
            }
        });
        for (int i = 0; i < 10000 && !this.zoo.getState().equals((Object)ZooKeeper.States.CONNECTED); i += 100) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                break;
            }
        }
        this.zoo.getChildren(path, true);
    }

    @Override
    public void flush() {
        if (!this.hosts.isEmpty()) {
            super.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void sendSpans() {
        if (this.hosts.isEmpty()) {
            if (!this.sendQueue.isEmpty()) {
                log.error((Object)"No hosts to send data to, dropping queued spans");
                AbstractQueue abstractQueue = this.sendQueue;
                synchronized (abstractQueue) {
                    this.sendQueue.clear();
                    this.sendQueue.notifyAll();
                }
            }
        } else {
            super.sendSpans();
        }
    }

    private synchronized void updateHosts(String path, List<String> children) {
        log.debug((Object)("Scanning trace hosts in zookeeper: " + path));
        try {
            ArrayList<String> hosts = new ArrayList<String>();
            for (String child : children) {
                byte[] data = this.zoo.getData(path + "/" + child, null, null);
                hosts.add(new String(data, UTF_8));
            }
            this.hosts.clear();
            this.hosts.addAll(hosts);
            log.debug((Object)("Trace hosts: " + this.hosts));
        }
        catch (Exception ex) {
            log.error((Object)"unable to get destination hosts in zookeeper", (Throwable)ex);
        }
    }

    @Override
    protected synchronized String getSpanKey(Map<String, String> data) {
        if (this.hosts.size() > 0) {
            String host = this.hosts.get(this.random.nextInt(this.hosts.size()));
            log.debug((Object)("sending data to " + host));
            return host;
        }
        return null;
    }
}

