/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.scalability;

import java.util.Properties;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.Text;

public abstract class ScaleTest {
    private Connector conn;
    private Properties scaleProps;
    private Properties testProps;
    private int numTabletServers;
    private long startTime;

    public void init(Properties scaleProps, Properties testProps, int numTabletServers) throws AccumuloException, AccumuloSecurityException {
        this.scaleProps = scaleProps;
        this.testProps = testProps;
        this.numTabletServers = numTabletServers;
        String instanceName = this.scaleProps.getProperty("INSTANCE_NAME");
        String zookeepers = this.scaleProps.getProperty("ZOOKEEPERS");
        String user = this.scaleProps.getProperty("USER");
        String password = this.scaleProps.getProperty("PASSWORD");
        System.out.println(password);
        this.conn = new ZooKeeperInstance((Configuration)new ClientConfiguration(new Configuration[0]).withInstance(instanceName).withZkHosts(zookeepers)).getConnector(user, (AuthenticationToken)new PasswordToken((CharSequence)password));
    }

    protected void startTimer() {
        this.startTime = System.currentTimeMillis();
    }

    protected void stopTimer(long numEntries, long numBytes) {
        long endTime = System.currentTimeMillis();
        System.out.printf("ELAPSEDMS %d %d %d%n", endTime - this.startTime, numEntries, numBytes);
    }

    public abstract void setup();

    public abstract void client();

    public abstract void teardown();

    public TreeSet<Text> calculateSplits() {
        long distance;
        int numSplits = this.numTabletServers - 1;
        long split = distance = Long.MAX_VALUE / (long)this.numTabletServers + 1L;
        TreeSet<Text> keys = new TreeSet<Text>();
        for (int i = 0; i < numSplits; ++i) {
            keys.add(new Text(String.format("%016x", split)));
            split += distance;
        }
        return keys;
    }

    public Connector getConnector() {
        return this.conn;
    }

    public String getTestProperty(String key) {
        return this.testProps.getProperty(key);
    }
}

