/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.scalability;

import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.test.continuous.ContinuousIngest;
import org.apache.accumulo.test.scalability.ScaleTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ingest
extends ScaleTest {
    private static final Logger log = LoggerFactory.getLogger(Ingest.class);

    @Override
    public void setup() {
        Connector conn = this.getConnector();
        String tableName = this.getTestProperty("TABLE");
        if (conn.tableOperations().exists(tableName)) {
            System.out.println("Deleting existing table: " + tableName);
            try {
                conn.tableOperations().delete(tableName);
            }
            catch (Exception e) {
                log.error("Failed to delete table '" + tableName + "'.", (Throwable)e);
            }
        }
        try {
            conn.tableOperations().create(tableName);
            conn.tableOperations().addSplits(tableName, this.calculateSplits());
            conn.tableOperations().setProperty(tableName, "table.split.threshold", "256M");
        }
        catch (Exception e) {
            log.error("Failed to create table '" + tableName + "'.", (Throwable)e);
        }
    }

    @Override
    public void client() {
        Connector conn = this.getConnector();
        String tableName = this.getTestProperty("TABLE");
        long maxMemory = Long.parseLong(this.getTestProperty("MAX_MEMORY"));
        long maxLatency = Long.parseLong(this.getTestProperty("MAX_LATENCY"));
        int maxWriteThreads = Integer.parseInt(this.getTestProperty("NUM_THREADS"));
        BatchWriter bw = null;
        try {
            bw = conn.createBatchWriter(tableName, new BatchWriterConfig().setMaxMemory(maxMemory).setMaxLatency(maxLatency, TimeUnit.MILLISECONDS).setMaxWriteThreads(maxWriteThreads));
        }
        catch (TableNotFoundException e) {
            log.error("Table '" + tableName + "' not found.", (Throwable)e);
            System.exit(-1);
        }
        Random r = new Random();
        String ingestInstanceId = UUID.randomUUID().toString();
        long numIngestEntries = Long.parseLong(this.getTestProperty("NUM_ENTRIES"));
        long minRow = 0L;
        long maxRow = Long.MAX_VALUE;
        int maxColF = Short.MAX_VALUE;
        int maxColQ = Short.MAX_VALUE;
        long count = 0L;
        long totalBytes = 0L;
        ColumnVisibility cv = new ColumnVisibility();
        this.startTimer();
        while (count < numIngestEntries) {
            long rowId = ContinuousIngest.genLong(minRow, maxRow, r);
            Mutation m = ContinuousIngest.genMutation(rowId, r.nextInt(maxColF), r.nextInt(maxColQ), cv, ingestInstanceId.getBytes(StandardCharsets.UTF_8), ++count, null, r, false);
            totalBytes += m.numBytes();
            try {
                bw.addMutation(m);
            }
            catch (MutationsRejectedException e) {
                log.error("Mutations rejected.", (Throwable)e);
                System.exit(-1);
            }
        }
        try {
            bw.close();
        }
        catch (MutationsRejectedException e) {
            log.error("Could not close BatchWriter due to mutations being rejected.", (Throwable)e);
            System.exit(-1);
        }
        this.stopTimer(count, totalBytes);
    }

    @Override
    public void teardown() {
        Connector conn = this.getConnector();
        String tableName = this.getTestProperty("TABLE");
        try {
            conn.tableOperations().delete(tableName);
        }
        catch (Exception e) {
            log.error("Failed to delete table '" + tableName + "'", (Throwable)e);
        }
    }
}

