/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.sequential;

import java.io.IOException;
import java.util.Iterator;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.DelegationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.log4j.Logger;

public class MapRedVerifyTool
extends Configured
implements Tool {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public int run(String[] args) throws Exception {
        Job job = Job.getInstance((org.apache.hadoop.conf.Configuration)this.getConf(), (String)((Object)((Object)this)).getClass().getSimpleName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        if (job.getJar() == null) {
            this.log.error((Object)"M/R requires a jar file!  Run mvn package.");
            return 1;
        }
        ClientConfiguration clientConf = ClientConfiguration.loadDefault().withInstance(args[3]).withZkHosts(args[4]);
        AccumuloInputFormat.setInputTableName((Job)job, (String)args[2]);
        AccumuloInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)clientConf);
        AccumuloOutputFormat.setDefaultTableName((Job)job, (String)args[5]);
        AccumuloOutputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)clientConf);
        job.setInputFormatClass(AccumuloInputFormat.class);
        if (clientConf.getBoolean(ClientConfiguration.ClientProperty.INSTANCE_RPC_SASL_ENABLED.getKey(), false)) {
            KerberosToken token = new KerberosToken();
            try {
                UserGroupInformation user = UserGroupInformation.getCurrentUser();
                if (!user.hasKerberosCredentials()) {
                    throw new IllegalStateException("Expected current user to have Kerberos credentials");
                }
                ZooKeeperInstance inst = new ZooKeeperInstance((Configuration)clientConf);
                String newPrincipal = user.getUserName();
                Connector conn = inst.getConnector(newPrincipal, (AuthenticationToken)token);
                if (!conn.securityOperations().hasSystemPermission(conn.whoami(), SystemPermission.OBTAIN_DELEGATION_TOKEN)) {
                    this.log.error((Object)(newPrincipal + " doesn't have the " + SystemPermission.OBTAIN_DELEGATION_TOKEN.name() + " SystemPermission neccesary to obtain a delegation token. MapReduce tasks cannot automatically use the client's" + " credentials on remote servers. Delegation tokens provide a means to run MapReduce without distributing the user's credentials."));
                    throw new IllegalStateException(conn.whoami() + " does not have permission to obtain a delegation token");
                }
                DelegationToken dt = conn.securityOperations().getDelegationToken(new DelegationTokenConfig());
                AccumuloInputFormat.setConnectorInfo((Job)job, (String)newPrincipal, (AuthenticationToken)dt);
                AccumuloOutputFormat.setConnectorInfo((Job)job, (String)newPrincipal, (AuthenticationToken)dt);
            }
            catch (Exception e) {
                String msg = "Failed to acquire DelegationToken for use with MapReduce";
                this.log.error((Object)"Failed to acquire DelegationToken for use with MapReduce", (Throwable)e);
                throw new RuntimeException("Failed to acquire DelegationToken for use with MapReduce", e);
            }
        } else {
            AccumuloInputFormat.setConnectorInfo((Job)job, (String)args[0], (AuthenticationToken)new PasswordToken((CharSequence)args[1]));
            AccumuloOutputFormat.setConnectorInfo((Job)job, (String)args[0], (AuthenticationToken)new PasswordToken((CharSequence)args[1]));
        }
        job.setMapperClass(SeqMapClass.class);
        job.setMapOutputKeyClass(NullWritable.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setReducerClass(SeqReduceClass.class);
        job.setNumReduceTasks(1);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        AccumuloOutputFormat.setCreateTables((Job)job, (boolean)true);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static class SeqReduceClass
    extends Reducer<NullWritable, IntWritable, Text, Mutation> {
        public void reduce(NullWritable ignore, Iterable<IntWritable> values, Reducer.Context output) throws IOException, InterruptedException {
            int start;
            Iterator<IntWritable> iterator = values.iterator();
            if (!iterator.hasNext()) {
                return;
            }
            int index = start = iterator.next().get();
            while (iterator.hasNext()) {
                int next = iterator.next().get();
                if (next != index + 1) {
                    this.writeMutation(output, start, index);
                    start = next;
                }
                index = next;
            }
            this.writeMutation(output, start, index);
        }

        public void writeMutation(Reducer.Context output, int start, int end) throws IOException, InterruptedException {
            Mutation m = new Mutation(new Text(String.format("%010d", start)));
            m.put(new Text(String.format("%010d", end)), new Text(""), new Value(new byte[0]));
            output.write(null, (Object)m);
        }
    }

    public static class SeqMapClass
    extends Mapper<Key, Value, NullWritable, IntWritable> {
        public void map(Key row, Value data, Mapper.Context output) throws IOException, InterruptedException {
            Integer num = Integer.valueOf(row.getRow().toString());
            output.write((Object)NullWritable.get(), (Object)new IntWritable(num.intValue()));
        }
    }
}

